/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.util;

import com.tridium.nre.util.NamedThreadFactory;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RetryUtil {
    public static final ExceptionHandler<Exception, Exception> DEFAULT_HANDLER = exception -> exception;
    public static final Function<Integer, Integer> EXPONENTIAL_250MS_WAIT = callCount -> (int)(250.0 * Math.pow(1.5, (double)callCount.intValue() - 1.0));
    public static final Function<Integer, Integer> LINEAR_250MS_WAIT = callCount -> 250 * callCount;
    public static final Function<Integer, Integer> LINEAR_500MS_WAIT = callCount -> 500 * callCount;
    public static final String EXECUTOR_THREAD_NAME_PREFIX = "RetryUtilThread";
    private static final Logger logger = Logger.getLogger(RetryUtil.class.getName());

    public static <T, OE extends Exception, RE extends OE> Operation<T, RE> make(Operation<T, OE> operation, ExceptionHandler<OE, RE> exceptionHandler, Function<Integer, Integer> nextCallTimeFunc, int timeoutMS) {
        Future future = RetryUtil.makeFuture(operation, exceptionHandler, nextCallTimeFunc, timeoutMS);
        return () -> {
            try {
                return future.get();
            }
            catch (ExecutionException e) {
                Exception castUtil = (Exception)e.getCause();
                throw castUtil;
            }
        };
    }

    public static <OE extends Exception, RE extends OE> Operation<Void, RE> make(VoidOperation<OE> operation, ExceptionHandler<OE, RE> exceptionHandler, Function<Integer, Integer> nextCallTimeFunc, int timeoutMS) {
        Operation voidOperation = () -> {
            operation.call();
            return null;
        };
        return RetryUtil.make(voidOperation, exceptionHandler, nextCallTimeFunc, timeoutMS);
    }

    public static <T, OE extends Throwable, RE extends OE> Future<T> makeFuture(Operation<T, OE> operation, ExceptionHandler<OE, RE> exceptionHandler, Function<Integer, Integer> nextCallTimeFunc, int timeoutMS) {
        return RetryUtil.makeFuture(RetryUtil.createSingleThreadedExecutor(), operation, exceptionHandler, nextCallTimeFunc, timeoutMS);
    }

    public static <OE extends Throwable, RE extends OE> Future<Void> makeFuture(VoidOperation<OE> operation, ExceptionHandler<OE, RE> exceptionHandler, Function<Integer, Integer> nextCallTimeFunc, int timeoutMS) {
        return RetryUtil.makeFuture(RetryUtil.createSingleThreadedExecutor(), operation, exceptionHandler, nextCallTimeFunc, timeoutMS);
    }

    public static <T, OE extends Throwable, RE extends OE> Future<T> makeFuture(ScheduledExecutorService executorService, Operation<T, OE> operation, ExceptionHandler<OE, RE> exceptionHandler, Function<Integer, Integer> nextCallTimeFunc, int timeoutMS) {
        return new RetryingFuture(executorService, operation, exceptionHandler, nextCallTimeFunc, timeoutMS);
    }

    public static <OE extends Throwable, RE extends OE> Future<Void> makeFuture(ScheduledExecutorService executorService, VoidOperation<OE> operation, ExceptionHandler<OE, RE> exceptionHandler, Function<Integer, Integer> nextCallTimeFunc, int timeoutMS) {
        Operation voidOperation = () -> {
            operation.call();
            return null;
        };
        return RetryUtil.makeFuture(executorService, voidOperation, exceptionHandler, nextCallTimeFunc, timeoutMS);
    }

    private static final ScheduledExecutorService createSingleThreadedExecutor() {
        ScheduledThreadPoolExecutor service = new ScheduledThreadPoolExecutor(0, (ThreadFactory)new NamedThreadFactory(EXECUTOR_THREAD_NAME_PREFIX));
        service.setMaximumPoolSize(1);
        service.setKeepAliveTime(0L, TimeUnit.MILLISECONDS);
        return service;
    }

    private static class RetryingFuture<T, OE extends Throwable, RE extends OE>
    extends CompletableFuture<T> {
        private Operation<T, OE> operation;
        private ExceptionHandler<OE, RE> exceptionHandler;
        private Function<Integer, Integer> nextCallTimeFunc;
        private int timeoutMS;
        private int callCount = 0;
        private long startTime;
        private ScheduledExecutorService executor;

        private RetryingFuture(ScheduledExecutorService executor, Operation<T, OE> operation, ExceptionHandler<OE, RE> exceptionHandler, Function<Integer, Integer> nextCallTimeFunc, int timeoutMS) {
            this.executor = executor;
            this.operation = operation;
            this.exceptionHandler = exceptionHandler;
            this.nextCallTimeFunc = nextCallTimeFunc;
            this.timeoutMS = timeoutMS;
            this.startTime = System.currentTimeMillis();
            executor.schedule(this::callOperation, 0L, TimeUnit.MILLISECONDS);
        }

        private void callOperation() {
            try {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.FINEST, String.format("Calling operation [%s]", this.operation));
                }
                this.complete(this.operation.call());
            }
            catch (Throwable exception) {
                this.retryOrFail(exception);
            }
        }

        private void retryOrFail(Throwable exception) {
            Throwable handledException;
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, String.format("Operation [%s] threw exception", this.operation), exception);
            }
            if (exception instanceof InterruptedException) {
                handledException = exception;
            } else {
                try {
                    Throwable castUtil = exception;
                    handledException = this.exceptionHandler.handleException(castUtil);
                }
                catch (Throwable fatalException) {
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.log(Level.FINEST, String.format("Not retrying [%s]. Exception handler threw fatal exception", this.operation), fatalException);
                    }
                    this.completeExceptionally(fatalException);
                    return;
                }
            }
            if (this.isCancelled()) {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest(String.format("Operation [%s] was cancelled", this.operation));
                }
                return;
            }
            long elapsedTime = System.currentTimeMillis() - this.startTime;
            ++this.callCount;
            int nextCallTime = this.nextCallTimeFunc.apply(this.callCount);
            if (nextCallTime > this.timeoutMS || elapsedTime > (long)this.timeoutMS) {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest(String.format("Not retrying [%s] due to timeout: timeout = %dms, call count = %d, elapsed time = %dms, next call time = %dms", this.operation, this.timeoutMS, this.callCount, elapsedTime, nextCallTime));
                }
                this.completeExceptionally(handledException);
                return;
            }
            long delay = Math.max(0L, (long)nextCallTime - elapsedTime);
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(String.format("Retrying [%s]: timeout = %dms, call count = %d, elapsed time = %dms, next call time = %dms", this.operation, this.timeoutMS, this.callCount, elapsedTime, nextCallTime));
            }
            try {
                this.executor.schedule(this::callOperation, delay, TimeUnit.MILLISECONDS);
            }
            catch (RejectedExecutionException e) {
                logger.log(Level.SEVERE, String.format("Unable to reschedule operation [%s]", this.operation), e);
                this.completeExceptionally(handledException);
            }
        }
    }

    @FunctionalInterface
    public static interface ExceptionHandler<OE extends Throwable, RE extends OE> {
        public RE handleException(OE var1) throws RE, InterruptedException;
    }

    @FunctionalInterface
    public static interface VoidOperation<E extends Throwable> {
        public void call() throws E, InterruptedException;
    }

    @FunctionalInterface
    public static interface Operation<T, E extends Throwable> {
        public T call() throws E, InterruptedException;
    }
}

