/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.util;

import com.tridium.util.EscUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.baja.file.FilePath;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.SyntaxException;
import javax.baja.naming.ViewQuery;
import javax.baja.session.INiagaraSuperSession;
import javax.baja.session.SessionUtil;
import javax.baja.spy.BSpy;
import javax.baja.spy.Spy;
import javax.baja.spy.SpyWriter;

public final class SpyUtil {
    private static final Spy DECONTAMINATED_SPY = new Spy(){

        @Override
        public void write(SpyWriter out) {
            out.w(SpyUtil.DECONTAMINATED_SPY_CONTENTS);
        }
    };
    public static final String DECONTAMINATED_SPY_NAME = EscUtil.slot.escape("$DECONTAMINATED");
    public static final String ORIGINAL_SPY_BODY_VIEW_PARAMETER = EscUtil.slot.escape("$ORIG_BODY");
    public static final String DECONTAMINATED_SPY_CONTENTS = "Decontaminated";
    private static final String CSRF_TOKEN_PREFIX = EscUtil.slot.escape("?token=");
    private static final Pattern CSRF_TOKEN_PATTERN = Pattern.compile("^(.*)\\$3ftoken\\$3d(.*)$", 2);

    private SpyUtil() {
    }

    public static boolean isRadioactive(BOrd ord) {
        OrdQuery spyQuery = SpyUtil.getOrdQuery(ord.normalize(), "spy");
        return spyQuery != null && !spyQuery.getBody().equals(DECONTAMINATED_SPY_NAME);
    }

    public static boolean isDecontaminated(BOrd ord) {
        OrdQuery spyQuery = SpyUtil.getOrdQuery(ord.normalize(), "spy");
        return spyQuery != null && spyQuery.getBody().equals(DECONTAMINATED_SPY_NAME);
    }

    public static BOrd stripAuthorization(BOrd ord) {
        return SpyUtil.transformOrd(ord, query -> {
            if (query.getScheme().equals("spy")) {
                String body = query.getBody();
                Matcher m = CSRF_TOKEN_PATTERN.matcher(body);
                return new FilePath("spy", m.find() ? m.group(1) : body);
            }
            return query;
        });
    }

    public static BOrd decontaminate(BOrd ord) {
        ord = ord.normalize();
        OrdQuery spyQuery = SpyUtil.getOrdQuery(ord, "spy");
        ViewQuery viewQuery = (ViewQuery)SpyUtil.getOrdQuery(ord, "view");
        if (spyQuery == null) {
            return ord;
        }
        return BOrd.make("spy:" + DECONTAMINATED_SPY_NAME + "|" + SpyUtil.withParam(viewQuery, ORIGINAL_SPY_BODY_VIEW_PARAMETER, spyQuery.getBody()));
    }

    public static BOrd restoreRadioactivity(BOrd ord) {
        OrdQuery spyQuery = SpyUtil.getOrdQuery(ord, "spy");
        if (spyQuery == null || SpyUtil.isRadioactive(ord)) {
            throw new IllegalArgumentException("ord was not decontaminated");
        }
        ViewQuery viewQuery = (ViewQuery)SpyUtil.getOrdQuery(ord, "view");
        String origBody = viewQuery.getParameter(ORIGINAL_SPY_BODY_VIEW_PARAMETER);
        BOrd spyOrd = SpyUtil.transformOrd(ord, query -> {
            if (query.getScheme().equals("spy")) {
                return new FilePath("spy", origBody);
            }
            if (query.getScheme().equals("view")) {
                return SpyUtil.withoutParam((ViewQuery)query, ORIGINAL_SPY_BODY_VIEW_PARAMETER);
            }
            return query;
        });
        return spyOrd.normalize();
    }

    public static BOrd injectCsrfToken(BOrd spyOrd, String csrfToken) {
        return SpyUtil.transformOrd(spyOrd, query -> {
            if (query.getScheme().equals("spy")) {
                String body = query.getBody();
                if (CSRF_TOKEN_PATTERN.matcher(body).find()) {
                    throw new IllegalArgumentException("csrf token already present");
                }
                return new FilePath("spy", query.getBody() + EscUtil.slot.escape("?token=" + csrfToken));
            }
            return query;
        });
    }

    public static BSpy makeInertSpy(FilePath path) {
        return BSpy.make(path, DECONTAMINATED_SPY);
    }

    /*
     * Exception decompiling
     */
    public static String getSpyContents(Spy spy, FilePath filePath) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String getRequestedName(String href) {
        Matcher m = CSRF_TOKEN_PATTERN.matcher(href);
        return m.find() ? m.group(1) : href;
    }

    public static ViewQuery withParam(ViewQuery viewQuery, String name, String value) {
        if (viewQuery == null) {
            return new ViewQuery("?" + name + "=" + value);
        }
        String id = viewQuery.getViewId();
        String body = viewQuery.getBody();
        if (id == null) {
            id = "";
        }
        body = body.length() == id.length() ? body + "?" : body + ";";
        body = body + name + "=" + value;
        return new ViewQuery(viewQuery.getScheme(), body);
    }

    public static ViewQuery withoutParam(ViewQuery viewQuery, String name) {
        String body;
        HashMap<String, String> params = new HashMap<String, String>(viewQuery.getParameters());
        params.remove(name);
        String paramsString = params.entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining(";"));
        String id = viewQuery.getViewId();
        if (id == null) {
            if (paramsString.isEmpty()) {
                return null;
            }
            body = "?" + paramsString;
        } else {
            body = id;
            if (!paramsString.isEmpty()) {
                body = body + "?" + paramsString;
            }
        }
        return new ViewQuery(viewQuery.getScheme(), body);
    }

    public static String addCsrfToken(String hrefName) {
        INiagaraSuperSession session = SessionUtil.getCurrentNiagaraSuperSession();
        if (session != null) {
            return hrefName + CSRF_TOKEN_PREFIX + EscUtil.slot.escape(session.getCsrfToken());
        }
        return hrefName;
    }

    private static BOrd transformOrd(BOrd ord, Function<OrdQuery, OrdQuery> transform) {
        List<OrdQuery> ordQueries;
        try {
            ordQueries = Arrays.asList(ord.parse());
        }
        catch (SyntaxException e) {
            return ord;
        }
        return BOrd.make((OrdQuery[])ordQueries.stream().map(transform).filter(Objects::nonNull).toArray(OrdQuery[]::new));
    }

    private static OrdQuery getOrdQuery(BOrd ord, String scheme) {
        for (OrdQuery q : ord.parse()) {
            if (!q.getScheme().equals(scheme)) continue;
            return q;
        }
        return null;
    }
}

