/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.util.graph;

import com.tridium.util.graph.CyclicGraphException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Digraph<T> {
    private static final int WHITE = 0;
    private static final int GRAY = 1;
    private static final int BLACK = 2;
    private Map<T, Vertex<T>> graph = new HashMap<T, Vertex<T>>();

    public boolean hasVertex(T obj) {
        return this.graph.get(obj) != null;
    }

    public void addVertex(T vertex) {
        try {
            this.addEdge(vertex, null);
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException("vertex cannot be null.");
        }
    }

    public void addEdge(T fromVertex, T toVertex) {
        if (fromVertex == null) {
            throw new IllegalArgumentException("fromVertex cannot be null.");
        }
        Vertex<T> vf = this.getVertex(fromVertex);
        if (toVertex != null) {
            Vertex<T> vt = this.getVertex(toVertex);
            ((Vertex)vf).kids.add(vt);
        }
    }

    public void removeEdge(T fromVertex, T toVertex) {
        if (fromVertex == null) {
            throw new IllegalArgumentException("fromVertex cannot be null.");
        }
        Vertex<T> vert = this.graph.get(fromVertex);
        if (vert == null) {
            return;
        }
        if (toVertex != null) {
            ((Vertex)vert).kids.remove(toVertex);
        } else {
            ((Vertex)vert).kids.clear();
            this.graph.remove(fromVertex);
            for (Vertex<T> v : this.graph.values()) {
                ((Vertex)v).kids.remove(vert);
            }
        }
    }

    public void removeVertex(T vertex) {
        try {
            this.removeEdge(vertex, null);
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException("vertex cannot be null.");
        }
    }

    @Deprecated
    public T[] getNeighbors(T fromVertex) {
        if (fromVertex == null) {
            throw new IllegalArgumentException("fromVertex cannot be null.");
        }
        Vertex<T> vx = this.getVertex(fromVertex);
        if (vx == null) {
            throw new IllegalArgumentException("fromVertex is not in the graph.");
        }
        Iterator iter = ((Vertex)vx).kids.iterator();
        ArrayList<Object> listOfNeighbors = new ArrayList<Object>(((Vertex)vx).kids.size());
        while (iter.hasNext()) {
            listOfNeighbors.add(((Vertex)iter.next()).obj);
        }
        Object[] arrayOfNeighbors = listOfNeighbors.toArray();
        return arrayOfNeighbors;
    }

    public List<T> getNeighborsAsList(T fromVertex) {
        if (fromVertex == null) {
            throw new IllegalArgumentException("fromVertex cannot be null.");
        }
        Vertex<T> vx = this.getVertex(fromVertex);
        if (vx == null) {
            throw new IllegalArgumentException("fromVertex is not in the graph.");
        }
        Iterator iter = ((Vertex)vx).kids.iterator();
        ArrayList<Object> listOfNeighbors = new ArrayList<Object>(((Vertex)vx).kids.size());
        while (iter.hasNext()) {
            listOfNeighbors.add(((Vertex)iter.next()).obj);
        }
        return listOfNeighbors;
    }

    @Deprecated
    public T[] topologicalSort() {
        List<T> list = this.topologicalSortList();
        Object[] array = list.toArray();
        return array;
    }

    public List<T> topologicalSortList() {
        final LinkedList list = new LinkedList();
        DepthFirstSearch dfs = new DepthFirstSearch(){

            @Override
            protected void visit(Vertex<T> vert) {
                super.visit(vert);
                list.addFirst(vert.obj);
            }
        };
        dfs.search();
        return list;
    }

    public boolean isCyclic() {
        try {
            new DepthFirstSearch().search();
            return false;
        }
        catch (CyclicGraphException e) {
            return true;
        }
    }

    private Vertex<T> getVertex(T obj) {
        Vertex<T> vert = this.graph.get(obj);
        if (vert == null) {
            vert = new Vertex<T>(obj);
            this.graph.put(obj, vert);
        }
        return vert;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Vertex<T> vert : this.graph.values()) {
            sb.append(((Vertex)vert).obj).append(": ").append(((Vertex)vert).kids).append("\n");
        }
        return sb.toString();
    }

    private static class Vertex<T> {
        private T obj;
        private int color = 0;
        private Set<Vertex<T>> kids = new HashSet<Vertex<T>>();

        public Vertex(T obj) {
            this.obj = obj;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Vertex other = (Vertex)obj;
            return !(this.obj == null ? other.obj != null : !this.obj.equals(other.obj));
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.obj == null ? 0 : this.obj.hashCode());
            return result;
        }

        public String toString() {
            return this.obj.toString();
        }
    }

    private class DepthFirstSearch {
        private DepthFirstSearch() {
        }

        private void search() {
            for (Vertex vert : Digraph.this.graph.values()) {
                vert.color = 0;
            }
            for (Vertex vert : Digraph.this.graph.values()) {
                switch (vert.color) {
                    case 1: {
                        throw new IllegalStateException();
                    }
                    case 0: {
                        this.visit(vert);
                    }
                }
            }
        }

        protected void visit(Vertex<T> vert) {
            vert.color = 1;
            for (Vertex child : vert.kids) {
                switch (child.color) {
                    case 1: {
                        throw new CyclicGraphException(vert.toString() + " has cyclic dependency on " + child.toString(), vert.obj, child.obj);
                    }
                    case 0: {
                        this.visit(child);
                    }
                }
            }
            vert.color = 2;
        }
    }
}

