/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.util.warmup;

import com.tridium.util.warmup.BWarmupConfig;
import com.tridium.util.warmup.BWarmupEnableEnum;
import java.security.AccessController;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BPermissions;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIMixIn;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="status", type="BStatus", defaultValue="BStatus.ok", flags=3), @NiagaraProperty(name="faultCause", type="String", defaultValue="", flags=3), @NiagaraProperty(name="enabled", type="BWarmupEnableEnum", defaultValue="BWarmupEnableEnum.whenUserActivityFound"), @NiagaraProperty(name="running", type="boolean", defaultValue="false", flags=3), @NiagaraProperty(name="interrupted", type="boolean", defaultValue="false", flags=3), @NiagaraProperty(name="userActivityFound", type="boolean", defaultValue="false", flags=1), @NiagaraProperty(name="recentUserActivityFound", type="boolean", defaultValue="false", flags=3), @NiagaraProperty(name="lastWarmupTime", type="BRelTime", defaultValue="BRelTime.DEFAULT", flags=1, facets={@Facet(name="BFacets.SHOW_MILLISECONDS", value="BBoolean.TRUE"), @Facet(name="BFacets.MIN", value="BRelTime.make(1)")})})
@NiagaraActions(value={@NiagaraAction(name="warmup", flags=16), @NiagaraAction(name="resetUserActivity")})
public abstract class BWarmup
extends BComponent
implements BIMixIn {
    @Generated
    public static final Property status = BWarmup.newProperty(3, BStatus.ok, null);
    @Generated
    public static final Property faultCause = BWarmup.newProperty(3, "", null);
    @Generated
    public static final Property enabled = BWarmup.newProperty(0, BWarmupEnableEnum.whenUserActivityFound, null);
    @Generated
    public static final Property running = BWarmup.newProperty(3, false, null);
    @Generated
    public static final Property interrupted = BWarmup.newProperty(3, false, null);
    @Generated
    public static final Property userActivityFound = BWarmup.newProperty(1, false, null);
    @Generated
    public static final Property recentUserActivityFound = BWarmup.newProperty(3, false, null);
    @Generated
    public static final Property lastWarmupTime = BWarmup.newProperty(1, BRelTime.DEFAULT, BFacets.make(BFacets.make("showMilliseconds", BBoolean.TRUE), BFacets.make("min", BRelTime.make(1L))));
    @Generated
    public static final Action warmup = BWarmup.newAction(16, null);
    @Generated
    public static final Action resetUserActivity = BWarmup.newAction(0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BWarmup.class);
    protected volatile WarmupThread warmupThread;
    protected volatile boolean hasUserActivity;
    private static final BIcon ICON = BIcon.std("log.png");
    private static final Logger LOGGER = Logger.getLogger("web.warmup");
    private static final double CONVERT_TO_MILLIS = 1000000.0;
    private static final Object monitor = new Object();

    @Generated
    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    @Generated
    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    @Generated
    public String getFaultCause() {
        return this.getString(faultCause);
    }

    @Generated
    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    @Generated
    public BWarmupEnableEnum getEnabled() {
        return (BWarmupEnableEnum)this.get(enabled);
    }

    @Generated
    public void setEnabled(BWarmupEnableEnum v) {
        this.set(enabled, (BValue)v, null);
    }

    @Generated
    public boolean getRunning() {
        return this.getBoolean(running);
    }

    @Generated
    public void setRunning(boolean v) {
        this.setBoolean(running, v, null);
    }

    @Generated
    public boolean getInterrupted() {
        return this.getBoolean(interrupted);
    }

    @Generated
    public void setInterrupted(boolean v) {
        this.setBoolean(interrupted, v, null);
    }

    @Generated
    public boolean getUserActivityFound() {
        return this.getBoolean(userActivityFound);
    }

    @Generated
    public void setUserActivityFound(boolean v) {
        this.setBoolean(userActivityFound, v, null);
    }

    @Generated
    public boolean getRecentUserActivityFound() {
        return this.getBoolean(recentUserActivityFound);
    }

    @Generated
    public void setRecentUserActivityFound(boolean v) {
        this.setBoolean(recentUserActivityFound, v, null);
    }

    @Generated
    public BRelTime getLastWarmupTime() {
        return (BRelTime)this.get(lastWarmupTime);
    }

    @Generated
    public void setLastWarmupTime(BRelTime v) {
        this.set(lastWarmupTime, (BValue)v, null);
    }

    @Generated
    public void warmup() {
        this.invoke(warmup, null, null);
    }

    @Generated
    public void resetUserActivity() {
        this.invoke(resetUserActivity, null, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public abstract void runWarmup() throws Exception;

    public boolean isEnabled() {
        return this.getEnabled().equals(BWarmupEnableEnum.yes) || this.getEnabled().equals(BWarmupEnableEnum.whenUserActivityFound) && this.getUserActivityFound();
    }

    @Override
    public void started() throws Exception {
        this.setStatus(this.isEnabled() ? BStatus.ok : BStatus.disabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IFuture post(Action action, BValue argument, Context cx) {
        if (action.equals(warmup)) {
            Object object = monitor;
            synchronized (object) {
                if (this.warmupThread != null && this.warmupThread.isAlive()) {
                    LOGGER.warning("Warm up is already running, please wait for previous warmup to complete.");
                    return null;
                }
                this.warmupThread = new WarmupThread(cx);
                this.warmupThread.start();
                return null;
            }
        }
        return super.post(action, argument, cx);
    }

    @Override
    public void changed(Property p, Context cx) {
        if (!this.isRunning()) {
            return;
        }
        if (p.equals(enabled) || p.equals(userActivityFound)) {
            this.setStatus(this.isEnabled() ? BStatus.ok : BStatus.disabled);
        } else if (p.equals(recentUserActivityFound) && this.getRecentUserActivityFound() && !this.getUserActivityFound()) {
            this.setUserActivityFound(true);
        }
    }

    public void warmupCompleted(BRelTime time, Context cx) {
        Level level = cx != null ? Level.INFO : Level.FINE;
        LOGGER.log(level, this.getType() + " warmup completed in " + time);
    }

    public final void doWarmup(Context cx) throws Exception {
        if (!this.isEnabled()) {
            return;
        }
        if (!this.getPermissions(cx).hasAdminInvoke()) {
            LOGGER.warning("warm up requires Superuser permissions");
            return;
        }
        this.setRunning(true);
        this.setInterrupted(false);
        long start = Clock.nanoTicks();
        try {
            this.runWarmup();
            double end = Clock.nanoTicks();
            BRelTime time = BRelTime.make((long)((end - (double)start) / 1000000.0));
            this.setLastWarmupTime(time);
            this.warmupCompleted(time, cx);
            this.setStatus(this.isEnabled() ? BStatus.ok : BStatus.disabled);
            this.setFaultCause("");
        }
        catch (Throwable e) {
            double end = Clock.nanoTicks();
            BRelTime time = BRelTime.make((long)((end - (double)start) / 1000000.0));
            this.setLastWarmupTime(time);
            if (e instanceof InterruptedException || e instanceof BWarmupConfig.WarmupInterruptError) {
                this.setInterrupted(true);
                this.warmupCompleted(time, cx);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, this.getType() + " interrupted", e);
                }
            } else {
                LOGGER.log(Level.SEVERE, this.getType() + " could not be completed", e);
                this.setStatus(BStatus.fault);
                this.setFaultCause(e.toString());
            }
            throw e;
        }
        finally {
            this.setRunning(false);
        }
    }

    public void doResetUserActivity(Context cx) throws Exception {
        this.setRecentUserActivityFound(false);
        this.setUserActivityFound(false);
    }

    @Override
    public String getDisplayNameInParent(Context cx) {
        return this.getType().getDisplayName(cx);
    }

    @Override
    public BPermissions getPermissions(Context cx) {
        if (cx != null && cx.getUser() != null && !cx.getUser().getPermissions().isSuperUser()) {
            if (super.getPermissions(cx).hasOperatorRead()) {
                return BPermissions.operatorRead;
            }
            return BPermissions.none;
        }
        return super.getPermissions(cx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void killThread() throws Exception {
        Object object = monitor;
        synchronized (object) {
            if (this.warmupThread != null) {
                this.warmupThread.kill();
            }
        }
    }

    @Override
    public BIcon getIcon() {
        return ICON;
    }

    public void userActivity() {
        if (!this.hasUserActivity) {
            this.hasUserActivity = true;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("First user Activity for " + this.getType());
            }
            this.setRecentUserActivityFound(true);
            BComplex parent = this.getParent();
            if (parent instanceof BWarmupConfig) {
                ((BWarmupConfig)parent).userActivity();
            }
        }
    }

    public static boolean isMainWarmup(Type serviceType, BWarmup warmup) {
        BComponent service = Sys.findService(serviceType).orElse(null);
        if (service != null) {
            BObject[] configs;
            BComplex parent = warmup.getParent();
            if (parent == service) {
                BWarmup[] warmups = (BWarmup[])service.getChildren(warmup.getClass());
                if (warmups.length > 0 && warmups[0] == warmup) {
                    return true;
                }
            } else if (parent instanceof BWarmupConfig && parent.asComponent().getParent() == service && (configs = (BObject[])service.getChildren(parent.getClass())).length > 0 && configs[0] == parent) {
                BValue mixIn = parent.asComponent().getMixIn(warmup.getType());
                return mixIn == warmup;
            }
        }
        return false;
    }

    protected class WarmupThread
    extends Thread {
        private volatile boolean isAlive;
        private final Context cx;

        WarmupThread(Context cx) {
            super(BWarmup.this.getType() + "Warmup");
            this.setPriority(this.getPriority() - 1);
            this.isAlive = true;
            this.cx = cx;
        }

        @Override
        public void run() {
            try {
                BWarmup.this.doWarmup(this.cx);
            }
            catch (BWarmupConfig.WarmupInterruptError | Exception throwable) {
                // empty catch block
            }
        }

        @Override
        public boolean isInterrupted() {
            if (!this.isAlive) {
                return true;
            }
            return super.isInterrupted();
        }

        public void kill() throws Exception {
            AccessController.doPrivileged(() -> {
                this.isAlive = false;
                this.interrupt();
                return null;
            });
        }
    }
}

