/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.util.warmup;

import com.tridium.util.warmup.BWarmup;
import com.tridium.util.warmup.BWarmupEnableEnum;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperty(name="enabled", type="BWarmupEnableEnum", defaultValue="BWarmupEnableEnum.yes", override=true)
@NiagaraAction(name="cancelWarmup")
public class BWarmupConfig
extends BWarmup {
    @Generated
    public static final Property enabled = BWarmupConfig.newProperty(0, BWarmupEnableEnum.yes, null);
    @Generated
    public static final Action cancelWarmup = BWarmupConfig.newAction(0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BWarmupConfig.class);
    private static final Logger LOGGER = Logger.getLogger("web.warmup");
    private BAbsTime firstUserActivity;
    private boolean mixInsEnabled;

    @Generated
    public void cancelWarmup() {
        this.invoke(cancelWarmup, null, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public void started() throws Exception {
        this.toggleMixIns(true);
        super.started();
    }

    @Override
    public void stationStarted() {
        if (this.isEnabled()) {
            this.warmup();
        }
    }

    @Override
    public void changed(Property p, Context cx) {
        super.changed(p, cx);
        if (this.isRunning() && (p.equals(enabled) || p.equals(userActivityFound))) {
            this.toggleMixIns(true);
        }
    }

    @Override
    public void userActivity() {
        if (!this.hasUserActivity) {
            this.hasUserActivity = true;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("First user Activity for " + this.getType());
            }
            this.firstUserActivity = BAbsTime.now();
            this.setRecentUserActivityFound(true);
            if (this.isRunning()) {
                this.doCancelWarmup(null);
            }
        }
    }

    private void toggleMixIns(boolean running) {
        if (running && this.isEnabled() && this.mixInsEnabled || this.getComponentSpace() == null) {
            return;
        }
        AgentList warmupAgents = this.getAgents(null).filter(AgentFilter.is(BWarmup.TYPE));
        for (int i = 0; i < warmupAgents.size(); ++i) {
            AgentInfo info = warmupAgents.get(i);
            if (info.getAgentType().isAbstract()) continue;
            try {
                if (running && this.isEnabled()) {
                    this.getComponentSpace().enableMixIn(info.getAgentType().getTypeSpec().getResolvedType());
                    this.mixInsEnabled = true;
                    continue;
                }
                this.getComponentSpace().disableMixIn(info.getAgentType().getTypeSpec().getResolvedType());
                this.mixInsEnabled = false;
                continue;
            }
            catch (Exception e) {
                if (running && this.isEnabled()) {
                    LOGGER.log(Level.SEVERE, "Cannot register Warmup agent " + info.getAgentType() + " on" + this.getType(), e);
                    continue;
                }
                LOGGER.log(Level.SEVERE, "Cannot unregister Warmup agent " + info.getAgentType() + " on" + this.getType(), e);
            }
        }
    }

    @Override
    public void stopped() {
        this.toggleMixIns(false);
    }

    public void doCancelWarmup(Context cx) {
        if (!this.getPermissions(cx).hasAdminInvoke()) {
            LOGGER.warning("canceling warm up requires Superuser permissions");
            return;
        }
        if (this.warmupThread != null && this.warmupThread.isAlive()) {
            try {
                this.warmupThread.kill();
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine(this.getType() + " warm up canceled");
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, this.getType() + " warm up could not be canceled", e);
            }
        }
    }

    @Override
    public void doResetUserActivity(Context cx) throws Exception {
        for (BWarmup warmup : this.getChildren(BWarmup.class)) {
            warmup.doResetUserActivity(cx);
        }
        super.doResetUserActivity(cx);
    }

    @Override
    public void runWarmup() throws Exception {
        for (BWarmup warmup : this.getChildren(BWarmup.class)) {
            BWarmupConfig.checkInterrupted();
            if (!warmup.isEnabled()) continue;
            warmup.doWarmup(null);
        }
    }

    @Override
    public void warmupCompleted(BRelTime time, Context cx) {
        boolean useful = false;
        for (BWarmup warmup : this.getChildren(BWarmup.class)) {
            if (!warmup.isEnabled()) continue;
            useful = true;
        }
        if (this.getInterrupted()) {
            String details = "";
            if (this.firstUserActivity != null) {
                details = ", time to cancel " + this.firstUserActivity.delta(BAbsTime.now());
            }
            LOGGER.log(Level.INFO, this.getType() + " completed early in " + time + details);
        } else if (useful) {
            LOGGER.log(Level.INFO, this.getType() + " warmup completed in " + time);
        }
    }

    public static boolean isInterrupted() {
        return Thread.currentThread().isInterrupted();
    }

    public static void checkInterrupted() {
        if (BWarmupConfig.isInterrupted()) {
            throw new WarmupInterruptError();
        }
    }

    public static class WarmupInterruptError
    extends Error {
        public WarmupInterruptError() {
        }

        public WarmupInterruptError(Throwable cause) {
            super(cause);
        }
    }
}

