/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.collection;

import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.baja.util.CloseableIterator;

public class CompoundIterator<T>
implements CloseableIterator<T> {
    private Iterator<T>[] subs;
    private Iterator<T> iterator;
    private int index;

    public CompoundIterator(Iterator<T>[] subs) {
        this.subs = subs;
        if (subs.length != 0) {
            this.iterator = subs[0];
        }
    }

    @Override
    public boolean hasNext() {
        while (this.index < this.subs.length && !this.iterator.hasNext()) {
            ++this.index;
            if (this.index >= this.subs.length) continue;
            this.iterator = this.subs[this.index];
        }
        return this.index < this.subs.length;
    }

    @Override
    public T next() {
        if (this.hasNext()) {
            return this.iterator.next();
        }
        throw new NoSuchElementException();
    }

    @Override
    public void close() throws Exception {
        Exception e = null;
        for (Iterator<T> iterator : this.subs) {
            try {
                if (!(iterator instanceof AutoCloseable)) continue;
                ((AutoCloseable)((Object)iterator)).close();
            }
            catch (Exception ex) {
                if (e != null) continue;
                e = ex;
            }
        }
        if (e != null) {
            throw e;
        }
    }
}

