/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.file;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.baja.file.BFileSpace;
import javax.baja.file.BIFile;
import javax.baja.file.BIFileStore;
import javax.baja.file.BajaFileUtil;
import javax.baja.file.FilePath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BPermissions;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;

@NiagaraType
public abstract class BAbstractFileStore
extends BObject
implements BIFileStore {
    @Generated
    public static final Type TYPE = Sys.loadType(BAbstractFileStore.class);
    private static final int READONLY_MASK = -35;
    private BFileSpace space;
    private FilePath path;

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BAbstractFileStore(BFileSpace space, FilePath path) {
        this.space = space;
        this.path = path;
    }

    @Override
    public BFileSpace getFileSpace() {
        return this.space;
    }

    @Override
    public FilePath getFilePath() {
        return this.path;
    }

    @Override
    public String getFileName() {
        return this.getFilePath().getName();
    }

    @Override
    public String getExtension() {
        return BajaFileUtil.getExtension((String)this.getFileName());
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public long getSize() {
        return -1L;
    }

    @Override
    public BAbsTime getLastModified() {
        return BAbsTime.NULL;
    }

    @Override
    public final boolean setLastModified(BAbsTime absTime) throws IOException {
        absTime = BAbsTime.make(absTime.getYear(), absTime.getMonth(), absTime.getDay(), absTime.getHour(), absTime.getMinute(), absTime.getSecond(), 0, absTime.getTimeZone());
        return this.doSetLastModified(absTime);
    }

    protected boolean doSetLastModified(BAbsTime absTime) throws IOException {
        throw new IOException();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        throw new IOException();
    }

    @Override
    public byte[] read() throws IOException {
        return BajaFileUtil.read(this);
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        throw new IOException();
    }

    @Override
    public void write(byte[] content) throws IOException {
        BajaFileUtil.write(this, content);
    }

    @Override
    public BPermissions getPermissions(BIFile file, Context cx) {
        BPermissions permissions = BPermissions.all;
        if (cx != null && cx.getUser() != null) {
            BUser user = cx.getUser();
            permissions = BModule.isModuleFileSpace(this.space) ? BPermissions.operatorRead : (!user.getPermissions().isSuperUser() && this.path.getAbsoluteMode() != 4 ? BPermissions.none : cx.getUser().getPermissionsFor(file));
        }
        if (this.isReadonly()) {
            permissions = BPermissions.make(permissions.getMask() & 0xFFFFFFDD);
        }
        return permissions;
    }

    @Override
    public String toString(Context cx) {
        return String.valueOf(this.path);
    }

    @Override
    public long getCrc() throws IOException {
        return -1L;
    }
}

