/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.file;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.baja.category.BICategorizable;
import javax.baja.file.BFileSpace;
import javax.baja.file.BIFileStore;
import javax.baja.file.FilePath;
import javax.baja.nav.BINavNode;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BIProtected;
import javax.baja.space.BISpaceNode;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BIComparable;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public interface BIFile
extends BINavNode,
BISpaceNode,
BIComparable,
BICategorizable,
BIProtected {
    @Generated
    public static final Type TYPE = Sys.loadType(BIFile.class);

    public BIFileStore getStore();

    public void setStore(BIFileStore var1);

    public BFileSpace getFileSpace();

    public FilePath getFilePath();

    public String getFileName();

    public String getExtension();

    public boolean isDirectory();

    public String getMimeType();

    public long getSize();

    public BAbsTime getLastModified();

    public boolean isReadonly();

    public InputStream getInputStream() throws IOException;

    public byte[] read() throws IOException;

    public void delete() throws IOException;

    public OutputStream getOutputStream() throws IOException;

    public void write(byte[] var1) throws IOException;

    public boolean equals(Object var1);

    @Override
    default public int compareTo(Object other) {
        int result;
        BFileSpace otherSpace;
        BFileSpace thisSpace;
        BIFileStore otherStore;
        if (this == other) {
            return 0;
        }
        BIFile otherFile = (BIFile)other;
        BIFileStore thisStore = this.getStore();
        if (thisStore != (otherStore = otherFile.getStore()) && (thisSpace = thisStore.getFileSpace()) != (otherSpace = otherStore.getFileSpace()) && (result = ((Comparable)((Object)thisSpace)).compareTo(otherSpace)) != 0) {
            return result;
        }
        boolean otherIsDirectory = otherFile.isDirectory();
        if (this.isDirectory() != otherIsDirectory) {
            return otherIsDirectory ? 1 : -1;
        }
        return this.getFilePath().compareTo(otherFile.getFilePath());
    }
}

