/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.job;

import com.tridium.util.ThrowableUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.baja.job.BJob;
import javax.baja.job.BJobLogSequence;
import javax.baja.job.JobLogItem;
import javax.baja.sys.BAbsTime;
import javax.baja.util.BFormat;

public final class JobLog {
    final List<JobLogItem> items = new ArrayList<JobLogItem>();
    BJob job;
    int limit = -1;
    long sequenceNumber;
    long initialSequenceNumber;

    public JobLog() {
        this(-1L);
    }

    public JobLog(long sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
        this.initialSequenceNumber = sequenceNumber + 1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        List<JobLogItem> list = this.items;
        synchronized (list) {
            return this.items.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobLogItem getItem(int index) {
        List<JobLogItem> list = this.items;
        synchronized (list) {
            return this.items.get(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobLogItem[] getItems() {
        List<JobLogItem> list = this.items;
        synchronized (list) {
            return this.items.toArray(new JobLogItem[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLimit(int limit) {
        List<JobLogItem> list = this.items;
        synchronized (list) {
            this.limit = limit;
            if (limit > -1) {
                while (this.items.size() > limit) {
                    this.items.remove(0);
                }
            }
        }
    }

    public int getLimit() {
        return this.limit;
    }

    public void start(String nonLocalizedMessage) {
        this.add(new JobLogItem(1, nonLocalizedMessage));
    }

    public void start(String lexModule, String lexKey, String[] lexArgPatterns) {
        this.add(new JobLogItem(1, lexModule, lexKey, lexArgPatterns));
    }

    public void endSuccess(String nonLocalizedAppendText) {
        this.end(3, nonLocalizedAppendText, null);
    }

    public void endSuccess(String appendLexModule, String appendLexKey, String[] appendLexArgPatterns) {
        this.end(3, appendLexModule, appendLexKey, appendLexArgPatterns, null);
    }

    public void endSuccess() {
        this.end(3, null, null);
    }

    public void endFailed(String nonLocalizedAppendText, Throwable exception) {
        this.end(4, nonLocalizedAppendText, exception);
    }

    public void endFailed(String appendLexModule, String appendLexKey, String[] appendLexArgPatterns, Throwable exception) {
        this.end(4, appendLexModule, appendLexKey, appendLexArgPatterns, exception);
    }

    public void endFailed(Throwable exception) {
        this.end(4, null, exception);
    }

    public void endFailed(String nonLocalizedAppendText) {
        this.end(4, nonLocalizedAppendText, null);
    }

    public void endFailed(String appendLexModule, String appendLexKey, String[] appendLexArgPatterns) {
        this.end(4, appendLexModule, appendLexKey, appendLexArgPatterns, null);
    }

    public void end(int id, String nonLocalizedAppendText, Throwable exception) {
        JobLogItem item = this.getLastItem();
        if (item == null) {
            return;
        }
        item.id = id;
        item.timestamp = BAbsTime.make();
        if (nonLocalizedAppendText != null && !nonLocalizedAppendText.isEmpty()) {
            item.message = item.message + "; " + nonLocalizedAppendText;
        }
        if (exception != null) {
            item.details = ThrowableUtil.dumpToString(exception);
        }
    }

    public void end(int id, String appendLexModule, String appendLexKey, String[] appendLexArgPatterns, Throwable exception) {
        JobLogItem item = this.getLastItem();
        if (item == null) {
            return;
        }
        item.id = id;
        item.timestamp = BAbsTime.make();
        if (appendLexModule != null && !appendLexModule.isEmpty()) {
            String append = BFormat.getLexiconPattern(appendLexModule, appendLexKey, appendLexArgPatterns);
            item.message = item.message + "; " + append;
        }
        if (exception != null) {
            item.details = ThrowableUtil.dumpToString(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JobLogItem getLastItem() {
        List<JobLogItem> list = this.items;
        synchronized (list) {
            int size = this.items.size();
            if (size == 0) {
                return null;
            }
            return this.items.get(size - 1);
        }
    }

    public void message(String nonLocalizedMessage) {
        this.add(new JobLogItem(0, nonLocalizedMessage));
    }

    public void message(String lexModule, String lexKey, String[] lexArgPatterns) {
        this.add(new JobLogItem(0, lexModule, lexKey, lexArgPatterns));
    }

    public void message(String lexModule, String lexKey, String lexArgPattern) {
        this.add(new JobLogItem(0, lexModule, lexKey, new String[]{lexArgPattern}));
    }

    public void message(String lexModule, String lexKey) {
        this.add(new JobLogItem(0, lexModule, lexKey, null));
    }

    public void success(String nonLocalizedMessage) {
        this.add(new JobLogItem(3, nonLocalizedMessage));
    }

    public void success(String lexModule, String lexKey, String lexArgPattern) {
        this.add(new JobLogItem(3, lexModule, lexKey, new String[]{lexArgPattern}));
    }

    public void success(String lexModule, String lexKey) {
        this.add(new JobLogItem(3, lexModule, lexKey, null));
    }

    public void success(String lexModule, String lexKey, String[] lexArgPatterns) {
        this.add(new JobLogItem(3, lexModule, lexKey, lexArgPatterns));
    }

    public void failed(String nonLocalizedMessage) {
        this.add(new JobLogItem(4, nonLocalizedMessage));
    }

    public void failed(String lexModule, String lexKey, String[] lexArgPatterns) {
        this.add(new JobLogItem(4, lexModule, lexKey, lexArgPatterns));
    }

    public void failed(String lexModule, String lexKey, String lexArgPattern) {
        this.add(new JobLogItem(4, lexModule, lexKey, new String[]{lexArgPattern}));
    }

    public void failed(String lexModule, String lexKey) {
        this.add(new JobLogItem(4, lexModule, lexKey, null));
    }

    public void failed(String msg, Throwable exception) {
        this.add(new JobLogItem(4, msg, exception));
    }

    public void failed(String lexModule, String lexKey, String[] lexArgPatterns, Throwable exception) {
        this.add(new JobLogItem(4, lexModule, lexKey, lexArgPatterns, exception));
    }

    public void failed(String lexModule, String lexKey, String lexArgPattern, Throwable exception) {
        this.add(new JobLogItem(4, lexModule, lexKey, new String[]{lexArgPattern}, exception));
    }

    public void failed(String lexModule, String lexKey, Throwable exception) {
        this.add(new JobLogItem(4, lexModule, lexKey, null, exception));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(JobLogItem item) {
        List<JobLogItem> list = this.items;
        synchronized (list) {
            this.items.add(item);
            ++this.sequenceNumber;
            if (this.limit > -1) {
                while (this.items.size() > this.limit) {
                    this.items.remove(0);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String encode() {
        StringBuilder s = new StringBuilder();
        List<JobLogItem> list = this.items;
        synchronized (list) {
            for (JobLogItem item : this.items) {
                s.append(item.encode()).append('\n');
            }
        }
        return s.toString();
    }

    public static JobLog decode(String s) throws Exception {
        JobLog log = new JobLog();
        StringTokenizer st = new StringTokenizer(s, "\n");
        while (st.hasMoreTokens()) {
            log.add(JobLogItem.decode(st.nextToken()));
        }
        return log;
    }

    void setJob(BJob job) {
        this.job = job;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BJobLogSequence getSequenceFrom(long num) {
        List<JobLogItem> list = this.items;
        synchronized (list) {
            if (this.size() == 0 || num > this.sequenceNumber) {
                return new BJobLogSequence(new JobLogItem[0], this.initialSequenceNumber, -1L, -1L);
            }
            JobLogItem[] arr = this.getItemsFrom(num);
            return new BJobLogSequence(arr, this.initialSequenceNumber, this.sequenceNumber - (long)(arr.length - 1), this.sequenceNumber);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long firstSequenceNumber() {
        List<JobLogItem> list = this.items;
        synchronized (list) {
            int size = this.size();
            if (size == 0) {
                return -1L;
            }
            return this.sequenceNumber - (long)(size - 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JobLogItem[] getItemsFrom(long num) {
        List<JobLogItem> list = this.items;
        synchronized (list) {
            long firstSeq = this.firstSequenceNumber();
            if (firstSeq > -1L) {
                num = Math.max(num, firstSeq);
                int firstIndex = (int)(num - firstSeq);
                int lastIndex = this.items.size();
                if (firstIndex >= 0 && firstIndex <= lastIndex) {
                    return this.items.subList(firstIndex, lastIndex).toArray(new JobLogItem[0]);
                }
            }
        }
        return new JobLogItem[0];
    }
}

