/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.naming;

import com.tridium.sys.module.BModuleTypesContainer;
import com.tridium.util.ModuleDev;
import java.util.Optional;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.naming.BOrdScheme;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SyntaxException;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BModule;
import javax.baja.sys.BModuleSpace;
import javax.baja.sys.BObject;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(ordScheme="module")
@NiagaraSingleton
public class BModuleScheme
extends BOrdScheme {
    @Generated
    public static final BModuleScheme INSTANCE = new BModuleScheme();
    @Generated
    public static final Type TYPE = Sys.loadType(BModuleScheme.class);
    private static final ModuleDev moduleDev = new ModuleDev();

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    private BModuleScheme() {
        super("module");
    }

    @Override
    public OrdQuery parse(String queryBody) {
        return new FilePath("module", queryBody);
    }

    @Override
    public OrdTarget resolve(OrdTarget base, OrdQuery query) throws SyntaxException, UnresolvedException {
        Optional<OrdTarget> target;
        String[] names;
        FilePath path = (FilePath)query;
        if (path.getBody().equals("")) {
            return new OrdTarget(base, BModuleSpace.INSTANCE);
        }
        if (!path.isAuthorityAbsolute()) {
            throw new UnresolvedException("Modules must be authority absolute");
        }
        BModule module = Sys.loadModule(path.getAuthority());
        if (path.depth() == 0) {
            return new OrdTarget(base, module);
        }
        if (path.depth() == 1) {
            if (path.getName().equals("types")) {
                return new OrdTarget(base, BModuleTypesContainer.get(module));
            }
            if (path.getName().equals("module.palette")) {
                if (module.hasPalette()) {
                    return new OrdTarget(base, (BObject)((Object)module.getNavChild("module.palette")));
                }
                throw new UnresolvedException(String.format("Module %s has no palette", module.getModuleName()));
            }
        } else if (path.depth() == 2 && (names = path.getNames())[0].equals("types")) {
            return new OrdTarget(base, (BObject)((Object)BModuleTypesContainer.get(module).getNavChild(names[1])));
        }
        if ((target = moduleDev.makeModuleDevOrdTarget(path)).isPresent()) {
            return target.get();
        }
        BIFile file = module.resolveFile(path);
        return new OrdTarget(base, (BObject)((Object)file));
    }

    public static boolean isModuleDevEnabled() {
        return moduleDev.isEnabled();
    }
}

