/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.naming;

import javax.baja.file.FilePath;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.ViewQuery;
import javax.baja.security.BIProtected;
import javax.baja.security.BPermissions;
import javax.baja.space.BSpace;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIPropertyContainer;
import javax.baja.sys.BObject;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.user.BUser;

public class OrdTarget
implements Context {
    BUser user;
    String lang;
    BFacets facets;
    OrdTarget base;
    BOrd ord;
    OrdQuery[] queries;
    BObject object;
    BPermissions permissions;
    BIPropertyContainer container;
    boolean isTargetReadonly;
    Slot slot;
    Property[] propertyPath;
    boolean mergedSlotFacets;

    public OrdTarget(OrdTarget base, BObject object) {
        this.base = base;
        this.user = base.user;
        this.lang = base.lang;
        this.facets = base.facets;
        this.ord = base.ord;
        this.queries = base.queries;
        if (object != null) {
            this.object = object;
        } else {
            this.object = base.object;
            this.permissions = base.permissions;
            this.container = base.container;
            this.isTargetReadonly = base.isTargetReadonly;
            this.slot = base.slot;
            this.propertyPath = base.propertyPath;
        }
    }

    public static OrdTarget makeWithFacets(OrdTarget base, BObject object, BFacets facets) {
        return OrdTarget.makeWithFacetsAndLanguage(base, object, facets, null);
    }

    public static OrdTarget makeWithFacetsAndLanguage(OrdTarget base, BObject object, BFacets facets, String language) {
        OrdTarget t = new OrdTarget(base, object);
        if (facets != null) {
            t.facets = BFacets.make(t.facets, facets);
        }
        if (language != null) {
            t.lang = language;
        }
        return t;
    }

    public static OrdTarget makeWithViewQuery(OrdTarget base, ViewQuery viewQuery) {
        if (viewQuery == null) {
            throw new IllegalArgumentException("ViewQuery must be specified");
        }
        OrdTarget t = new OrdTarget(base);
        t.ord = t.ord.isNull() ? BOrd.make(viewQuery) : BOrd.make(t.ord, BOrd.make(viewQuery)).normalize();
        t.queries = t.ord.parse();
        return t;
    }

    public OrdTarget(OrdTarget base) {
        this(base, null);
    }

    public static OrdTarget makeWithFacets(OrdTarget base, BFacets facets) {
        return OrdTarget.makeWithFacetsAndLanguage(base, null, facets, null);
    }

    OrdTarget(Context cx, BOrd ord, OrdQuery[] queries, BObject object) {
        BasicContext temp = new BasicContext(cx);
        this.user = temp.getUser();
        this.lang = temp.getLanguage();
        this.facets = temp.getFacets();
        this.ord = ord;
        this.queries = queries;
        this.object = object;
    }

    public OrdTarget(OrdTarget base, BComponent component, BObject object, Slot slot, Property[] propertyPath) {
        this(base, (BIPropertyContainer)component, object, slot, propertyPath);
    }

    OrdTarget(OrdTarget base, BIPropertyContainer container, BObject object, Slot slot, Property[] propertyPath) {
        this(base, object);
        this.container = container;
        this.object = object;
        this.slot = slot;
        this.propertyPath = propertyPath;
    }

    public static OrdTarget unmounted(BObject target) {
        return OrdTarget.unmounted(target, null);
    }

    public static OrdTarget unmounted(BObject target, Context cx) {
        return new OrdTarget(cx, BOrd.NULL, new OrdQuery[0], target);
    }

    @Override
    public BUser getUser() {
        return this.user;
    }

    @Override
    public String getLanguage() {
        return this.lang;
    }

    @Override
    public BFacets getFacets() {
        if (!(this.propertyPath == null && this.slot == null || this.mergedSlotFacets || this.container == null)) {
            BFacets slotFacets = BFacets.NULL;
            if (this.propertyPath != null) {
                BObject c = (BObject)((Object)this.container);
                boolean isPropContainer = true;
                for (int i = 0; i < this.propertyPath.length; ++i) {
                    Property prop = this.propertyPath[i];
                    slotFacets = BFacets.make(isPropContainer ? ((BIPropertyContainer)((Object)c)).getSlotFacets(prop) : c.asComplex().getSlotFacets(prop), slotFacets);
                    c = isPropContainer ? ((BIPropertyContainer)((Object)c)).get(prop) : c.asComplex().get(prop);
                    isPropContainer = c instanceof BIPropertyContainer;
                }
            } else {
                slotFacets = BFacets.make(this.container.getSlotFacets(this.slot), slotFacets);
            }
            this.facets = BFacets.make(slotFacets, this.facets);
            this.mergedSlotFacets = true;
        }
        return this.facets;
    }

    @Override
    public BObject getFacet(String name) {
        return this.getFacets().get(name);
    }

    @Override
    public Context getBase() {
        return this.base;
    }

    public OrdTarget getBaseOrdTarget() {
        return this.base;
    }

    public BOrd getOrd() {
        return this.ord;
    }

    public BSpace getSpace() {
        for (OrdTarget target = this; target != null; target = target.getBaseOrdTarget()) {
            BComponent component;
            BSpace space = BOrd.toSpace(this.object);
            if (space == null && (component = this.getComponent()) != null) {
                space = component.getSpace();
            }
            if (space == null) continue;
            return space;
        }
        return null;
    }

    public BObject get() {
        return this.object;
    }

    public BComponent getComponent() {
        BComponent c;
        if (this.container instanceof BComponent) {
            return (BComponent)this.container;
        }
        if (this.object.isComponent()) {
            return this.object.asComponent();
        }
        if (this.object.isComplex() && (c = this.object.asComplex().getParentComponent()) != null) {
            return c;
        }
        if (this.base != null) {
            return this.base.getComponent();
        }
        return null;
    }

    public BComplex getParent() {
        if (this.container instanceof BComplex && this.propertyPath != null) {
            BComplex p = (BComplex)((Object)this.container);
            for (int i = 0; i < this.propertyPath.length - 1; ++i) {
                p = (BComplex)p.get(this.propertyPath[i]);
            }
            return p;
        }
        if (this.base != null) {
            return this.base.getParent();
        }
        return null;
    }

    public Slot getSlotInComponent() {
        if (this.slot != null) {
            return this.slot;
        }
        if (!(this.base == null || this.container != null || this.object.isComponent() || this.object.isComplex() && this.object.asComplex().getParentComponent() != null)) {
            return this.base.getSlotInComponent();
        }
        return null;
    }

    public Property[] getPropertyPathInComponent() {
        if (this.propertyPath != null) {
            return this.propertyPath;
        }
        if (this.base != null) {
            return this.base.getPropertyPathInComponent();
        }
        return null;
    }

    public Property getPropertyInParent() {
        if (this.propertyPath != null) {
            return this.propertyPath[this.propertyPath.length - 1];
        }
        if (this.base != null) {
            return this.base.getPropertyInParent();
        }
        return null;
    }

    public BIProtected getSecurityTarget() {
        if (this.object instanceof BIProtected) {
            return (BIProtected)((Object)this.object);
        }
        if (this.container instanceof BIProtected) {
            return (BIProtected)((Object)this.container);
        }
        if (this.base != null) {
            return this.base.getSecurityTarget();
        }
        return null;
    }

    public BPermissions getPermissionsForTarget() {
        if (this.permissions == null) {
            BIProtected target = this.getSecurityTarget();
            this.permissions = target != null ? target.getPermissions(this) : BPermissions.all;
        }
        return this.permissions;
    }

    public boolean canRead() {
        BIProtected st = this.getSecurityTarget();
        if (st != null) {
            return st.canRead(this);
        }
        return true;
    }

    public boolean canWrite() {
        BIProtected st = this.getSecurityTarget();
        if (st != null) {
            return st.canWrite(this);
        }
        return true;
    }

    public boolean canInvoke() {
        BIProtected st = this.getSecurityTarget();
        if (st != null) {
            return st.canInvoke(this);
        }
        return true;
    }

    public int depth() {
        return this.queries == null ? 0 : this.queries.length;
    }

    public OrdQuery queryAt(int index) {
        return this.queries[index];
    }

    public OrdQuery[] getOrdQueries() {
        return (OrdQuery[])this.queries.clone();
    }

    public FilePath getFilePath() {
        for (int i = this.queries.length - 1; i >= 0; --i) {
            if (!(this.queries[i] instanceof FilePath)) continue;
            return (FilePath)this.queries[i];
        }
        return null;
    }

    public String getFilePathFragment() {
        FilePath path = this.getFilePath();
        if (path != null) {
            return path.getFragment();
        }
        return null;
    }

    public ViewQuery getViewQuery() {
        int n = this.queries.length - 1;
        if (n >= 0 && this.queries[n] instanceof ViewQuery) {
            return (ViewQuery)this.queries[n];
        }
        return null;
    }

    public String getViewParameter(String name, String def) {
        ViewQuery q = this.getViewQuery();
        if (q == null) {
            return def;
        }
        return q.getParameter(name, def);
    }

    public BOrd getOrdWithoutViewQuery() {
        if (this.getViewQuery() == null) {
            return this.ord;
        }
        return BOrd.make(this.queries, 0, this.queries.length - 1);
    }

    public String toString() {
        return this.ord + " -> " + this.object;
    }

    public void dump() {
        System.out.println(this.getClass().getName());
        System.out.println("  ord:         " + this.ord);
        System.out.println("  facets:      " + this.facets);
        System.out.println("  object:      " + this.object);
        System.out.println("  permissions: " + this.permissions);
        System.out.println("  container:   " + this.container);
        System.out.println("  readonly:    " + this.isTargetReadonly);
        System.out.println("  slot:        " + this.slot);
        System.out.println("  propPath:    " + (this.propertyPath == null ? "null" : "" + this.propertyPath.length));
        System.out.println("  component(): " + this.getComponent());
        System.out.println("  slot():      " + this.getSlotInComponent());
        System.out.println("  propPath():  " + (this.getPropertyPathInComponent() == null ? "null" : "" + this.getPropertyPathInComponent().length));
        if (this.base != null) {
            this.base.dump();
        }
    }
}

