/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.nav;

import javax.baja.category.BCategoryMask;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.Path;
import javax.baja.nav.BINavNode;
import javax.baja.sys.BFacets;
import javax.baja.sys.Context;

public class NavEvent {
    public static final int ADDED = 1;
    public static final int REMOVED = 2;
    public static final int RENAMED = 3;
    public static final int REORDERED = 4;
    public static final int REPLACED = 5;
    public static final int RECATEGORIZED = 6;
    private static String[] ID_STRINGS = new String[]{"-", "added", "removed", "renamed", "reordered", "replaced", "recategorized"};
    private int id;
    private BINavNode parent;
    private BOrd parentOrd;
    private String oldChildName;
    private String newChildName;
    private BOrd oldChildOrd;
    private BOrd newChildOrd;
    private String[] newOrder;
    private Context context;

    public static NavEvent makeAdded(BOrd parentOrd, String newChildName, Context cx) {
        NavEvent event = new NavEvent(1);
        event.parentOrd = parentOrd;
        event.newChildName = newChildName;
        event.context = cx;
        return event;
    }

    public static NavEvent makeAdded(BINavNode parent, String newChildName, Context cx) {
        NavEvent event = NavEvent.makeAdded(parent.getNavOrd(), newChildName, cx);
        event.parent = parent;
        return event;
    }

    public static NavEvent makeRemoved(BOrd parentOrd, String oldChildName, Context cx) {
        NavEvent event = new NavEvent(2);
        event.parentOrd = parentOrd;
        event.oldChildName = oldChildName;
        event.context = cx;
        return event;
    }

    public static NavEvent makeRemoved(BINavNode parent, String oldChildName, Context cx) {
        NavEvent event = NavEvent.makeRemoved(parent.getNavOrd(), oldChildName, cx);
        event.parent = parent;
        return event;
    }

    public static NavEvent makeRenamed(BOrd parentOrd, String oldChildName, String newChildName, Context cx) {
        NavEvent event = new NavEvent(3);
        event.parentOrd = parentOrd;
        event.oldChildName = oldChildName;
        event.newChildName = newChildName;
        event.context = cx;
        return event;
    }

    public static NavEvent makeRenamed(BINavNode parent, String oldChildName, String newChildName, Context cx) {
        NavEvent event = NavEvent.makeRenamed(parent.getNavOrd(), oldChildName, newChildName, cx);
        event.parent = parent;
        return event;
    }

    public static NavEvent makeReordered(BOrd parentOrd, String[] newOrder, Context cx) {
        NavEvent event = new NavEvent(4);
        event.parentOrd = parentOrd;
        event.newOrder = newOrder;
        event.context = cx;
        return event;
    }

    public static NavEvent makeReordered(BINavNode parent, String[] newOrder, Context cx) {
        NavEvent event = NavEvent.makeReordered(parent.getNavOrd(), newOrder, cx);
        event.parent = parent;
        return event;
    }

    public static NavEvent makeReplaced(BOrd parentOrd, String oldChildName, Context cx) {
        NavEvent event = new NavEvent(5);
        event.parentOrd = parentOrd;
        event.oldChildName = oldChildName;
        event.context = cx;
        return event;
    }

    public static NavEvent makeReplaced(BINavNode parent, String oldChildName, Context cx) {
        NavEvent event = NavEvent.makeReplaced(parent.getNavOrd(), oldChildName, cx);
        event.parent = parent;
        return event;
    }

    public static NavEvent makeRecategorized(BOrd parentOrd, String oldMask, String newMask, Context cx) {
        NavEvent event = new NavEvent(6);
        event.parentOrd = parentOrd;
        event.oldChildName = oldMask;
        event.newChildName = newMask;
        event.context = cx;
        return event;
    }

    public static NavEvent makeRecategorized(BOrd parentOrd, BCategoryMask oldMask, BCategoryMask newMask, Context cx) {
        return NavEvent.makeRecategorized(parentOrd, oldMask.encodeToString(), newMask.encodeToString(), cx);
    }

    public static NavEvent makeRecategorized(BINavNode parent, BCategoryMask oldMask, BCategoryMask newMask, Context cx) {
        NavEvent event = NavEvent.makeRecategorized(parent.getNavOrd(), oldMask, newMask, cx);
        event.parent = parent;
        return event;
    }

    public static NavEvent make(NavEvent orig, BOrd parentOrd) {
        NavEvent event = new NavEvent(orig.id);
        event.parentOrd = parentOrd;
        event.oldChildName = orig.oldChildName;
        event.newChildName = orig.newChildName;
        event.newOrder = orig.newOrder;
        event.context = orig.context;
        return event;
    }

    public static NavEvent make(NavEvent orig, BOrd parentOrd, Context cx) {
        NavEvent event = new NavEvent(orig.id);
        event.parentOrd = parentOrd;
        event.oldChildName = orig.oldChildName;
        event.newChildName = orig.newChildName;
        event.newOrder = orig.newOrder;
        event.context = cx;
        return event;
    }

    public static NavEvent make(NavEvent orig, BINavNode parent) {
        NavEvent event = new NavEvent(orig.id);
        event.parent = parent;
        event.parentOrd = parent.getNavOrd();
        event.oldChildName = orig.oldChildName;
        event.newChildName = orig.newChildName;
        event.newOrder = orig.newOrder;
        event.context = orig.context;
        return event;
    }

    public static NavEvent make(NavEvent orig, BINavNode parent, Context cx) {
        NavEvent event = new NavEvent(orig.id);
        event.parent = parent;
        event.parentOrd = parent.getNavOrd();
        event.oldChildName = orig.oldChildName;
        event.newChildName = orig.newChildName;
        event.newOrder = orig.newOrder;
        event.context = cx;
        return event;
    }

    private NavEvent(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public BOrd getParentOrd() {
        return this.parentOrd;
    }

    public BINavNode getParent() {
        return this.parent;
    }

    public String getOldChildName() {
        return this.oldChildName;
    }

    public String getNewChildName() {
        return this.newChildName;
    }

    public BOrd getOldChildOrd() {
        if (this.oldChildOrd == null) {
            this.oldChildOrd = this.toChildOrd(this.oldChildName);
        }
        return this.oldChildOrd;
    }

    public BOrd getNewChildOrd() {
        if (this.newChildOrd == null) {
            this.newChildOrd = this.toChildOrd(this.newChildName);
        }
        return this.newChildOrd;
    }

    public String[] getNewOrder() {
        return this.newOrder;
    }

    public Context getContext() {
        return this.context;
    }

    public BFacets getFacets() {
        if (this.context != null) {
            return BFacets.make(this.context.getFacets());
        }
        return BFacets.NULL;
    }

    public String toString() {
        StringBuilder s = new StringBuilder("NavEvent[");
        s.append(ID_STRINGS[this.id]).append(" p=").append(this.parentOrd);
        if (this.oldChildName != null) {
            s.append("  old=").append(this.oldChildName);
        }
        if (this.newChildName != null) {
            s.append("  new=").append(this.newChildName);
        }
        if (this.newOrder != null) {
            s.append("  order.len=").append(this.newOrder.length);
        }
        s.append("]");
        return s.toString();
    }

    private BOrd toChildOrd(String childName) {
        if (childName == null) {
            return null;
        }
        String parentOrdStr = this.parentOrd.toString();
        OrdQuery[] q = this.parentOrd.parse();
        OrdQuery last = q[q.length - 1];
        if (last instanceof Path) {
            Path path = (Path)((Object)last);
            if (path.depth() == 0) {
                return BOrd.make(parentOrdStr + childName);
            }
            return BOrd.make(parentOrdStr + "/" + childName);
        }
        return BOrd.make(parentOrdStr + "|" + childName + ":");
    }
}

