/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.security;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Objects;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.SecurityUtil;
import javax.baja.security.BICredentials;
import javax.baja.security.BIDeferOwnership;
import javax.baja.security.BPassword;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="alias", type="String", defaultValue="CertUtils.FACTORY_CERT_ALIAS", flags=64, facets={@Facet(name="BFacets.FIELD_EDITOR", value="BString.make(\"workbench:CertificateAliasFE\")"), @Facet(name="BFacets.UX_FIELD_EDITOR", value="BString.make(\"webEditors:CertificateAliasEditor\")"), @Facet(value="BFacets.make(BFacets.SECURITY, BBoolean.TRUE)")}), @NiagaraProperty(name="password", type="BPassword", defaultValue="BPassword.DEFAULT", flags=64, facets={@Facet(name="BFacets.FIELD_EDITOR", value="BString.make(\"workbench:DefaultPasswordFE\")"), @Facet(name="BFacets.UX_FIELD_EDITOR", value="BString.make(\"webEditors:DefaultPasswordEditor\")"), @Facet(name="BPassword.PLACEHOLDER_TEXT", value="\"%lexicon(workbench:default.password.placeholder.label)%\""), @Facet(value="BFacets.make(BFacets.SECURITY, BBoolean.TRUE)")})})
public class BCertificateAliasAndPassword
extends BStruct
implements BICredentials,
BIDeferOwnership {
    @Generated
    public static final Property alias = BCertificateAliasAndPassword.newProperty(64, "default", BFacets.make(BFacets.make(BFacets.make("fieldEditor", BString.make("workbench:CertificateAliasFE")), BFacets.make("uxFieldEditor", BString.make("webEditors:CertificateAliasEditor"))), BFacets.make("security", BBoolean.TRUE)));
    @Generated
    public static final Property password = BCertificateAliasAndPassword.newProperty(64, BPassword.DEFAULT, BFacets.make(BFacets.make(BFacets.make(BFacets.make("fieldEditor", BString.make("workbench:DefaultPasswordFE")), BFacets.make("uxFieldEditor", BString.make("webEditors:DefaultPasswordEditor"))), BFacets.make("placeholderText", "%lexicon(workbench:default.password.placeholder.label)%")), BFacets.make("security", BBoolean.TRUE)));
    @Generated
    public static final Type TYPE = Sys.loadType(BCertificateAliasAndPassword.class);
    public static final BCertificateAliasAndPassword DEFAULT = new BCertificateAliasAndPassword();

    @Generated
    public String getAlias() {
        return this.getString(alias);
    }

    @Generated
    public void setAlias(String v) {
        this.setString(alias, v, null);
    }

    @Generated
    public BPassword getPassword() {
        return (BPassword)this.get(password);
    }

    @Generated
    public void setPassword(BPassword v) {
        this.set(password, (BValue)v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BCertificateAliasAndPassword() {
    }

    public BCertificateAliasAndPassword(String alias, BPassword password) {
        Objects.requireNonNull(alias);
        Objects.requireNonNull(password);
        this.setAlias(alias);
        this.setPassword(password);
    }

    public void resetAliasAndPassword() {
        this.setAlias("default");
        this.setPassword(BPassword.DEFAULT);
    }

    @Override
    public byte[] encodeCredentials(Context context) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(bout);
        BString.make(this.getAlias()).encode(out);
        this.getPassword().encode(out, context);
        out.flush();
        return bout.toByteArray();
    }

    @Override
    public BICredentials decodeCredentials(byte[] encoding, Context context) throws IOException {
        ByteArrayInputStream bin = new ByteArrayInputStream(encoding);
        DataInputStream in = new DataInputStream(bin);
        BCertificateAliasAndPassword x = (BCertificateAliasAndPassword)this.newCopy();
        x.set(alias, (BValue)BString.DEFAULT.decode(in));
        x.set(password, (BValue)BPassword.DEFAULT.decode(in, context));
        return x;
    }

    @Override
    public boolean equivalent(Object obj) {
        if (obj != null && obj.getClass() == this.getClass() && SecurityUtil.equals((String)((BCertificateAliasAndPassword)obj).getAlias(), (String)this.getAlias())) {
            BPassword p = ((BCertificateAliasAndPassword)obj).getPassword();
            return p.equals(this.getPassword()) || p.getPasswordEncoder().isReversible() && this.getPassword().getPasswordEncoder().isReversible() && p.validate(this.getPassword());
        }
        return false;
    }

    @Override
    public String toString(Context context) {
        return this.getAlias();
    }

    public boolean isPasswordSet() {
        return !this.getPassword().isDefault();
    }
}

