/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.security.dashboard;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.baja.security.dashboard.BSecurityItemStatus;
import javax.baja.security.dashboard.LexiconFormatInfo;
import javax.baja.security.dashboard.SecurityDashboardItem;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BDouble;
import javax.baja.sys.BIObject;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLong;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.Type;

public class SecurityDashboardItemBuilder {
    private final Type type;

    public SecurityDashboardItemBuilder(Type type) {
        this.type = type;
    }

    public SecurityDashboardItemBuilder(BIObject object) {
        this(object.getType());
    }

    public SecurityDashboardItem make(BSecurityItemStatus status, String summary, String description) {
        return new ItemBuild(status).withSummary(summary, new Object[0]).withDescription(description, new Object[0]);
    }

    public SecurityDashboardItem makeInfo(String summary, String description) {
        return this.make(BSecurityItemStatus.securityStatusInfo, summary, description);
    }

    public SecurityDashboardItem makeOk(String summary, String description) {
        return this.make(BSecurityItemStatus.securityStatusOK, summary, description);
    }

    public SecurityDashboardItem makeWarning(String summary, String description) {
        return this.make(BSecurityItemStatus.securityStatusWarning, summary, description);
    }

    public SecurityDashboardItem makeAlert(String summary, String description) {
        return this.make(BSecurityItemStatus.securityStatusAlert, summary, description);
    }

    public ItemBuild make(BSecurityItemStatus status) {
        return new ItemBuild(status);
    }

    public ItemBuild makeInfo() {
        return new ItemBuild(BSecurityItemStatus.securityStatusInfo);
    }

    public ItemBuild makeOk() {
        return new ItemBuild(BSecurityItemStatus.securityStatusOK);
    }

    public ItemBuild makeWarning() {
        return new ItemBuild(BSecurityItemStatus.securityStatusWarning);
    }

    public ItemBuild makeAlert() {
        return new ItemBuild(BSecurityItemStatus.securityStatusAlert);
    }

    private static List<BSimple> argsToSimples(Object ... args) {
        ArrayList<BSimple> simples = new ArrayList<BSimple>();
        for (Object o : args) {
            if (o instanceof BSimple) {
                simples.add((BSimple)o);
                continue;
            }
            if (o instanceof String) {
                simples.add(BString.make((String)o));
                continue;
            }
            if (o instanceof Double) {
                simples.add(BDouble.make((Double)o));
                continue;
            }
            if (o instanceof Integer) {
                simples.add(BInteger.make((Integer)o));
                continue;
            }
            if (o instanceof Long) {
                simples.add(BLong.make((Long)o));
                continue;
            }
            if (o instanceof Boolean) {
                simples.add(BBoolean.make((Boolean)o));
                continue;
            }
            if (o instanceof Date) {
                simples.add(BAbsTime.make(((Date)o).getTime()));
                continue;
            }
            simples.add(BString.make(String.valueOf(o)));
        }
        return simples;
    }

    public class ItemBuild {
        private final BSecurityItemStatus status;
        private String lexModule;
        private LexiconFormatInfo summary;
        private LexiconFormatInfo description;

        private ItemBuild(BSecurityItemStatus status) {
            this.status = status;
            this.fromLexiconModule(SecurityDashboardItemBuilder.this.type.getModule().getModuleName());
        }

        public ItemBuild fromLexiconModule(String lexModule) {
            this.lexModule = lexModule;
            return this;
        }

        public ItemBuild withSummary(String summaryKey, Object ... args) {
            this.summary = args.length == 0 ? LexiconFormatInfo.make(this.lexModule, summaryKey) : LexiconFormatInfo.make(this.lexModule, summaryKey, (List<? extends BSimple>)SecurityDashboardItemBuilder.argsToSimples(args));
            return this;
        }

        public ItemBuild withSummary(LexiconFormatInfo summary) {
            this.summary = summary;
            return this;
        }

        public SecurityDashboardItem withDescription(String descriptionKey, Object ... args) {
            this.description = args.length == 0 ? LexiconFormatInfo.make(this.lexModule, descriptionKey) : LexiconFormatInfo.make(this.lexModule, descriptionKey, (List<? extends BSimple>)SecurityDashboardItemBuilder.argsToSimples(args));
            return new SecurityDashboardItem(this.summary, this.description, this.status);
        }

        public SecurityDashboardItem withDescription(LexiconFormatInfo description) {
            return new SecurityDashboardItem(this.summary, description, this.status);
        }
    }
}

