/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.security.kerberos;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.AuthenticationException;
import javax.baja.security.BICredentials;
import javax.baja.security.BIUserCredentials;
import javax.baja.sys.BStruct;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;

@NiagaraType
public class BKerberosCredentials
extends BStruct
implements BIUserCredentials {
    @Generated
    public static final Type TYPE = Sys.loadType(BKerberosCredentials.class);
    GSSCredential credentials;
    private String username = null;

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BKerberosCredentials() {
        this.credentials = null;
    }

    public BKerberosCredentials(GSSCredential credentials) {
        this.credentials = credentials;
    }

    public GSSCredential getCredential() {
        return this.credentials;
    }

    @Override
    public String getUsername() {
        if (this.credentials == null) {
            return null;
        }
        if (this.username == null) {
            try {
                String name = this.credentials.getName().toString();
                int index = name.indexOf("@");
                if (index > -1) {
                    name = name.substring(0, index);
                }
                this.username = name;
            }
            catch (GSSException e) {
                throw new AuthenticationException("Could not extract username from credentials");
            }
        }
        return this.username;
    }

    public String getRealm() {
        if (this.credentials == null) {
            return null;
        }
        try {
            String realm = this.credentials.getName().toString();
            int index = realm.indexOf("@");
            if (index > -1) {
                return realm.substring(index + 1);
            }
            return null;
        }
        catch (GSSException e) {
            throw new AuthenticationException("Could not extract realm name from credentials");
        }
    }

    public boolean isExpired() {
        if (this.credentials == null) {
            return false;
        }
        try {
            return this.credentials.getRemainingLifetime() == 0;
        }
        catch (GSSException e) {
            throw new AuthenticationException("Could not extract remaining lifetime from credentials");
        }
    }

    public void destroyTicket() {
        try {
            this.credentials.dispose();
        }
        catch (GSSException gSSException) {
            // empty catch block
        }
    }

    @Override
    public BICredentials decodeCredentials(byte[] encoding, Context context) throws IOException {
        BKerberosCredentials x = (BKerberosCredentials)this.newCopy();
        try {
            ByteArrayInputStream bin = new ByteArrayInputStream(encoding);
            ObjectInputStream in = new ObjectInputStream(bin);
            x.credentials = (GSSCredential)in.readObject();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return x;
    }

    @Override
    public byte[] encodeCredentials(Context context) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bout);
        out.writeObject(this.credentials);
        out.flush();
        byte[] credBytes = bout.toByteArray();
        bout.close();
        return credBytes;
    }

    @Override
    public boolean equivalent(Object obj) {
        return obj != null && obj.getClass() == this.getClass() && ((BKerberosCredentials)obj).getCredential().equals(this.getCredential());
    }
}

