/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.space;

import com.tridium.sys.transfer.TransferResult;
import com.tridium.sys.transfer.TransferStrategy;
import java.io.PrintWriter;
import java.lang.reflect.Array;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nav.BINavNode;
import javax.baja.space.BISpaceNode;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;

public class Mark {
    private static Mark current;
    private BObject[] values;
    private String[] names;
    private boolean pendingMove;

    public static Mark getCurrent() {
        return current;
    }

    public static void setCurrent(Mark mark) {
        if (current != null) {
            current.setPendingMove(false);
        }
        current = mark;
    }

    public Mark(BObject[] values, String[] names) {
        if (values.length != names.length) {
            throw new IllegalArgumentException("values.length != names.length");
        }
        for (int i = 0; i < values.length; ++i) {
            if (values[i] != null && names[i] != null) continue;
            throw new NullPointerException();
        }
        this.values = (BObject[])values.clone();
        this.names = (String[])names.clone();
    }

    public Mark(BObject value, String name) {
        this(new BObject[]{value}, new String[]{name});
    }

    public Mark(BObject value) {
        this(new BObject[]{value}, new String[]{Mark.makeName(value)});
    }

    public Mark(BObject[] values) {
        this(values, Mark.makeNames(values));
    }

    public BObject getValue(int index) {
        return this.values[index];
    }

    public BObject[] getValues() {
        return (BObject[])this.values.clone();
    }

    public Object[] getValues(Object[] array) {
        if (array.length < this.values.length) {
            array = (Object[])Array.newInstance(array.getClass().getComponentType(), this.values.length);
        }
        System.arraycopy(this.values, 0, array, 0, this.values.length);
        return array;
    }

    public String getName(int index) {
        return this.names[index];
    }

    public String[] getNames() {
        return (String[])this.names.clone();
    }

    public int size() {
        return this.values.length;
    }

    public boolean areAllValuesComponents() {
        for (int i = 0; i < this.values.length; ++i) {
            if (this.values[i] instanceof BComponent) continue;
            return false;
        }
        return true;
    }

    public String toStringFormat() {
        try {
            BOrd ord;
            SlotPath path;
            BObject value = this.values[0];
            if (value instanceof BComponent && (path = ((BComponent)value).getSlotPath()) != null) {
                return "station:|" + path;
            }
            if (value instanceof BISpaceNode && (ord = ((BISpaceNode)((Object)value)).getOrdInSession()) != null) {
                return ord.toString();
            }
            return value.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return e.toString();
        }
    }

    public boolean isPendingMove() {
        return this.pendingMove;
    }

    public void setPendingMove(boolean pendingMove) {
        if (this.pendingMove == pendingMove) {
            return;
        }
        this.pendingMove = pendingMove;
        for (int i = 0; i < this.values.length; ++i) {
            ((BISpaceNode)((Object)this.values[i])).setPendingMove(pendingMove);
        }
    }

    public TransferResult copyTo(BObject target, Context context) throws Exception {
        return TransferStrategy.make(16, this, target, null, context).transfer();
    }

    public TransferResult copyTo(BObject target, BComponent params, Context context) throws Exception {
        return TransferStrategy.make(16, this, target, params, context).transfer();
    }

    public TransferResult moveTo(BObject target, Context context) throws Exception {
        return TransferStrategy.make(32, this, target, null, context).transfer();
    }

    public void dump(PrintWriter out) {
        out.println("Mark [" + this.values.length + "] " + Integer.toString(this.hashCode(), 36));
        for (int i = 0; i < this.values.length; ++i) {
            out.println("  " + this.names[i] + " = " + this.values[i].toDebugString());
        }
    }

    public void dump() {
        PrintWriter out = new PrintWriter(System.out);
        this.dump(out);
        out.flush();
    }

    public static String makeName(BObject object) {
        String name = null;
        if (object instanceof BINavNode) {
            name = ((BINavNode)((Object)object)).getNavName();
        }
        if (name == null) {
            name = object.getType().getTypeName();
        }
        return name;
    }

    public static String[] makeNames(BObject[] values) {
        String[] names = new String[values.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = Mark.makeName(values[i]);
        }
        return names;
    }
}

