/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.sync;

import com.tridium.nre.util.IElement;
import com.tridium.sys.engine.NKnob;
import com.tridium.sys.schema.ComponentSlotMap;
import javax.baja.space.BComponentSpace;
import javax.baja.sync.SyncBuffer;
import javax.baja.sync.SyncDecoder;
import javax.baja.sync.SyncEncoder;
import javax.baja.sync.SyncOp;
import javax.baja.sys.BComponent;
import javax.baja.sys.Context;
import javax.baja.sys.Knob;
import javax.baja.sys.Slot;

public class RemoveKnobOp
extends SyncOp {
    Knob knob;

    public RemoveKnobOp(BComponent c, Knob knob) {
        super(c);
        this.knob = knob;
    }

    public RemoveKnobOp() {
    }

    @Override
    public int getId() {
        return 106;
    }

    public Knob getKnob() {
        return this.knob;
    }

    @Override
    void commit(SyncBuffer parent, BComponentSpace space, Context context) throws Exception {
        if (this.knob != null) {
            ((ComponentSlotMap)this.component.fw(1)).uninstallKnob((NKnob)this.knob);
        }
    }

    @Override
    void encode(SyncEncoder out) throws Exception {
        super.encode(out);
        NKnob knob = (NKnob)this.knob;
        out.attr("id", String.valueOf(knob.id));
        out.attr("ss", String.valueOf(knob.getSourceSlotName())).end().newLine();
    }

    @Override
    void decode(SyncBuffer buffer, BComponentSpace space, SyncDecoder in) throws Exception {
        super.decode(buffer, space, in);
        if (this.component == null) {
            return;
        }
        IElement elem = in.elem();
        int id = elem.geti("id");
        Slot slot = this.component.getSlot(elem.get("ss"));
        if (slot != null) {
            Knob[] knobs = this.component.getKnobs(slot);
            for (int i = 0; i < knobs.length; ++i) {
                if (((NKnob)knobs[i]).id != id) continue;
                this.knob = knobs[i];
                break;
            }
        }
    }

    @Override
    public String toString() {
        return "RemoveKnob: " + this.componentToString() + " " + this.knob;
    }
}

