/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.sync;

import com.tridium.nre.util.IElement;
import javax.baja.space.BComponentSpace;
import javax.baja.sync.SyncBuffer;
import javax.baja.sync.SyncDecoder;
import javax.baja.sync.SyncEncoder;
import javax.baja.sync.SyncOp;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.Context;

public class SetFacetsOp
extends SyncOp {
    String name;
    BFacets facets;

    public SetFacetsOp(BComponent c, String name, BFacets facets) {
        super(c);
        this.name = name;
        this.facets = facets;
    }

    public SetFacetsOp() {
    }

    @Override
    public int getId() {
        return 120;
    }

    public String getSlotName() {
        return this.name;
    }

    public BFacets getFacets() {
        return this.facets;
    }

    @Override
    void commit(SyncBuffer parent, BComponentSpace space, Context context) throws Exception {
        this.component.setFacets(this.component.getSlot(this.name), this.facets, context);
    }

    @Override
    void encode(SyncEncoder out) throws Exception {
        super.encode(out);
        out.attr("n", this.name);
        out.attr("x", this.facets.encodeToString()).end().newLine();
    }

    @Override
    void decode(SyncBuffer buffer, BComponentSpace space, SyncDecoder in) throws Exception {
        super.decode(buffer, space, in);
        IElement elem = in.elem();
        this.name = elem.get("n");
        this.facets = BFacets.make(elem.get("x"));
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("SetFacets: ").append(this.componentToString()).append('.').append(this.name).append(" -> ").append(this.facets);
        return s.toString();
    }
}

