/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.sync;

import javax.baja.space.BComponentSpace;
import javax.baja.sync.AddKnobOp;
import javax.baja.sync.AddOp;
import javax.baja.sync.AddRelationKnobOp;
import javax.baja.sync.FireTopicOp;
import javax.baja.sync.LoadOp;
import javax.baja.sync.RemoveKnobOp;
import javax.baja.sync.RemoveOp;
import javax.baja.sync.RemoveRelationKnobOp;
import javax.baja.sync.RenameOp;
import javax.baja.sync.ReorderOp;
import javax.baja.sync.SetCategoryMaskOp;
import javax.baja.sync.SetFacetsOp;
import javax.baja.sync.SetFlagsOp;
import javax.baja.sync.SetOp;
import javax.baja.sync.SyncBuffer;
import javax.baja.sync.SyncDecoder;
import javax.baja.sync.SyncEncoder;
import javax.baja.sys.BComponent;
import javax.baja.sys.Context;

public abstract class SyncOp {
    public static final int LOAD = 108;
    public static final int SET = 115;
    public static final int ADD = 97;
    public static final int REMOVE = 118;
    public static final int RENAME = 114;
    public static final int REORDER = 111;
    public static final int SET_FLAGS = 102;
    public static final int SET_FACETS = 120;
    public static final int ADD_KNOB = 107;
    public static final int REMOVE_KNOB = 106;
    public static final int ADD_RELATION_KNOB = 109;
    public static final int REMOVE_RELATION_KNOB = 110;
    public static final int FIRE_TOPIC = 116;
    public static final int SET_CATEGORY_MASK = 99;
    SyncBuffer buffer;
    BComponent component;
    SyncOp prev;
    SyncOp next;
    String handle;
    boolean committed;

    public static SyncOp make(int id) {
        switch (id) {
            case 108: {
                return new LoadOp();
            }
            case 115: {
                return new SetOp();
            }
            case 97: {
                return new AddOp();
            }
            case 118: {
                return new RemoveOp();
            }
            case 114: {
                return new RenameOp();
            }
            case 111: {
                return new ReorderOp();
            }
            case 102: {
                return new SetFlagsOp();
            }
            case 120: {
                return new SetFacetsOp();
            }
            case 107: {
                return new AddKnobOp();
            }
            case 106: {
                return new RemoveKnobOp();
            }
            case 109: {
                return new AddRelationKnobOp();
            }
            case 110: {
                return new RemoveRelationKnobOp();
            }
            case 116: {
                return new FireTopicOp();
            }
            case 99: {
                return new SetCategoryMaskOp();
            }
        }
        throw new IllegalArgumentException(String.valueOf(id));
    }

    protected SyncOp(BComponent c) {
        this.component = c;
        if (this.component != null) {
            this.handle = String.valueOf(this.component.getHandle());
        }
    }

    protected SyncOp() {
    }

    public abstract int getId();

    public BComponent getComponent() {
        return this.component;
    }

    abstract void commit(SyncBuffer var1, BComponentSpace var2, Context var3) throws Exception;

    void encode(SyncEncoder out) throws Exception {
        this.handle = "?";
        if (this.component != null) {
            this.handle = String.valueOf(this.component.getHandle());
        }
        out.start(String.valueOf((char)this.getId())).attr("h", this.handle);
        out.encodingSyncOp(this);
    }

    void decode(SyncBuffer buffer, BComponentSpace space, SyncDecoder in) throws Exception {
        this.handle = in.elem().get("h");
        this.component = buffer != null ? buffer.findByHandle(this.handle, false) : space.findByHandle(this.handle, false);
    }

    public abstract String toString();

    String componentToString() {
        return this.component != null ? this.component.toPathString() : "null";
    }

    static class SyncOpSecurityException
    extends SecurityException {
        SyncOpSecurityException() {
        }

        SyncOpSecurityException(String s) {
            super(s);
        }
    }
}

