/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.sys;

import com.tridium.util.TimeFormat;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BDate;
import javax.baja.sys.BIComparable;
import javax.baja.sys.BIDate;
import javax.baja.sys.BITime;
import javax.baja.sys.BMonth;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BSimple;
import javax.baja.sys.BTime;
import javax.baja.sys.BWeekday;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.timezone.DstRule;
import javax.baja.util.LexiconModule;

@NiagaraType
public final class BAbsTime
extends BSimple
implements BIDate,
BITime,
BIComparable,
BIDataValue {
    private static final int[] daysInMonth = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    public static final BAbsTime DEFAULT;
    public static final BAbsTime NULL;
    public static final String TIME_MODE_FACET = "timeMode";
    public static final int TIME_MODE_DEFAULT = 0;
    public static final int TIME_MODE_WALL_STRICT = 1;
    public static final int TIME_MODE_STANDARD = 2;
    public static final int TIME_MODE_DAYLIGHT = 3;
    public static final int TIME_MODE_UTC = 4;
    public static final int TIME_MODE_WALL_SCHD = 5;
    public static final BAbsTime END_OF_TIME;
    public static final Type TYPE;
    private long millis;
    private BTimeZone timeZone;
    private int bits0;
    private int bits1;

    public static BAbsTime make() {
        return new BAbsTime(System.currentTimeMillis(), BTimeZone.getLocal());
    }

    public static BAbsTime now() {
        return new BAbsTime(System.currentTimeMillis(), BTimeZone.getLocal());
    }

    public static BAbsTime make(long millis) {
        if (millis == 0L) {
            return NULL;
        }
        if (millis >= END_OF_TIME.getMillis()) {
            return END_OF_TIME;
        }
        return new BAbsTime(millis, BTimeZone.getLocal());
    }

    public static BAbsTime make(long millis, BTimeZone timeZone) {
        return new BAbsTime(millis, timeZone);
    }

    public static BAbsTime make(int year, BMonth month, int day) {
        return BAbsTime.make(year, month, day, 0, 0, 0, 0, BTimeZone.getLocal(), null);
    }

    public static BAbsTime make(int year, BMonth month, int day, int hour, int min) {
        return BAbsTime.make(year, month, day, hour, min, 0, 0, BTimeZone.getLocal(), null);
    }

    public static BAbsTime make(int year, BMonth month, int day, int hour, int min, int sec, int millis) {
        return BAbsTime.make(year, month, day, hour, min, sec, millis, BTimeZone.getLocal(), null);
    }

    public static BAbsTime make(int year, BMonth month, int day, int hour, int min, int sec, int millis, BTimeZone timeZone) {
        return BAbsTime.make(year, month, day, hour, min, sec, millis, timeZone, null);
    }

    public static BAbsTime make(int year, BMonth month, int day, int hour, int min, int sec, int millis, BTimeZone timeZone, Context cx) {
        Calendar calendar = BAbsTime.makeCalendar(year, month, day, hour, min, sec, millis, timeZone, cx);
        BAbsTime result = new BAbsTime(calendar.getTimeInMillis(), timeZone);
        int x = calendar.get(1);
        result.bits0 |= (x & 0xFFFF) << 16;
        x = calendar.get(14);
        result.bits0 |= (x & 0xFFFF) << 0;
        x = calendar.get(2);
        result.bits1 |= (x & 0xF) << 25;
        x = calendar.get(5);
        result.bits1 |= (x & 0x1F) << 20;
        x = calendar.get(11);
        result.bits1 |= (x & 0x1F) << 15;
        x = calendar.get(12);
        result.bits1 |= (x & 0x3F) << 9;
        x = calendar.get(13);
        result.bits1 |= (x & 0x3F) << 3;
        x = calendar.get(7) - 1;
        result.bits1 |= (x & 7) << 0;
        if (calendar.get(16) != 0) {
            result.bits1 |= 0x20000000;
        }
        return result;
    }

    public static Calendar makeCalendar(int year, BMonth month, int day, int hour, int min, int sec, int millis, BTimeZone timeZone, Context cx) {
        int timeMode = cx == null ? 0 : cx.getFacets().geti(TIME_MODE_FACET, 0);
        GregorianCalendar result = new GregorianCalendar(timeZone.getJavaTimeZone());
        boolean convertResultToWall = false;
        if (timeMode == 4) {
            result.set(15, 0);
            result.set(16, 0);
            convertResultToWall = true;
        } else if (timeMode == 3) {
            result.set(15, timeZone.getUtcOffset());
            result.set(16, timeZone.getDaylightAdjustment());
            convertResultToWall = true;
        } else if (timeMode == 2) {
            result.set(15, timeZone.getUtcOffset());
            result.set(16, 0);
            convertResultToWall = true;
        } else if (timeMode == 0 || timeMode == 1 || timeMode == 5) {
            DstRule endRule;
            boolean checkEndTime = timeMode == 1;
            DstRule startRule = timeZone.getDaylightStartRule();
            if (startRule != null) {
                BMonth startMonth = startRule.getMonth();
                int startDay = DstRule.getUtcDayOfMonth(year, startRule);
                long startTimeStdMillis = Long.MIN_VALUE;
                if (startRule.getTimeMode() == 2) {
                    int daysInMonth = BAbsTime.getDaysInMonth(year, startMonth);
                    for (startTimeStdMillis = startRule.getTime().getTimeOfDayMillis() + (long)timeZone.getUtcOffset(); startTimeStdMillis >= 86400000L; startTimeStdMillis -= 86400000L) {
                        if (++startDay <= daysInMonth) continue;
                        startMonth = startMonth.next();
                        startDay = 1;
                        daysInMonth = BAbsTime.getDaysInMonth(year, startMonth);
                    }
                    while (startTimeStdMillis < 0L) {
                        startTimeStdMillis += 86400000L;
                        if (--startDay >= 1) continue;
                        startMonth = startMonth.previous();
                        startDay = daysInMonth = BAbsTime.getDaysInMonth(year, startMonth);
                    }
                }
                if (month.equals(startMonth)) {
                    checkEndTime = false;
                    if (day == startDay) {
                        long timeOfDayMillis = BTime.make(hour, min, sec, millis).getTimeOfDayMillis();
                        if (startTimeStdMillis == Long.MIN_VALUE) {
                            startTimeStdMillis = startRule.getTime().getTimeOfDayMillis();
                        }
                        long lostTimeEndMillis = startTimeStdMillis + (long)timeZone.getDaylightAdjustment();
                        if (timeOfDayMillis >= startTimeStdMillis && timeOfDayMillis < lostTimeEndMillis) {
                            if (timeMode == 1) {
                                throw new LocalizableRuntimeException("baja", "AbsTime.invalidWallTime", new Object[]{BTime.make(hour, min, sec, millis)});
                            }
                            BTime lostTimeEnd = timeMode == 0 ? BTime.make(BRelTime.make(timeOfDayMillis + (long)timeZone.getDaylightAdjustment())) : BTime.make(BRelTime.make(lostTimeEndMillis));
                            hour = lostTimeEnd.getHour();
                            min = lostTimeEnd.getMinute();
                            sec = 0;
                            millis = 0;
                        }
                    }
                }
            }
            if (checkEndTime && (endRule = timeZone.getDaylightEndRule()) != null) {
                int daysInMonth;
                BMonth endMonth = endRule.getMonth();
                int endDay = DstRule.getUtcDayOfMonth(year, endRule);
                long endTimeStdMillis = Long.MIN_VALUE;
                if (endRule.getTimeMode() == 2) {
                    daysInMonth = BAbsTime.getDaysInMonth(year, endMonth);
                    for (endTimeStdMillis = endRule.getTime().getTimeOfDayMillis() + (long)timeZone.getUtcOffset(); endTimeStdMillis >= 86400000L; endTimeStdMillis -= 86400000L) {
                        if (++endDay <= daysInMonth) continue;
                        endMonth = endMonth.next();
                        endDay = 1;
                        daysInMonth = BAbsTime.getDaysInMonth(year, endMonth);
                    }
                    while (endTimeStdMillis < 0L) {
                        endTimeStdMillis += 86400000L;
                        if (--endDay >= 1) continue;
                        endMonth = endMonth.previous();
                        endDay = daysInMonth = BAbsTime.getDaysInMonth(year, endMonth);
                    }
                } else if (endRule.getTimeMode() == 0) {
                    daysInMonth = BAbsTime.getDaysInMonth(year, endMonth);
                    for (endTimeStdMillis = endRule.getTime().getTimeOfDayMillis() - (long)timeZone.getDaylightAdjustment(); endTimeStdMillis < 0L; endTimeStdMillis += 86400000L) {
                        if (--endDay >= 1) continue;
                        endMonth = endMonth.previous();
                        endDay = daysInMonth = BAbsTime.getDaysInMonth(year, endMonth);
                    }
                }
                if (month.equals(endMonth)) {
                    checkEndTime = false;
                    if (day == endDay) {
                        long timeOfDayMillis = BTime.make(hour, min, sec, millis).getTimeOfDayMillis();
                        if (endTimeStdMillis == Long.MIN_VALUE) {
                            endTimeStdMillis = endRule.getTime().getTimeOfDayMillis();
                        }
                        long ambigTimeEndMillis = endTimeStdMillis + (long)timeZone.getDaylightAdjustment();
                        if (timeOfDayMillis >= endTimeStdMillis && timeOfDayMillis < ambigTimeEndMillis) {
                            throw new LocalizableRuntimeException("baja", "AbsTime.ambigWallTime", new Object[]{BTime.make(hour, min, sec, millis)});
                        }
                    }
                }
            }
        }
        result.set(year, month.getOrdinal(), day, hour, min, sec);
        result.set(14, millis);
        if (convertResultToWall) {
            long calMillis = result.getTimeInMillis();
            result = new GregorianCalendar(timeZone.getJavaTimeZone());
            result.setTimeInMillis(calMillis);
        }
        return result;
    }

    public static BAbsTime make(BAbsTime date, BTime time) {
        return BAbsTime.make(date.getYear(), date.getMonth(), date.getDay(), time.getHour(), time.getMinute(), time.getSecond(), time.getMillisecond(), date.getTimeZone());
    }

    public static BAbsTime make(BDate date, BTime time, BTimeZone zone) {
        return BAbsTime.make(date.getYear(), date.getMonth(), date.getDay(), time.getHour(), time.getMinute(), time.getSecond(), time.getMillisecond(), zone);
    }

    public static BAbsTime make(BAbsTime absTime, BTimeZone timeZone) {
        if (absTime.timeZone == timeZone) {
            return absTime;
        }
        return BAbsTime.make(absTime.millis, timeZone);
    }

    public static BAbsTime makeDayOfYear(int year, int dayOfYear, int hour, int min, int sec, int ms, BTimeZone timeZone) {
        int daysInYear = BAbsTime.getDaysInYear(year);
        if (dayOfYear > daysInYear) {
            throw new IllegalArgumentException(dayOfYear + " > " + daysInYear);
        }
        if (dayOfYear < 1) {
            throw new IllegalArgumentException(dayOfYear + " < 1");
        }
        BMonth month = BMonth.january;
        int daysInMonth = BAbsTime.getDaysInMonth(year, month);
        while (dayOfYear > daysInMonth) {
            dayOfYear -= daysInMonth;
            month = month.next();
            daysInMonth = BAbsTime.getDaysInMonth(year, month);
        }
        return BAbsTime.make(year, month, dayOfYear, hour, min, sec, ms, timeZone);
    }

    public static BAbsTime make(String s) throws IOException {
        return (BAbsTime)DEFAULT.decodeFromString(s);
    }

    private BAbsTime(long millis, BTimeZone timeZone) {
        this.millis = millis;
        this.timeZone = timeZone;
    }

    public long getMillis() {
        return this.millis;
    }

    @Override
    public final int getYear() {
        if (this.bits0 == 0) {
            this.millisToFields();
        }
        return this.bits0 >> 16 & 0xFFFF;
    }

    @Override
    public final BMonth getMonth() {
        if (this.bits0 == 0) {
            this.millisToFields();
        }
        return BMonth.make(this.bits1 >> 25 & 0xF);
    }

    @Override
    public final int getDay() {
        if (this.bits0 == 0) {
            this.millisToFields();
        }
        return this.bits1 >> 20 & 0x1F;
    }

    @Override
    public final int getHour() {
        if (this.bits0 == 0) {
            this.millisToFields();
        }
        return this.bits1 >> 15 & 0x1F;
    }

    @Override
    public final int getMinute() {
        if (this.bits0 == 0) {
            this.millisToFields();
        }
        return this.bits1 >> 9 & 0x3F;
    }

    @Override
    public final int getSecond() {
        if (this.bits0 == 0) {
            this.millisToFields();
        }
        return this.bits1 >> 3 & 0x3F;
    }

    @Override
    public final int getMillisecond() {
        if (this.bits0 == 0) {
            this.millisToFields();
        }
        return this.bits0 & 0xFFFF;
    }

    @Override
    public final BWeekday getWeekday() {
        if (this.bits0 == 0) {
            this.millisToFields();
        }
        return BWeekday.make(this.bits1 & 7);
    }

    public static BWeekday getWeekday(int year, BMonth month, int day) {
        GregorianCalendar cal = new GregorianCalendar(BTimeZone.getJavaUTCInstance());
        cal.set(year, month.getOrdinal(), day);
        int wd = cal.get(7);
        if (wd == 1) {
            return BWeekday.sunday;
        }
        if (wd == 2) {
            return BWeekday.monday;
        }
        if (wd == 3) {
            return BWeekday.tuesday;
        }
        if (wd == 4) {
            return BWeekday.wednesday;
        }
        if (wd == 5) {
            return BWeekday.thursday;
        }
        if (wd == 6) {
            return BWeekday.friday;
        }
        if (wd == 7) {
            return BWeekday.saturday;
        }
        throw new BajaRuntimeException("Unrecognized weekday: " + wd);
    }

    @Override
    public final long getTimeOfDayMillis() {
        return (long)(this.getHour() * 60 * 60) * 1000L + (long)(this.getMinute() * 60) * 1000L + (long)this.getSecond() * 1000L + (long)this.getMillisecond();
    }

    @Override
    public final int getDayOfYear() {
        int thisYear = this.getYear();
        BMonth thisMonth = this.getMonth();
        int dayOfYear = 0;
        for (BMonth m = BMonth.january; m != thisMonth; m = m.next()) {
            dayOfYear += BAbsTime.getDaysInMonth(thisYear, m);
        }
        return dayOfYear += this.getDay();
    }

    public BDate getDate() {
        return BDate.make(this.getYear(), this.getMonth(), this.getDay());
    }

    public BTime getTime() {
        return BTime.make(this.getHour(), this.getMinute(), this.getSecond(), this.getMillisecond());
    }

    public BTimeZone getTimeZone() {
        return this.timeZone;
    }

    public int getTimeZoneOffset() {
        return this.timeZone.getCurrentUtcOffset(this.millis);
    }

    public boolean inDaylightTime() {
        if (this.bits0 == 0) {
            this.millisToFields();
        }
        return (this.bits1 >> 29 & 1) != 0;
    }

    public String getTimeZoneName(Context cx) {
        return this.timeZone.getDisplayName(this, cx);
    }

    public String getTimeZoneShortName(Context cx) {
        return this.timeZone.getShortDisplayName(this, cx);
    }

    public BAbsTime toLocalTime() {
        if (this.timeZone.equals(BTimeZone.getLocal())) {
            return this;
        }
        return BAbsTime.make(this, BTimeZone.getLocal());
    }

    public BAbsTime toUtcTime() {
        if (this.timeZone.equals(BTimeZone.UTC)) {
            return this;
        }
        return BAbsTime.make(this, BTimeZone.UTC);
    }

    public BAbsTime toNormalizedTime() {
        if (this.timeZone.equals(BTimeZone.NULL)) {
            return this;
        }
        return BAbsTime.make(this, BTimeZone.NULL);
    }

    public BAbsTime add(BRelTime relTime) {
        return BAbsTime.make(this.millis + relTime.getMillis(), this.timeZone);
    }

    public BAbsTime subtract(BRelTime relTime) {
        return BAbsTime.make(this.millis - relTime.getMillis(), this.timeZone);
    }

    public BRelTime delta(BAbsTime t2) {
        return BRelTime.make(t2.millis - this.millis);
    }

    public BAbsTime timeOfDay(int hour, int min, int sec, int millis) {
        return BAbsTime.make(this.getYear(), this.getMonth(), this.getDay(), hour, min, sec, millis, BTimeZone.getLocal());
    }

    public BAbsTime nextDay() {
        int year = this.getYear();
        int month = this.getMonth().getOrdinal();
        int day = this.getDay();
        if (day == BAbsTime.getDaysInMonth(year, BMonth.make(month))) {
            day = 1;
            if (month == 11) {
                month = 0;
                ++year;
            } else {
                ++month;
            }
        } else {
            ++day;
        }
        return BAbsTime.make(year, BMonth.make(month), day, this.getHour(), this.getMinute(), this.getSecond(), this.getMillisecond(), this.getTimeZone());
    }

    public BAbsTime prevDay() {
        int year = this.getYear();
        int month = this.getMonth().getOrdinal();
        int day = this.getDay();
        if (day == 1) {
            if (month == 0) {
                month = 11;
                --year;
            } else {
                --month;
            }
            day = BAbsTime.getDaysInMonth(year, BMonth.make(month));
        } else {
            --day;
        }
        return BAbsTime.make(year, BMonth.make(month), day, this.getHour(), this.getMinute(), this.getSecond(), this.getMillisecond(), this.getTimeZone());
    }

    public BAbsTime nextMonth() {
        int year = this.getYear();
        int month = this.getMonth().getOrdinal();
        int day = this.getDay();
        if (month == 11) {
            month = 0;
            ++year;
        } else if (day == BAbsTime.getDaysInMonth(year, BMonth.make(month))) {
            day = BAbsTime.getDaysInMonth(year, BMonth.make(++month));
        } else if (day > BAbsTime.getDaysInMonth(year, BMonth.make(++month))) {
            day = BAbsTime.getDaysInMonth(year, BMonth.make(month));
        }
        return BAbsTime.make(year, BMonth.make(month), day, this.getHour(), this.getMinute(), this.getSecond(), this.getMillisecond(), this.getTimeZone());
    }

    public BAbsTime prevMonth() {
        int year = this.getYear();
        int month = this.getMonth().getOrdinal();
        int day = this.getDay();
        if (month == 0) {
            month = 11;
            --year;
        } else if (day == BAbsTime.getDaysInMonth(year, BMonth.make(month))) {
            day = BAbsTime.getDaysInMonth(year, BMonth.make(--month));
        } else if (day > BAbsTime.getDaysInMonth(year, BMonth.make(--month))) {
            day = BAbsTime.getDaysInMonth(year, BMonth.make(month));
        }
        return BAbsTime.make(year, BMonth.make(month), day, this.getHour(), this.getMinute(), this.getSecond(), this.getMillisecond(), this.getTimeZone());
    }

    public BAbsTime nextYear() {
        int day = this.getDay();
        if (this.isLeapDay()) {
            day = 28;
        }
        return BAbsTime.make(this.getYear() + 1, this.getMonth(), day, this.getHour(), this.getMinute(), this.getSecond(), this.getMillisecond(), this.getTimeZone());
    }

    public BAbsTime prevYear() {
        int day = this.getDay();
        if (this.isLeapDay()) {
            day = 28;
        }
        return BAbsTime.make(this.getYear() - 1, this.getMonth(), day, this.getHour(), this.getMinute(), this.getSecond(), this.getMillisecond(), this.getTimeZone());
    }

    public BAbsTime next(BWeekday weekday) {
        BAbsTime t = this.nextDay();
        while (t.getWeekday() != weekday) {
            t = t.nextDay();
        }
        return t;
    }

    public BAbsTime prev(BWeekday weekday) {
        BAbsTime t = this.prevDay();
        while (t.getWeekday() != weekday) {
            t = t.prevDay();
        }
        return t;
    }

    @Override
    public int compareTo(Object obj) {
        BAbsTime t = (BAbsTime)obj;
        if (this.millis < t.millis) {
            return -1;
        }
        if (this.millis == t.millis) {
            return 0;
        }
        return 1;
    }

    public boolean isBefore(BAbsTime x) {
        return this.compareTo(x) < 0;
    }

    public boolean isAfter(BAbsTime x) {
        return this.compareTo(x) > 0;
    }

    @Override
    public int hashCode() {
        return (int)(this.millis ^ this.millis >> 32);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof BAbsTime) {
            return ((BAbsTime)obj).millis == this.millis;
        }
        return false;
    }

    public boolean dateEquals(BAbsTime other) {
        return other.getYear() == this.getYear() && other.getMonth() == this.getMonth() && other.getDay() == this.getDay();
    }

    public boolean timeEquals(BAbsTime other) {
        return other.getTimeOfDayMillis() == this.getTimeOfDayMillis();
    }

    @Override
    public boolean isLeapDay() {
        return this.getMonth() == BMonth.february && this.getDay() == 29;
    }

    public static boolean isLeapYear(int year) {
        if (year >= 1582) {
            return year % 4 == 0 && (year % 100 != 0 || year % 400 == 0);
        }
        return year % 4 == 0;
    }

    public static int getDaysInMonth(int year, BMonth month) {
        if (month == BMonth.february) {
            return BAbsTime.isLeapYear(year) ? 29 : 28;
        }
        return daysInMonth[month.getOrdinal()];
    }

    public static int getDaysInYear(int year) {
        return BAbsTime.isLeapYear(year) ? 366 : 365;
    }

    @Override
    public void encode(DataOutput out) throws IOException {
        out.writeLong(this.millis);
    }

    @Override
    public BObject decode(DataInput in) throws IOException {
        long timeInMillis = 0L;
        int firstByte = in.readUnsignedByte();
        if (firstByte == 0) {
            in.readByte();
            timeInMillis |= (long)(in.readByte() & 0xFF) << 40;
        } else {
            timeInMillis |= (long)(firstByte - 16 & 0xFF) << 40;
        }
        for (int i = 4; i >= 0; --i) {
            timeInMillis |= (long)(in.readByte() & 0xFF) << 8 * i;
        }
        return BAbsTime.make(timeInMillis);
    }

    public void encode48(DataOutput out) throws IOException {
        out.write((byte)((this.millis >> 40) + 16L & 0xFFL));
        for (int i = 4; i >= 0; --i) {
            out.write((byte)(this.millis >> 8 * i & 0xFFL));
        }
    }

    public BObject decode48(DataInput input) throws IOException {
        return this.decode(input);
    }

    public BObject decode64(DataInput in) throws IOException {
        return BAbsTime.make(in.readLong());
    }

    @Override
    public String encodeToString() {
        StringBuilder s = new StringBuilder(32);
        if (this.getYear() > 9999) {
            throw new IllegalStateException("Year must be < 9999.");
        }
        s.append(TextUtil.padZeros((String)String.valueOf(this.getYear()), (int)4)).append('-');
        int month = this.getMonth().getOrdinal() + 1;
        s.append(TextUtil.padZeros((String)String.valueOf(month), (int)2)).append('-');
        int day = this.getDay();
        s.append(TextUtil.padZeros((String)String.valueOf(day), (int)2)).append('T');
        int hour = this.getHour();
        s.append(TextUtil.padZeros((String)String.valueOf(hour), (int)2)).append(':');
        int min = this.getMinute();
        s.append(TextUtil.padZeros((String)String.valueOf(min), (int)2)).append(':');
        int sec = this.getSecond();
        s.append(TextUtil.padZeros((String)String.valueOf(sec), (int)2)).append('.');
        int millis = this.getMillisecond();
        s.append(TextUtil.padZeros((String)String.valueOf(millis), (int)3));
        int offset = this.getTimeZoneOffset();
        if (offset == 0) {
            s.append('Z');
        } else {
            int hrOff = Math.abs(offset / 3600000);
            int minOff = Math.abs(offset % 3600000 / 60000);
            if (offset < 0) {
                s.append('-');
            } else {
                s.append('+');
            }
            s.append(TextUtil.padZeros((String)String.valueOf(hrOff), (int)2)).append(':');
            s.append(TextUtil.padZeros((String)String.valueOf(minOff), (int)2));
        }
        return s.toString();
    }

    @Override
    public BObject decodeFromString(String s) throws IOException {
        char[] c = s.toCharArray();
        try {
            char sign;
            int i = 0;
            int year = (c[i++] - 48) * 1000 + (c[i++] - 48) * 100 + (c[i++] - 48) * 10 + (c[i++] - 48) * 1;
            if (c[i++] != '-') {
                throw new Exception();
            }
            int mon = (c[i++] - 48) * 10 + (c[i++] - 48) * 1;
            if (c[i++] != '-') {
                throw new Exception();
            }
            int day = (c[i++] - 48) * 10 + (c[i++] - 48) * 1;
            if (c[i++] != 'T') {
                throw new Exception();
            }
            int hour = (c[i++] - 48) * 10 + (c[i++] - 48) * 1;
            if (c[i++] != ':') {
                throw new Exception();
            }
            int min = (c[i++] - 48) * 10 + (c[i++] - 48) * 1;
            if (c[i++] != ':') {
                throw new Exception();
            }
            int sec = (c[i++] - 48) * 10 + (c[i++] - 48) * 1;
            int ms = 0;
            if (c[i] == '.') {
                int n = ++i;
                ms = (c[n] - 48) * 100;
                if ('0' <= c[++i] && c[i] <= '9') {
                    ms += (c[i++] - 48) * 10;
                }
                if ('0' <= c[i] && c[i] <= '9') {
                    ms += (c[i++] - 48) * 1;
                }
                while (i < c.length && '0' <= c[i] && c[i] <= '9') {
                    ++i;
                }
            }
            int tzOff = 0;
            if ((sign = c[i++]) != 'Z') {
                if (sign != '+' && sign != '-') {
                    throw new Exception();
                }
                int hrOff = c[i++] - 48;
                if (i < c.length && c[i] != ':') {
                    hrOff = hrOff * 10 + c[i++] - 48;
                }
                int minOff = 0;
                if (i < c.length) {
                    if (c[i++] != ':') {
                        throw new Exception();
                    }
                    minOff = 10 * (c[i++] - 48) + c[i++] - 48;
                }
                tzOff = hrOff * 3600000 + minOff * 60000;
                if (sign == '-') {
                    tzOff *= -1;
                }
            }
            GregorianCalendar cal = new GregorianCalendar(new SimpleTimeZone(tzOff, "Offset"));
            cal.set(year, mon - 1, day, hour, min, sec);
            cal.set(14, ms);
            return BAbsTime.make(cal.getTime().getTime());
        }
        catch (Exception e) {
            throw new IOException("Invalid BAbsTime: " + s);
        }
    }

    @Override
    public BIDataValue toDataValue() {
        return this;
    }

    @Override
    public boolean isNull() {
        return this.millis == 0L;
    }

    public String toDateString(Context context) {
        if (this.millis == 0L) {
            return this.toNullString(context);
        }
        return TimeFormat.formatDate(this, context);
    }

    public String toTimeString(Context context) {
        if (this.millis == 0L) {
            return this.toNullString(context);
        }
        return TimeFormat.formatTime(this, context);
    }

    @Override
    public String toString(Context context) {
        if (this.millis == 0L) {
            return this.toNullString(context);
        }
        return TimeFormat.format(this, context);
    }

    private String toNullString(Context cx) {
        return LexiconModuleHolder.LEX.get("AbsTime.null", cx, "null");
    }

    private void millisToFields() {
        TimeZone utilTz = (TimeZone)this.timeZone.tzSupport();
        if (utilTz == null) {
            throw new LocalizableRuntimeException("baja", "AbsTime.unsupportedTimeZone", new Object[]{this.timeZone.getId()});
        }
        int offset = utilTz.getOffset(this.millis);
        GregorianCalendar calendar = new GregorianCalendar(new SimpleTimeZone(offset, "Offset"));
        calendar.setTimeInMillis(this.millis);
        int zeroBitsToSet = 0;
        int oneBitsToSet = 0;
        int x = calendar.get(1);
        zeroBitsToSet |= (x & 0xFFFF) << 16;
        x = calendar.get(14);
        zeroBitsToSet |= (x & 0xFFFF) << 0;
        x = calendar.get(2);
        oneBitsToSet |= (x & 0xF) << 25;
        x = calendar.get(5);
        oneBitsToSet |= (x & 0x1F) << 20;
        x = calendar.get(11);
        oneBitsToSet |= (x & 0x1F) << 15;
        x = calendar.get(12);
        oneBitsToSet |= (x & 0x3F) << 9;
        x = calendar.get(13);
        oneBitsToSet |= (x & 0x3F) << 3;
        x = calendar.get(7) - 1;
        oneBitsToSet |= (x & 7) << 0;
        if (utilTz.inDaylightTime(calendar.getTime())) {
            oneBitsToSet |= 0x20000000;
        }
        this.bits1 = oneBitsToSet;
        this.bits0 = zeroBitsToSet;
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    static {
        NULL = DEFAULT = new BAbsTime(0L, BTimeZone.getLocal());
        END_OF_TIME = BAbsTime.make(9999, BMonth.december, 31, 23, 59, 59, 999, BTimeZone.UTC);
        TYPE = Sys.loadType(BAbsTime.class);
    }

    private static final class LexiconModuleHolder {
        private static final LexiconModule LEX = LexiconModule.make("baja");

        private LexiconModuleHolder() {
        }
    }
}

