/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.sys;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BBitString;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public final class BComponentEventMask
extends BBitString {
    public static final BComponentEventMask PROPERTY_EVENTS = new BComponentEventMask(395263);
    public static final BComponentEventMask SELF_EVENTS = new BComponentEventMask(1701888);
    public static final BComponentEventMask EMPTY = new BComponentEventMask(0);
    public static final BComponentEventMask ALL = new BComponentEventMask(-1);
    public static final BComponentEventMask DEFAULT = EMPTY;
    public static final Type TYPE = Sys.loadType(BComponentEventMask.class);
    private static BBitString.Support support = new BBitString.Support(DEFAULT);
    private int bits;

    public static BComponentEventMask make() {
        return EMPTY;
    }

    public static BComponentEventMask make(int bits) {
        return new BComponentEventMask(bits);
    }

    public static BComponentEventMask make(int[] componentEvents) {
        int bits = 0;
        for (int i = 0; i < componentEvents.length; ++i) {
            bits |= 1 << componentEvents[i];
        }
        if (bits == BComponentEventMask.EMPTY.bits) {
            return EMPTY;
        }
        return new BComponentEventMask(bits);
    }

    public static BComponentEventMask make(BComponentEventMask oldBits, BComponentEventMask newBits, boolean set) {
        if (set) {
            return new BComponentEventMask(oldBits.bits | newBits.bits);
        }
        return new BComponentEventMask(oldBits.bits & ~newBits.bits);
    }

    private BComponentEventMask(int bits) {
        this.bits = bits;
    }

    public boolean includes(int componentEvent) {
        return 0 != (1 << componentEvent & this.bits);
    }

    public int getBits() {
        return this.bits;
    }

    @Override
    public boolean getBit(int ordinal) {
        return (this.bits & ordinal) != 0;
    }

    @Override
    public boolean getBit(String tag) {
        return this.getBit(this.tagToOrdinal(tag));
    }

    @Override
    public int[] getOrdinals() {
        return support.getOrdinals();
    }

    @Override
    public boolean isOrdinal(int ordinal) {
        return support.isOrdinal(ordinal);
    }

    @Override
    public String getTag(int ordinal) {
        return support.getTag(ordinal);
    }

    @Override
    public String getDisplayTag(int ordinal, Context cx) {
        return support.getDisplayTag(ordinal, cx);
    }

    @Override
    public BBitString getInstance(int[] ordinals) {
        int mask = 0;
        for (int i = 0; i < ordinals.length; ++i) {
            mask |= ordinals[i];
        }
        return BComponentEventMask.make(mask);
    }

    @Override
    public boolean isTag(String tag) {
        return support.isTag(tag);
    }

    @Override
    public int tagToOrdinal(String tag) {
        return support.tagToOrdinal(tag);
    }

    @Override
    public boolean isEmpty() {
        return this.bits == 0;
    }

    @Override
    public String getEmptyTag() {
        return "none";
    }

    @Override
    public boolean isNull() {
        return this.bits == 0;
    }

    @Override
    public int hashCode() {
        return this.bits;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof BComponentEventMask) {
            return ((BComponentEventMask)obj).bits == this.bits;
        }
        return false;
    }

    @Override
    public void encode(DataOutput out) throws IOException {
        out.writeInt(this.bits);
    }

    @Override
    public BObject decode(DataInput in) throws IOException {
        return BComponentEventMask.make(in.readInt());
    }

    @Override
    public String encodeToString() {
        return Integer.toHexString(this.bits);
    }

    @Override
    public BObject decodeFromString(String s) throws IOException {
        try {
            return BComponentEventMask.make(Integer.parseInt(s, 16));
        }
        catch (Exception e) {
            throw new IOException("Invalid bits: " + s);
        }
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    static {
        try {
            String[] idStrings = BComponentEvent.getIdStrings();
            for (int i = 0; i < idStrings.length; ++i) {
                support.add(i, idStrings[i]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

