/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.sys;

import com.tridium.sys.Nre;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BNumber;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.units.BUnitConversion;

@NiagaraType
public final class BDouble
extends BNumber {
    public static final BDouble POSITIVE_INFINITY = new BDouble(Double.POSITIVE_INFINITY);
    public static final BDouble NEGATIVE_INFINITY = new BDouble(Double.NEGATIVE_INFINITY);
    public static final BDouble NaN = new BDouble(Double.NaN);
    public static final BDouble DEFAULT = new BDouble(0.0);
    public static final Type TYPE = Sys.loadType(BDouble.class);
    private static Map<String, DecimalFormat> formatters = new HashMap<String, DecimalFormat>();
    private static Locale lastWorkingLocale = null;
    private double value;
    private static final long MAX_LONG_PREC = 0x20000000000000L;
    private static final long MAX_INT_PREC = Integer.MAX_VALUE;
    protected static Logger LOG = Logger.getLogger("sys");

    public static BDouble make(double value) {
        if (value == 0.0) {
            return DEFAULT;
        }
        if (value == Double.NEGATIVE_INFINITY) {
            return NEGATIVE_INFINITY;
        }
        if (value == Double.POSITIVE_INFINITY) {
            return POSITIVE_INFINITY;
        }
        if (Double.isNaN(value)) {
            return NaN;
        }
        return new BDouble(value);
    }

    public static BDouble make(String value) {
        return BDouble.make(BDouble.decode(value));
    }

    private BDouble(double value) {
        this.value = value;
    }

    @Override
    public int getInt() {
        return (int)this.value;
    }

    @Override
    public float getFloat() {
        return (float)this.value;
    }

    @Override
    public long getLong() {
        return (long)this.value;
    }

    @Override
    public double getDouble() {
        return this.value;
    }

    @Override
    public int hashCode() {
        long hash = Double.doubleToLongBits(this.value);
        return (int)(hash ^ hash >>> 32);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof BDouble) {
            double x = ((BDouble)obj).value;
            if (x == this.value) {
                return true;
            }
            if (Double.isNaN(x) && Double.isNaN(this.value)) {
                return true;
            }
        }
        return false;
    }

    public static boolean equals(double a, double b) {
        if (a == b) {
            return true;
        }
        return Double.isNaN(a) && Double.isNaN(b);
    }

    @Override
    public int compareTo(Object obj) {
        double a = this.value;
        double b = ((BNumber)obj).getDouble();
        if (a == b) {
            return 0;
        }
        if (Double.isNaN(a) && Double.isNaN(b)) {
            return 0;
        }
        if (a < b) {
            return -1;
        }
        return 1;
    }

    @Override
    public String toString(Context context) {
        return BDouble.toString(this.value, context);
    }

    @Override
    public void encode(DataOutput out) throws IOException {
        out.writeDouble(this.value);
    }

    @Override
    public BObject decode(DataInput in) throws IOException {
        return BDouble.make(in.readDouble());
    }

    @Override
    public String encodeToString() throws IOException {
        return BDouble.encode(this.value);
    }

    @Override
    public BObject decodeFromString(String s) throws IOException {
        try {
            return BDouble.make(s);
        }
        catch (RuntimeException e) {
            throw new IOException("Invalid double: " + s + "\n" + e.toString());
        }
    }

    public static String encode(double d) {
        if (d == Double.POSITIVE_INFINITY) {
            return "+inf";
        }
        if (d == Double.NEGATIVE_INFINITY) {
            return "-inf";
        }
        if (Double.isNaN(d)) {
            return "nan";
        }
        return String.valueOf(d);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double decode(String s) {
        Number n;
        if (s.equals("+inf")) {
            return Double.POSITIVE_INFINITY;
        }
        if (s.equals("-inf")) {
            return Double.NEGATIVE_INFINITY;
        }
        if (s.equals("nan")) {
            return Double.NaN;
        }
        boolean loggable = LOG.isLoggable(Level.FINE);
        StringBuilder buf = null;
        if (lastWorkingLocale != null) {
            if (loggable) {
                LOG.fine("Trying lastWorkingLocale: " + lastWorkingLocale);
            }
            if ((n = BDouble.tryLocale(s, lastWorkingLocale, loggable)) != null) {
                return n.doubleValue();
            }
            if (lastWorkingLocale != Locale.getDefault()) {
                if (loggable) {
                    LOG.fine("Trying default: " + Locale.getDefault());
                }
                if ((n = BDouble.tryLocale(s, Locale.getDefault(), loggable)) != null) {
                    return n.doubleValue();
                }
            }
        }
        try {
            if (loggable) {
                LOG.fine(String.format("Decoding '%s'", s));
                buf = new StringBuilder("  Decoding with Double.parseDouble\t");
            }
            double doubleValue = Double.parseDouble(s);
            if (loggable) {
                buf.append("  (Success!)");
            }
            double d = doubleValue;
            return d;
        }
        catch (Exception e) {
            if (loggable) {
                buf.append("  (Failed)");
            }
        }
        finally {
            if (loggable) {
                LOG.fine(buf.toString());
            }
        }
        for (Locale locale : NumberFormat.getAvailableLocales()) {
            n = BDouble.tryLocale(s, locale, loggable);
            if (n == null) continue;
            return n.doubleValue();
        }
        throw new NumberFormatException("Invalid character - unable to decode BDouble: " + s);
    }

    private static Number tryLocale(String s, Locale locale, boolean loggable) {
        ParsePosition pos = new ParsePosition(0);
        DecimalFormat localeFormat = (DecimalFormat)NumberFormat.getInstance(locale);
        localeFormat.setGroupingUsed(false);
        StringBuilder buf = null;
        if (loggable) {
            buf = new StringBuilder();
            buf.append(BDouble.formatLocale(locale, localeFormat));
        }
        Number n = localeFormat.parse(s, pos);
        if (pos.getIndex() == s.length() && n != null) {
            if (loggable) {
                buf.append(" (Success!)");
                LOG.fine(buf.toString());
                LOG.fine("Changing lastWorkingLocale to " + locale);
            }
            lastWorkingLocale = locale;
            return n;
        }
        if (loggable) {
            buf.append(" (Failed)");
            LOG.fine(buf.toString());
        }
        return null;
    }

    private static String formatLocale(Locale locale, DecimalFormat localeFormat) {
        return String.format("  Decoding with locale: %5s %3s (%20s) %s (%20s)- %20s\t", locale, locale.getCountry(), locale.getDisplayCountry(), locale.getLanguage(), locale.getDisplayLanguage(), localeFormat.toLocalizedPattern());
    }

    public static String toString(double value, Context context) {
        BUnitConversion c;
        BUnit desired;
        int prec = 2;
        BUnit units = null;
        int radix = 10;
        int convert = Nre.unitConversion;
        boolean showUnits = true;
        boolean showSeparators = false;
        boolean forceSign = false;
        if (context != null) {
            BNumber radixFacet;
            BNumber precFacet = (BNumber)context.getFacet("precision");
            if (precFacet != null) {
                prec = precFacet.getInt();
            }
            if ((units = (BUnit)context.getFacet("units")) != null && units.isNull()) {
                units = null;
            }
            if ((radixFacet = (BNumber)context.getFacet("radix")) != null) {
                radix = radixFacet.getInt();
            }
            convert = context.getFacets().geti("unitConversion", convert);
            showUnits = context.getFacets().getb("showUnits", showUnits);
            showSeparators = context.getFacets().getb("showSeparators", showSeparators);
            forceSign = context.getFacets().getb("forceSign", forceSign);
        }
        if (convert != 0 && units != null && (desired = (c = BUnitConversion.make(convert)).getDesiredUnit(units)) != units) {
            value = units.convertTo(desired, value);
            units = desired;
        }
        String s = "";
        if (showUnits && units != null && units.getIsPrefix()) {
            s = s + units.getSymbol(context) + ' ';
        }
        if (value == Double.POSITIVE_INFINITY) {
            s = s + "+inf";
        } else if (value == Double.NEGATIVE_INFINITY) {
            s = s + "-inf";
        } else if (Double.isNaN(value)) {
            s = s + "nan";
        } else if (radix != 10) {
            if ((long)Math.abs(value) >= 0x20000000000000L) {
                BigInteger number = BigDecimal.valueOf(value).toBigInteger();
                s = s + number.toString(radix);
            } else {
                s = (long)Math.abs(value) >= Integer.MAX_VALUE ? (radix == 2 ? s + Long.toBinaryString((int)value) : (radix == 8 ? s + Long.toOctalString((int)value) : (radix == 16 ? s + Long.toHexString((int)value) : s + Long.toString((long)value, radix)))) : (radix == 2 ? s + Integer.toBinaryString((int)value) : (radix == 8 ? s + Integer.toOctalString((int)value) : (radix == 16 ? s + Integer.toHexString((int)value) : s + Integer.toString((int)value, radix))));
            }
        } else if (Math.IEEEremainder(value, 1.0) == 0.0) {
            s = s + BDouble.addForcedSign(forceSign, value);
            boolean useScientificNotation = (long)Math.abs(value) >= 0x20000000000000L;
            s = s + BDouble.getFormatter(prec, showSeparators, useScientificNotation, context).format(value);
        } else {
            s = s + BDouble.addForcedSign(forceSign, value);
            s = s + BDouble.getFormatter(prec, showSeparators, false, context).format(value);
        }
        if (showUnits && units != null && !units.getIsPrefix()) {
            s = s + ' ' + units.getSymbol(context);
        }
        return s;
    }

    static String addForcedSign(boolean forceSign, double value) {
        return forceSign && value > 0.0 ? "+" : "";
    }

    static DecimalFormat getFormatter(int precision, boolean showSeparators, boolean useScientificNotation, Context cx) {
        String userLang = Context.getLanguageTag(cx);
        String key = "" + precision + showSeparators + useScientificNotation + userLang;
        DecimalFormat formatter = formatters.get(key);
        if (formatter == null) {
            StringBuilder pattern = new StringBuilder(16);
            if (useScientificNotation) {
                pattern.append("0.###############E0");
            } else {
                if (showSeparators) {
                    pattern.append("#,##0");
                } else {
                    pattern.append("#0");
                }
                if (precision > 0) {
                    pattern.append('.');
                    for (int i = 0; i < precision; ++i) {
                        pattern.append('0');
                    }
                }
            }
            formatter = !userLang.equals("") ? new DecimalFormat(pattern.toString(), DecimalFormatSymbols.getInstance(Locale.forLanguageTag(userLang))) : new DecimalFormat(pattern.toString());
            formatters.put(key, formatter);
        }
        return formatter;
    }

    @Override
    public Type getType() {
        return TYPE;
    }
}

