/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.sys;

import com.tridium.sys.schema.EnumType;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.IntHashMap;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Context;
import javax.baja.sys.InvalidEnumException;
import javax.baja.sys.ModuleNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
public final class BEnumRange
extends BSimple
implements BIDataValue {
    static int[] noDynamic = new int[0];
    static String[] noTags = new String[0];
    static IntHashMap noByOrdinal = new IntHashMap();
    static HashMap<String, Integer> noByTag = new HashMap();
    public static final BEnumRange NULL;
    public static final BEnumRange DEFAULT;
    public static final Type TYPE;
    static final BEnumRange BOOLEAN_RANGE;
    private final EnumType frozen;
    private final int[] dynamic;
    private final IntHashMap byOrdinal;
    private final HashMap<String, Integer> byTag;
    private String string;
    private final BFacets options;
    private final String lexicon;
    BFacets asFacets;
    private int hashCode = -1;

    public static BEnumRange make(Type frozenType) {
        return BEnumRange.make(frozenType, null, null, 0);
    }

    public static BEnumRange make(String[] tags) {
        int[] ordinals = new int[tags.length];
        for (int i = 0; i < ordinals.length; ++i) {
            ordinals[i] = i;
        }
        return BEnumRange.make(null, ordinals, tags, ordinals.length);
    }

    public static BEnumRange make(int[] ordinals, String[] tags) {
        return BEnumRange.make(null, ordinals, tags, ordinals.length);
    }

    public static BEnumRange make(Type frozenType, int[] ordinals, String[] tags) {
        return BEnumRange.make(frozenType, ordinals, tags, ordinals.length);
    }

    public static BEnumRange make(Type frozenType, int[] ordinals, String[] tags, int count) {
        return BEnumRange.make(frozenType, ordinals, tags, count, null);
    }

    public static BEnumRange make(Type frozenType, int[] ordinals, String[] tags, int count, BFacets options) {
        if (options == null) {
            options = BFacets.DEFAULT;
        }
        if (ordinals == null) {
            ordinals = noDynamic;
        }
        if (tags == null) {
            tags = noTags;
        }
        EnumType frozen = null;
        if (frozenType instanceof EnumType) {
            frozen = (EnumType)frozenType;
        } else if (frozenType != null) {
            throw new IllegalArgumentException("frozen type is not baja:FrozenEnum - " + frozenType);
        }
        if (count == 0 && options.isNull()) {
            if (frozen == null) {
                return DEFAULT;
            }
            if (frozen.getRange(false) != null) {
                return frozen.getRange(false);
            }
            return (BEnumRange)new BEnumRange(frozen, noDynamic, noByOrdinal, noByTag, options).intern();
        }
        IntHashMap byOrdinal = new IntHashMap();
        HashMap<String, Integer> byTag = new HashMap<String, Integer>();
        int dynaCnt = 0;
        int[] dynaOrdinals = new int[count];
        for (int i = 0; i < count; ++i) {
            int o = ordinals[i];
            String t = tags[i];
            SlotPath.verifyValidName(t);
            if (frozen != null && frozen.isOrdinal(o)) {
                Logger.getLogger("sys").warning("Ignoring dynamic enumeration " + o + ":" + t + " in fixed enum " + frozenType.getTypeName());
                continue;
            }
            if (byOrdinal.get(o) != null) {
                throw new IllegalArgumentException("Duplicate ordinal: " + t + "=" + o);
            }
            if (byTag.get(t) != null) {
                throw new IllegalArgumentException("Duplicate tag: " + t + "=" + o);
            }
            byOrdinal.put(o, (Object)t);
            byTag.put(t, o);
            dynaOrdinals[dynaCnt++] = o;
        }
        int[] ordinalsCopy = new int[dynaCnt];
        System.arraycopy(dynaOrdinals, 0, ordinalsCopy, 0, dynaCnt);
        return (BEnumRange)new BEnumRange(frozen, ordinalsCopy, byOrdinal, byTag, options).intern();
    }

    private BEnumRange(EnumType frozen, int[] dynamic, IntHashMap byOrdinal, HashMap<String, Integer> byTag, BFacets options) {
        this.frozen = frozen;
        this.dynamic = dynamic;
        this.byOrdinal = byOrdinal;
        this.byTag = byTag;
        this.options = options;
        this.lexicon = options.gets("lexicon", null);
    }

    public int[] getOrdinals() {
        int[] frozen = noDynamic;
        if (this.frozen != null) {
            frozen = this.frozen.getOrdinals();
        }
        int[] total = new int[frozen.length + this.dynamic.length];
        System.arraycopy(frozen, 0, total, 0, frozen.length);
        System.arraycopy(this.dynamic, 0, total, frozen.length, this.dynamic.length);
        return total;
    }

    public boolean isOrdinal(int ordinal) {
        if (this.frozen != null && this.frozen.isOrdinal(ordinal)) {
            return true;
        }
        return this.byOrdinal.get(ordinal) != null;
    }

    public String getTag(int ordinal) {
        String tag = (String)this.byOrdinal.get(ordinal);
        if (tag != null) {
            return tag;
        }
        if (this.frozen != null && this.frozen.isOrdinal(ordinal)) {
            return this.frozen.getTag(ordinal);
        }
        return String.valueOf(ordinal);
    }

    public String getDisplayTag(int ordinal, Context cx) {
        if (this.frozen != null && this.frozen.isOrdinal(ordinal)) {
            return this.frozen.get(ordinal).getDisplayTag(cx);
        }
        String tag = (String)this.byOrdinal.get(ordinal);
        if (tag != null) {
            if (this.lexicon != null) {
                Lexicon lex = Lexicon.make(this.lexicon, cx);
                String display = lex.get(tag, null);
                String unescapedTag = SlotPath.unescape(tag);
                if (display == null && !unescapedTag.equals(tag)) {
                    display = lex.get(unescapedTag, null);
                }
                if (display != null) {
                    return display;
                }
            }
            if (tag != null) {
                return SlotPath.unescape(tag);
            }
        }
        return String.valueOf(ordinal);
    }

    public boolean isTag(String tag) {
        if (this.frozen != null && this.frozen.isTag(tag)) {
            return true;
        }
        return this.byTag.get(tag) != null;
    }

    public int tagToOrdinal(String tag) {
        if (this.frozen != null && this.frozen.isTag(tag)) {
            return this.frozen.tagToOrdinal(tag);
        }
        Integer o = this.byTag.get(tag);
        if (o != null) {
            return o;
        }
        throw new InvalidEnumException(tag);
    }

    public BEnum get(int ordinal) {
        return this.get(ordinal, true);
    }

    public BEnum get(int ordinal, boolean dynamic) {
        if (this == BOOLEAN_RANGE) {
            return ordinal == 0 ? BBoolean.FALSE : BBoolean.TRUE;
        }
        if (this.frozen != null && this.frozen.isOrdinal(ordinal)) {
            return this.frozen.get(ordinal);
        }
        if (dynamic) {
            return BDynamicEnum.make(ordinal, this);
        }
        throw new InvalidEnumException(ordinal);
    }

    public BEnum get(String tag) {
        if (this == BOOLEAN_RANGE) {
            return tag.equals("false") ? BBoolean.FALSE : BBoolean.TRUE;
        }
        if (this.frozen != null && this.frozen.isTag(tag)) {
            return this.frozen.get(tag);
        }
        if (this.byTag.get(tag) != null) {
            return BDynamicEnum.make(this.byTag.get(tag), this);
        }
        throw new InvalidEnumException(tag);
    }

    public boolean isFrozenOrdinal(int ordinal) {
        return this.frozen != null && this.frozen.isOrdinal(ordinal);
    }

    public boolean isDynamicOrdinal(int ordinal) {
        return this.byOrdinal.get(ordinal) != null;
    }

    public Type getFrozenType() {
        return this.frozen;
    }

    public BFacets getOptions() {
        return this.options;
    }

    @Override
    public boolean isNull() {
        return this.frozen == null && this.dynamic.length == 0;
    }

    @Override
    public int hashCode() {
        try {
            if (this.hashCode == -1) {
                this.hashCode = this.encodeToString().hashCode();
            }
            return this.hashCode;
        }
        catch (Exception e) {
            return System.identityHashCode(this);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof BEnumRange) {
            EnumType t2;
            BEnumRange x = (BEnumRange)o;
            EnumType t1 = this.frozen == null ? null : this.frozen;
            EnumType enumType = t2 = x.frozen == null ? null : x.frozen;
            if (t1 != t2) {
                return false;
            }
            if (!this.options.equals(x.getOptions())) {
                return false;
            }
            return this.byOrdinal.equals((Object)x.byOrdinal);
        }
        return false;
    }

    @Override
    public final void encode(DataOutput out) throws IOException {
        out.writeUTF(this.encodeToString());
    }

    @Override
    public final BObject decode(DataInput in) throws IOException {
        return this.decodeFromString(in.readUTF());
    }

    @Override
    public final String encodeToString() throws IOException {
        if (this.string == null) {
            StringBuilder s = new StringBuilder();
            if (this.frozen != null) {
                s.append(this.frozen.getModule().getModuleName()).append(':').append(this.frozen.getTypeName());
            }
            if (this.dynamic.length > 0 || this.frozen == null) {
                if (s.length() > 0) {
                    s.append('+');
                }
                s.append('{');
                for (int i = 0; i < this.dynamic.length; ++i) {
                    int key = this.dynamic[i];
                    String tag = (String)this.byOrdinal.get(key);
                    if (i > 0) {
                        s.append(',');
                    }
                    s.append(tag).append('=').append(key);
                }
                s.append('}');
            }
            if (!this.options.isNull()) {
                s.append('?').append(this.options.encodeToString());
            }
            this.string = s.toString();
        }
        return this.string;
    }

    public String encodeToStringExpanded() throws IOException {
        if (this.frozen == null) {
            return this.encodeToString();
        }
        StringBuilder s = new StringBuilder();
        int[] ords = this.getOrdinals();
        s.append('{');
        for (int i = 0; i < ords.length; ++i) {
            int ord = ords[i];
            String tag = this.getTag(ord);
            if (i > 0) {
                s.append(',');
            }
            s.append(tag).append('=').append(ord);
        }
        s.append('}');
        return s.toString();
    }

    @Override
    public final BObject decodeFromString(String s) throws IOException {
        try {
            if (s.equals("{}")) {
                return DEFAULT;
            }
            BFacets options = null;
            int question = s.indexOf(63);
            if (question > 0) {
                options = BFacets.make(s.substring(question + 1));
                s = s.substring(0, question);
            }
            String[] split = BEnumRange.splitFrozenDynamic(s);
            String frozenStr = split[0];
            String dynamicStr = split[1];
            Type frozen = null;
            if (frozenStr != null) {
                try {
                    frozen = Sys.getType(frozenStr);
                }
                catch (ModuleNotFoundException e) {
                    return NULL;
                }
            }
            if (dynamicStr == null) {
                return BEnumRange.make(frozen, null, null, 0, options);
            }
            if (dynamicStr.charAt(0) != '{') {
                throw new IOException();
            }
            if (dynamicStr.charAt(dynamicStr.length() - 1) != '}') {
                throw new IOException();
            }
            dynamicStr = dynamicStr.substring(1, dynamicStr.length() - 1);
            int count = dynamicStr.length() / 4 + 1;
            int[] ordinals = new int[count];
            String[] tags = new String[count];
            count = BEnumRange.parseDynamic(dynamicStr, ordinals, tags);
            return BEnumRange.make(frozen, ordinals, tags, count, options);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException(s);
        }
    }

    static String[] splitFrozenDynamic(String s) {
        String frozen = null;
        String dynamic = null;
        int plus = s.indexOf(43);
        if (plus < 0) {
            if (s.startsWith("{")) {
                dynamic = s;
            } else {
                frozen = s;
            }
        } else if (s.startsWith("{")) {
            dynamic = s.substring(0, plus);
            frozen = s.substring(plus + 1);
        } else {
            frozen = s.substring(0, plus);
            dynamic = s.substring(plus + 1);
        }
        return new String[]{frozen, dynamic};
    }

    static int parseDynamic(String s, int[] ordinals, String[] tags) throws Exception {
        int count = 0;
        StringTokenizer st = new StringTokenizer(s, "=,");
        while (st.hasMoreTokens()) {
            tags[count] = st.nextToken();
            ordinals[count] = Integer.parseInt(st.nextToken());
            ++count;
        }
        return count;
    }

    @Override
    public BIDataValue toDataValue() {
        return this;
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    static {
        DEFAULT = NULL = new BEnumRange(null, noDynamic, noByOrdinal, noByTag, BFacets.DEFAULT);
        TYPE = Sys.loadType(BEnumRange.class);
        BOOLEAN_RANGE = BEnumRange.make(new String[]{"false", "true"});
    }
}

