/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.sys;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import javax.baja.data.BIDataValue;
import javax.baja.data.DataUtil;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.IntHashMap;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BDouble;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLong;
import javax.baja.sys.BNumber;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.user.BUser;

@NiagaraType
public final class BFacets
extends BSimple
implements Context {
    public static final String MIN = "min";
    public static final String MAX = "max";
    public static final String TRUE_TEXT = "trueText";
    public static final String FALSE_TEXT = "falseText";
    public static final String PRECISION = "precision";
    public static final String UNITS = "units";
    public static final String RADIX = "radix";
    public static final String RANGE = "range";
    public static final String SHOW_DATE = "showDate";
    public static final String SHOW_TIME = "showTime";
    public static final String SHOW_SECONDS = "showSeconds";
    public static final String SHOW_MILLISECONDS = "showMilliseconds";
    public static final String SHOW_TIME_ZONE = "showTimeZone";
    public static final String TIME_ZONE = "TimeZone";
    public static final String MULTI_LINE = "multiLine";
    public static final String FIELD_WIDTH = "fieldWidth";
    public static final String ALLOW_NULL = "allowNull";
    public static final String ORD_RELATIVIZE = "ordRelativize";
    public static final String FIELD_EDITOR = "fieldEditor";
    public static final String UX_FIELD_EDITOR = "uxFieldEditor";
    public static final String INPLACE_EDITOR = "inplaceEditor";
    public static final String CELL_EDITOR = "cellEditor";
    public static final String TARGET_TYPE = "targetType";
    public static final String UNIT_CONVERSION = "unitConversion";
    public static final String REALMS = "realms";
    public static final String SHOW_UNITS = "showUnits";
    public static final String SHOW_SEPARATORS = "showSeparators";
    public static final String FORCE_SIGN = "forceSign";
    public static final String ENCODER_FILE = "encoderFile";
    public static final String MAX_OVERRIDE_DURATION = "maxOverrideDuration";
    public static final String NAMESPACE = "namespace";
    public static final String SECURITY = "security";
    private static final String[] BOOLEAN_KEYS;
    private static final BString TRUE_STRING;
    private static final BString FALSE_STRING;
    private static final String[] NUMERIC_KEYS;
    private static final String[] INT_KEYS;
    private static final String[] ENUM_KEYS;
    public static final BFacets NULL;
    public static final BFacets DEFAULT;
    public static final Type TYPE;
    public static final Object SKIP_INTERN_PICKLE;
    private String[] keys;
    private BIDataValue[] values;
    private String encodeStr;
    private Object pickle;
    private static final boolean internDisabled;
    private static final String defaultExcludedFacetKeys = "sourceName;historyId;lastTimestamp;firstTimestamp;startTime;endTime;foxSessionId;historyCursorPreRec;historyCursorPostRec";
    private static final Array<String> noInternFacetKeys;
    private static Map<String, WeakReference<String>> keyMap;

    public static BFacets makeBoolean(BString trueText, BString falseText) {
        return BFacets.factory(BOOLEAN_KEYS, new BIDataValue[]{trueText, falseText});
    }

    public static BFacets makeBoolean(String trueText, String falseText) {
        return BFacets.makeBoolean(BString.make(trueText), BString.make(falseText));
    }

    public static BFacets makeBoolean() {
        return BFacets.makeBoolean(TRUE_STRING, FALSE_STRING);
    }

    public static BFacets makeNumeric(BUnit unit, BInteger precision, BNumber min, BNumber max) {
        if (unit == null) {
            unit = BUnit.NULL;
        }
        return BFacets.factory(NUMERIC_KEYS, new BIDataValue[]{unit, precision, min, max});
    }

    public static BFacets makeNumeric() {
        return BFacets.makeNumeric(null, BInteger.make(1), BDouble.NEGATIVE_INFINITY, BDouble.POSITIVE_INFINITY);
    }

    public static BFacets makeNumeric(int precision) {
        return BFacets.makeNumeric(null, BInteger.make(precision), BDouble.NEGATIVE_INFINITY, BDouble.POSITIVE_INFINITY);
    }

    public static BFacets makeNumeric(BUnit unit, int precision) {
        return BFacets.makeNumeric(unit, BInteger.make(precision), BDouble.NEGATIVE_INFINITY, BDouble.POSITIVE_INFINITY);
    }

    public static BFacets makeNumeric(BUnit unit, BNumber min, BNumber max) {
        return BFacets.makeNumeric(unit, BInteger.make(1), min, max);
    }

    public static BFacets makeNumeric(BUnit unit, int precision, double min, double max) {
        return BFacets.makeNumeric(unit, BInteger.make(precision), BDouble.make(min), BDouble.make(max));
    }

    public static BFacets makeInt(BUnit unit, int min, int max, int radix) {
        if (unit == null) {
            unit = BUnit.NULL;
        }
        return BFacets.factory(INT_KEYS, new BIDataValue[]{unit, BInteger.make(min), BInteger.make(max), BInteger.make(radix)});
    }

    public static BFacets makeInt(BUnit unit, int min, int max) {
        return BFacets.makeInt(unit, min, max, 10);
    }

    public static BFacets makeInt(BUnit units) {
        return BFacets.makeInt(units, Integer.MIN_VALUE, Integer.MAX_VALUE, 10);
    }

    public static BFacets makeInt(int min, int max) {
        return BFacets.makeInt(null, min, max, 10);
    }

    public static BFacets makeInt() {
        return BFacets.makeInt(null, Integer.MIN_VALUE, Integer.MAX_VALUE, 10);
    }

    public static BFacets makeEnum(BEnumRange range) {
        if (range == null) {
            range = BEnumRange.NULL;
        }
        if (range.asFacets == null) {
            range.asFacets = BFacets.factory(ENUM_KEYS, new BIDataValue[]{range});
        }
        return range.asFacets;
    }

    public static BFacets makeEnum() {
        return BFacets.makeEnum(null);
    }

    public static BFacets make(String key, boolean value) {
        return BFacets.make(key, BBoolean.make(value));
    }

    public static BFacets make(String key, int value) {
        return BFacets.make(key, BInteger.make(value));
    }

    public static BFacets make(String key, long value) {
        return BFacets.make(key, BLong.make(value));
    }

    public static BFacets make(String key, String value) {
        return BFacets.make(key, BString.make(value));
    }

    public static BFacets make(String key, BIDataValue value) {
        if (key.equals(RANGE) && value instanceof BEnumRange) {
            return BFacets.makeEnum((BEnumRange)value);
        }
        SlotPath.verifyValidName(key);
        BFacets.verifyValue(value);
        return BFacets.factory(new String[]{key}, new BIDataValue[]{value});
    }

    public static BFacets make(String key1, BIDataValue value1, String key2, BIDataValue value2) {
        SlotPath.verifyValidName(key1);
        BFacets.verifyValue(value1);
        SlotPath.verifyValidName(key2);
        BFacets.verifyValue(value2);
        return BFacets.factory(new String[]{key1, key2}, new BIDataValue[]{value1, value2});
    }

    public static BFacets make(String key1, BIDataValue value1, String key2, BIDataValue value2, String key3, BIDataValue value3) {
        SlotPath.verifyValidName(key1);
        BFacets.verifyValue(value1);
        SlotPath.verifyValidName(key2);
        BFacets.verifyValue(value2);
        SlotPath.verifyValidName(key3);
        BFacets.verifyValue(value3);
        return BFacets.factory(new String[]{key1, key2, key3}, new BIDataValue[]{value1, value2, value3});
    }

    public static BFacets make(String encoding) throws IOException {
        return (BFacets)DEFAULT.decodeFromString(encoding);
    }

    public static BFacets tryMake(String encoding) {
        try {
            return BFacets.make(encoding);
        }
        catch (IOException e) {
            return NULL;
        }
    }

    public static BFacets make(Map<String, ? extends BIDataValue> map) {
        if (map.isEmpty()) {
            return NULL;
        }
        String[] keys = new String[map.size()];
        BIDataValue[] values = new BIDataValue[map.size()];
        Iterator<String> it = map.keySet().iterator();
        int i = 0;
        while (it.hasNext()) {
            String name = it.next();
            SlotPath.verifyValidName(name);
            BIDataValue value = map.get(name);
            BFacets.verifyValue(value);
            keys[i] = name;
            values[i] = value;
            ++i;
        }
        return BFacets.factory(keys, values);
    }

    public static BFacets make(String[] keys, BIDataValue[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < values.length; ++i) {
            SlotPath.verifyValidName(keys[i]);
            BFacets.verifyValue(values[i]);
        }
        return BFacets.factory((String[])keys.clone(), (BIDataValue[])values.clone());
    }

    public static BFacets make(BFacets orig, String key, BIDataValue value) {
        SlotPath.verifyValidName(key);
        BFacets.verifyValue(value);
        int index = orig.indexOf(key);
        if (index >= 0) {
            if (orig.values[index].equals(value)) {
                return orig;
            }
            BIDataValue[] newValues = (BIDataValue[])orig.values.clone();
            newValues[index] = value;
            return BFacets.factory(orig.keys, newValues, orig.pickle == SKIP_INTERN_PICKLE);
        }
        int origLen = orig.keys.length;
        String[] newKeys = new String[origLen + 1];
        BIDataValue[] newValues = new BIDataValue[origLen + 1];
        System.arraycopy(orig.keys, 0, newKeys, 0, origLen);
        System.arraycopy(orig.values, 0, newValues, 0, origLen);
        newKeys[origLen] = key;
        newValues[origLen] = value;
        return BFacets.factory(newKeys, newValues, orig.pickle == SKIP_INTERN_PICKLE);
    }

    public static BFacets makeRemove(BFacets orig, String key) {
        int index = orig.indexOf(key);
        if (index < 0) {
            return orig;
        }
        if (orig.keys.length == 1) {
            return NULL;
        }
        int origLen = orig.keys.length;
        String[] newKeys = new String[origLen - 1];
        System.arraycopy(orig.keys, 0, newKeys, 0, index);
        System.arraycopy(orig.keys, index + 1, newKeys, index, origLen - index - 1);
        BIDataValue[] newValues = new BIDataValue[origLen - 1];
        System.arraycopy(orig.values, 0, newValues, 0, index);
        System.arraycopy(orig.values, index + 1, newValues, index, origLen - index - 1);
        return BFacets.factory(newKeys, newValues, orig.pickle == SKIP_INTERN_PICKLE);
    }

    public static BFacets makeRemove(BFacets orig, String[] keys) {
        if (orig.keys.length == 0) {
            return NULL;
        }
        IntHashMap toRemove = new IntHashMap();
        for (String key : keys) {
            int index = orig.indexOf(key);
            if (index < 0) continue;
            toRemove.put(index, (Object)key);
        }
        if (toRemove.isEmpty()) {
            return orig;
        }
        int origLen = orig.keys.length;
        String[] newKeys = new String[origLen - toRemove.size()];
        BIDataValue[] newValues = new BIDataValue[origLen - toRemove.size()];
        int newIdx = 0;
        for (int i = 0; i < origLen; ++i) {
            if (toRemove.get(i) != null) continue;
            newKeys[newIdx] = orig.keys[i];
            newValues[newIdx] = orig.values[i];
            ++newIdx;
        }
        return BFacets.factory(newKeys, newValues, orig.pickle == SKIP_INTERN_PICKLE);
    }

    public static BFacets make(BFacets orig, BFacets toAdd) {
        boolean skipIntern;
        if (orig == null || orig.isNull()) {
            return toAdd == null ? NULL : toAdd;
        }
        if (toAdd == null || toAdd.isNull()) {
            return orig == null ? NULL : orig;
        }
        int maxNewLen = orig.keys.length + toAdd.keys.length;
        String[] newKeys = new String[maxNewLen];
        BIDataValue[] newVals = new BIDataValue[maxNewLen];
        System.arraycopy(orig.keys, 0, newKeys, 0, orig.keys.length);
        System.arraycopy(orig.values, 0, newVals, 0, orig.values.length);
        int addIndex = orig.keys.length;
        for (int i = 0; i < toAdd.keys.length; ++i) {
            int origIndex = orig.indexOf(toAdd.keys[i]);
            if (origIndex == -1) {
                newKeys[addIndex] = toAdd.keys[i];
                newVals[addIndex++] = toAdd.values[i];
                continue;
            }
            newVals[origIndex] = toAdd.values[i];
        }
        boolean bl = skipIntern = orig.pickle == SKIP_INTERN_PICKLE || toAdd.pickle == SKIP_INTERN_PICKLE;
        if (addIndex != maxNewLen) {
            String[] keys = new String[addIndex];
            BIDataValue[] values = new BIDataValue[addIndex];
            System.arraycopy(newKeys, 0, keys, 0, addIndex);
            System.arraycopy(newVals, 0, values, 0, addIndex);
            return BFacets.factory(keys, values, skipIntern);
        }
        return BFacets.factory(newKeys, newVals, skipIntern);
    }

    public static BFacets make(BFacets facets) {
        if (facets == null) {
            return NULL;
        }
        return facets;
    }

    public static BFacets makePickle(BFacets facets, Object pickle) {
        BFacets result = new BFacets(facets.keys, facets.values, facets.encodeStr);
        result.pickle = pickle;
        return result;
    }

    private BFacets(String[] keys, BIDataValue[] values, String encodeStr) {
        if (keys != null) {
            for (int i = 0; i < keys.length; ++i) {
                keys[i] = BFacets.internedKey(keys[i]);
            }
        }
        this.keys = keys;
        this.values = values;
        this.encodeStr = encodeStr;
    }

    private static BFacets factory(String[] keys, BIDataValue[] values) {
        return (BFacets)new BFacets(keys, values, null).intern();
    }

    private static BFacets factory(String[] keys, BIDataValue[] values, boolean skipIntern) {
        BFacets facets = new BFacets(keys, values, null);
        if (skipIntern) {
            facets.pickle = SKIP_INTERN_PICKLE;
            return facets;
        }
        return (BFacets)facets.intern();
    }

    private static String encode(String[] keys, BIDataValue[] values) {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < keys.length; ++i) {
            String key = keys[i];
            BObject value = (BObject)((Object)values[i]);
            if (i > 0) {
                s.append('|');
            }
            try {
                s.append(key).append('=').append(DataUtil.marshal(value));
                continue;
            }
            catch (Exception e) {
                throw new BajaRuntimeException(e);
            }
        }
        return s.toString();
    }

    public int size() {
        return this.keys.length;
    }

    public boolean isEmpty() {
        return this.keys.length == 0;
    }

    public String[] list() {
        return (String[])this.keys.clone();
    }

    private int indexOf(String name) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!this.keys[i].equals(name)) continue;
            return i;
        }
        return -1;
    }

    public BObject get(String name) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!this.keys[i].equals(name)) continue;
            return (BObject)((Object)this.values[i]);
        }
        return null;
    }

    public BObject get(String name, BObject def) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!this.keys[i].equals(name)) continue;
            return (BObject)((Object)this.values[i]);
        }
        return def;
    }

    public boolean getb(String name, boolean def) {
        BObject val = this.get(name);
        if (val instanceof BBoolean) {
            return ((BBoolean)val).getBoolean();
        }
        return def;
    }

    public int geti(String name, int def) {
        BObject val = this.get(name);
        if (val instanceof BNumber) {
            return ((BNumber)val).getInt();
        }
        if (val instanceof BEnum) {
            return ((BEnum)val).getOrdinal();
        }
        return def;
    }

    public long getl(String name, long def) {
        BObject val = this.get(name);
        if (val instanceof BNumber) {
            return ((BNumber)val).getLong();
        }
        if (val instanceof BEnum) {
            return ((BEnum)val).getOrdinal();
        }
        return def;
    }

    public float getf(String name, float def) {
        BObject val = this.get(name);
        if (val instanceof BNumber) {
            return ((BNumber)val).getFloat();
        }
        return def;
    }

    public double getd(String name, double def) {
        BObject val = this.get(name);
        if (val instanceof BNumber) {
            return ((BNumber)val).getDouble();
        }
        return def;
    }

    public String gets(String name, String def) {
        BObject val = this.get(name);
        if (val == null) {
            return def;
        }
        return val.toString();
    }

    @Override
    public Context getBase() {
        return null;
    }

    @Override
    public BUser getUser() {
        return null;
    }

    @Override
    public BObject getFacet(String name) {
        return this.get(name);
    }

    @Override
    public String getLanguage() {
        return Sys.getLanguage();
    }

    @Override
    public BFacets getFacets() {
        return this;
    }

    @Override
    public boolean isNull() {
        return this.keys.length == 0;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof BFacets)) {
            return false;
        }
        BFacets a = this;
        BFacets b = (BFacets)obj;
        if (a.keys.length != b.keys.length) {
            return false;
        }
        for (int i = 0; i < a.keys.length; ++i) {
            String ak = a.keys[i];
            BObject av = a.get(ak);
            BObject bv = b.get(ak);
            if (null != bv && ((Object)av).equals(bv)) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toString(Context context) {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < this.keys.length; ++i) {
            if (i > 0) {
                s.append(',');
            }
            s.append(SlotPath.unescape(this.keys[i])).append('=').append(this.values[i].toString(context));
        }
        return s.toString();
    }

    @Override
    public int hashCode() {
        try {
            return this.encodeToString().hashCode();
        }
        catch (Exception e) {
            return System.identityHashCode(this);
        }
    }

    @Override
    public void encode(DataOutput out) throws IOException {
        out.writeUTF(this.encodeToString());
    }

    @Override
    public BObject decode(DataInput in) throws IOException {
        return this.decodeFromString(in.readUTF());
    }

    @Override
    public BIDataValue toDataValue() {
        try {
            return BString.make(this.encodeToString());
        }
        catch (Exception e) {
            e.printStackTrace();
            return BString.make(this.toString());
        }
    }

    @Override
    public String encodeToString() throws IOException {
        if (this.encodeStr == null) {
            this.encodeStr = BFacets.encode(this.keys, this.values);
        }
        return this.encodeStr;
    }

    @Override
    public BObject decodeFromString(String s) throws IOException {
        if (s == null || s.isEmpty()) {
            return NULL;
        }
        try {
            ArrayList<String> keys = new ArrayList<String>();
            ArrayList<BIDataValue> values = new ArrayList<BIDataValue>();
            StringTokenizer st = new StringTokenizer(s, "|");
            while (st.hasMoreTokens()) {
                String tok = st.nextToken();
                int eq = tok.indexOf(61);
                String name = tok.substring(0, eq);
                SlotPath.verifyValidName(name);
                BIDataValue value = (BIDataValue)((Object)DataUtil.unmarshal(tok.substring(eq + 1)));
                keys.add(name);
                values.add(value);
            }
            if (keys.isEmpty()) {
                return NULL;
            }
            return BFacets.factory(keys.toArray(new String[0]), values.toArray(new BIDataValue[0]));
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException(e.toString());
        }
    }

    private static void verifyValue(BIDataValue value) {
        if (value == null) {
            throw new NullPointerException();
        }
    }

    public final Object getPickle() {
        return this.pickle;
    }

    @Deprecated
    public final void setPickle(Object pickle) {
        this.pickle = pickle;
    }

    @Override
    public Object fw(int x, Object a, Object b, Object c, Object d) {
        if (x == 116) {
            if (this.pickle == SKIP_INTERN_PICKLE) {
                return Boolean.TRUE;
            }
            for (int i = 0; i < noInternFacetKeys.size(); ++i) {
                if (this.get((String)noInternFacetKeys.get(i)) == null) continue;
                return Boolean.TRUE;
            }
            return null;
        }
        return super.fw(x, a, b, c, d);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    private static String internedKey(String key) {
        WeakReference<String> iKey = keyMap.get(key);
        if (iKey == null) {
            iKey = new WeakReference<String>(key);
            keyMap.put(key, iKey);
        }
        return (String)iKey.get();
    }

    static {
        String types;
        BOOLEAN_KEYS = new String[]{TRUE_TEXT, FALSE_TEXT};
        TRUE_STRING = BString.make("true");
        FALSE_STRING = BString.make("false");
        NUMERIC_KEYS = new String[]{UNITS, PRECISION, MIN, MAX};
        INT_KEYS = new String[]{UNITS, MIN, MAX, RADIX};
        ENUM_KEYS = new String[]{RANGE};
        DEFAULT = NULL = BFacets.factory(new String[0], new BIDataValue[0]);
        TYPE = Sys.loadType(BFacets.class);
        SKIP_INTERN_PICKLE = new Object();
        internDisabled = AccessController.doPrivileged(() -> Boolean.getBoolean("niagara.intern.disabled"));
        noInternFacetKeys = new Array(String.class);
        if (!internDisabled && (types = AccessController.doPrivileged(() -> System.getProperty("niagara.intern.excludedFacetKeys", defaultExcludedFacetKeys))) != null) {
            StringTokenizer tokenizer = new StringTokenizer(types, ";");
            while (tokenizer.hasMoreTokens()) {
                try {
                    noInternFacetKeys.add((Object)tokenizer.nextToken());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        keyMap = Collections.synchronizedMap(new WeakHashMap());
    }
}

