/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.sys;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BDouble;
import javax.baja.sys.BNumber;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public final class BFloat
extends BNumber {
    public static final BFloat POSITIVE_INFINITY = new BFloat(Float.POSITIVE_INFINITY);
    public static final BFloat NEGATIVE_INFINITY = new BFloat(Float.NEGATIVE_INFINITY);
    public static final BFloat NaN = new BFloat(Float.NaN);
    public static final BFloat DEFAULT = new BFloat(0.0f);
    public static final Type TYPE = Sys.loadType(BFloat.class);
    private float value;

    public static BFloat make(float value) {
        if (value == 0.0f) {
            return DEFAULT;
        }
        if (value == Float.NEGATIVE_INFINITY) {
            return NEGATIVE_INFINITY;
        }
        if (value == Float.POSITIVE_INFINITY) {
            return POSITIVE_INFINITY;
        }
        if (Float.isNaN(value)) {
            return NaN;
        }
        return new BFloat(value);
    }

    public static BFloat make(String value) {
        return BFloat.make(BFloat.decode(value));
    }

    private BFloat(float value) {
        this.value = value;
    }

    @Override
    public int getInt() {
        return (int)this.value;
    }

    @Override
    public long getLong() {
        return (long)this.value;
    }

    @Override
    public float getFloat() {
        return this.value;
    }

    @Override
    public double getDouble() {
        return this.value;
    }

    @Override
    public int hashCode() {
        return Float.floatToIntBits(this.value);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof BFloat) {
            float x = ((BFloat)obj).value;
            if (x == this.value) {
                return true;
            }
            if (Float.isNaN(x) && Float.isNaN(this.value)) {
                return true;
            }
        }
        return false;
    }

    public static boolean equals(float a, float b) {
        if (a == b) {
            return true;
        }
        return Float.isNaN(a) && Float.isNaN(b);
    }

    @Override
    public int compareTo(Object obj) {
        float a = this.value;
        float b = ((BNumber)obj).getFloat();
        if (a == b) {
            return 0;
        }
        if (Float.isNaN(a) && Float.isNaN(b)) {
            return 0;
        }
        if (a < b) {
            return -1;
        }
        return 1;
    }

    @Override
    public String toString(Context context) {
        return BFloat.toString(this.value, context);
    }

    @Override
    public void encode(DataOutput out) throws IOException {
        out.writeFloat(this.value);
    }

    @Override
    public BObject decode(DataInput in) throws IOException {
        return BFloat.make(in.readFloat());
    }

    @Override
    public String encodeToString() throws IOException {
        return BFloat.encode(this.value);
    }

    @Override
    public BObject decodeFromString(String s) throws IOException {
        try {
            return BFloat.make(s);
        }
        catch (RuntimeException e) {
            throw new IOException("Invalid float: " + s);
        }
    }

    public static String encode(float f) {
        if (f == Float.POSITIVE_INFINITY) {
            return "+inf";
        }
        if (f == Float.NEGATIVE_INFINITY) {
            return "-inf";
        }
        if (Float.isNaN(f)) {
            return "nan";
        }
        return String.valueOf(f);
    }

    public static float decode(String s) {
        if (s.equals("+inf")) {
            return Float.POSITIVE_INFINITY;
        }
        if (s.equals("-inf")) {
            return Float.NEGATIVE_INFINITY;
        }
        if (s.equals("nan")) {
            return Float.NaN;
        }
        return Float.parseFloat(s);
    }

    public static String toString(float value, Context context) {
        return BDouble.toString(value, context);
    }

    @Override
    public Type getType() {
        return TYPE;
    }
}

