/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.sys;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public final class BIcon
extends BSimple {
    public static final BIcon DEFAULT = new BIcon(BOrdList.NULL);
    public static final Type TYPE = Sys.loadType(BIcon.class);
    private static HashMap<String, BIcon> cache = new HashMap();
    private BOrdList ordList;
    Object image;

    public static BIcon make(String ordList) {
        return BIcon.make(BOrdList.make(ordList));
    }

    public static BIcon make(BOrd ord) {
        return BIcon.make(BOrdList.make(ord));
    }

    public static BIcon make(BOrdList ordList) {
        BIcon icon = cache.get(ordList.encodeToString());
        if (icon == null) {
            icon = new BIcon(ordList);
            cache.put(ordList.encodeToString(), icon);
        }
        return icon;
    }

    public static BIcon std(String fileName) {
        return BIcon.make("module://icons/x16/" + fileName);
    }

    public static BIcon make(BIcon bottom, BIcon top) {
        int i;
        BOrdList blist = bottom.ordList;
        BOrdList tlist = top.ordList;
        int bsize = blist.size();
        int tsize = tlist.size();
        BOrd[] ords = new BOrd[bsize + tsize];
        for (i = 0; i < bsize; ++i) {
            ords[i] = blist.get(i);
        }
        for (i = 0; i < tsize; ++i) {
            ords[i + bsize] = tlist.get(i);
        }
        return BIcon.make(BOrdList.make(ords));
    }

    private BIcon(BOrdList ordList) {
        this.ordList = ordList;
    }

    public BOrdList getOrdList() {
        return this.ordList;
    }

    @Override
    public String toString(Context cx) {
        return this.ordList.toString(cx);
    }

    @Override
    public int hashCode() {
        return this.ordList.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof BIcon) {
            return this.ordList.equals(((BIcon)obj).ordList);
        }
        return false;
    }

    @Override
    public void encode(DataOutput out) throws IOException {
        out.writeUTF(this.ordList.encodeToString());
    }

    @Override
    public BObject decode(DataInput in) throws IOException {
        return BIcon.make(in.readUTF());
    }

    @Override
    public String encodeToString() throws IOException {
        return this.ordList.encodeToString();
    }

    @Override
    public BObject decodeFromString(String s) throws IOException {
        return BIcon.make(s);
    }

    @Override
    public Object fw(int x, Object a, Object b, Object c, Object d) {
        switch (x) {
            case 203: {
                return this.image;
            }
            case 204: {
                this.image = a;
                return null;
            }
        }
        return super.fw(x, a, b, c, d);
    }

    @Override
    public Type getType() {
        return TYPE;
    }
}

