/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.sys;

import com.tridium.sys.Nre;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BDouble;
import javax.baja.sys.BNumber;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.units.BUnitConversion;

@NiagaraType
public final class BInteger
extends BNumber {
    private static final BInteger ZERO = new BInteger(0);
    private static final BInteger ONE = new BInteger(1);
    private static final BInteger TWO = new BInteger(2);
    private static final BInteger THREE = new BInteger(3);
    private static final BInteger FOUR = new BInteger(4);
    private static final BInteger FIVE = new BInteger(5);
    public static final BInteger MIN = new BInteger(Integer.MIN_VALUE);
    public static final BInteger MAX = new BInteger(Integer.MAX_VALUE);
    public static final BInteger DEFAULT = ZERO;
    public static final Type TYPE = Sys.loadType(BInteger.class);
    private int value;

    public static BInteger make(int value) {
        switch (value) {
            case 0: {
                return ZERO;
            }
            case 1: {
                return ONE;
            }
            case 2: {
                return TWO;
            }
            case 3: {
                return THREE;
            }
            case 4: {
                return FOUR;
            }
            case 5: {
                return FIVE;
            }
            case -2147483648: {
                return MIN;
            }
            case 0x7FFFFFFF: {
                return MAX;
            }
        }
        return new BInteger(value);
    }

    public static BInteger make(String value) {
        return BInteger.make(BInteger.decode(value));
    }

    private BInteger(int value) {
        this.value = value;
    }

    @Override
    public int getInt() {
        return this.value;
    }

    @Override
    public long getLong() {
        return this.value;
    }

    @Override
    public float getFloat() {
        return this.value;
    }

    @Override
    public double getDouble() {
        return this.value;
    }

    @Override
    public int hashCode() {
        return this.value;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof BInteger) {
            return ((BInteger)obj).value == this.value;
        }
        return false;
    }

    @Override
    public int compareTo(Object obj) {
        int a = this.value;
        int b = ((BNumber)obj).getInt();
        if (a == b) {
            return 0;
        }
        if (a < b) {
            return -1;
        }
        return 1;
    }

    @Override
    public String toString(Context context) {
        return BInteger.toString(this.value, context);
    }

    @Override
    public void encode(DataOutput out) throws IOException {
        out.writeInt(this.value);
    }

    @Override
    public BObject decode(DataInput in) throws IOException {
        return BInteger.make(in.readInt());
    }

    @Override
    public String encodeToString() throws IOException {
        return BInteger.encode(this.value);
    }

    @Override
    public BObject decodeFromString(String s) throws IOException {
        try {
            return BInteger.make(s);
        }
        catch (RuntimeException e) {
            throw new IOException("Invalid integer: " + s);
        }
    }

    public static int decode(String s) {
        if (s.equals("min")) {
            return Integer.MIN_VALUE;
        }
        if (s.equals("max")) {
            return Integer.MAX_VALUE;
        }
        return Integer.parseInt(s);
    }

    public static String encode(int i) {
        if (i == Integer.MIN_VALUE) {
            return "min";
        }
        if (i == Integer.MAX_VALUE) {
            return "max";
        }
        return String.valueOf(i);
    }

    public static String toString(int value, Context cx) {
        BUnitConversion c;
        BUnit desired;
        int radix = 10;
        BUnit units = null;
        int convert = Nre.unitConversion;
        boolean showUnits = true;
        boolean showSeparators = false;
        boolean forceSign = false;
        if (cx != null) {
            BNumber radixFacet = (BNumber)cx.getFacet("radix");
            if (radixFacet != null) {
                radix = radixFacet.getInt();
            }
            if ((units = (BUnit)cx.getFacet("units")) != null && units.isNull()) {
                units = null;
            }
            convert = cx.getFacets().geti("unitConversion", convert);
            showUnits = cx.getFacets().getb("showUnits", showUnits);
            showSeparators = cx.getFacets().getb("showSeparators", showSeparators);
            forceSign = cx.getFacets().getb("forceSign", forceSign);
        }
        if (convert != 0 && units != null && (desired = (c = BUnitConversion.make(convert)).getDesiredUnit(units)) != units) {
            value = (int)units.convertTo(desired, value);
            units = desired;
        }
        String s = "";
        if (showUnits && units != null && units.getIsPrefix()) {
            s = s + units.getSymbol() + ' ';
        }
        if (value == Integer.MIN_VALUE) {
            s = s + "min";
        } else if (value == Integer.MAX_VALUE) {
            s = s + "max";
        } else if (radix == 2) {
            s = s + Integer.toBinaryString(value);
        } else if (radix == 8) {
            s = s + Integer.toOctalString(value);
        } else if (radix == 16) {
            s = s + Integer.toHexString(value);
        } else if (radix != 10) {
            s = s + Integer.toString(value, radix);
        } else if (showSeparators) {
            s = s + BDouble.addForcedSign(forceSign, value);
            s = s + BDouble.getFormatter(0, true, false, cx).format(value);
        } else {
            s = s + BDouble.addForcedSign(forceSign, value);
            s = s + Integer.toString(value);
        }
        if (showUnits && units != null && !units.getIsPrefix()) {
            s = s + ' ' + units.getSymbol();
        }
        return s;
    }

    @Override
    public Type getType() {
        return TYPE;
    }
}

