/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.sys;

import com.tridium.sys.Nre;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BDouble;
import javax.baja.sys.BNumber;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.units.BUnitConversion;

@NiagaraType
public final class BLong
extends BNumber {
    private static final BLong ZERO = new BLong(0L);
    public static final BLong MIN = new BLong(Long.MIN_VALUE);
    public static final BLong MAX = new BLong(Long.MAX_VALUE);
    public static final BLong DEFAULT = ZERO;
    public static final Type TYPE = Sys.loadType(BLong.class);
    private long value;

    public static BLong make(long value) {
        if (value == 0L) {
            return ZERO;
        }
        if (value == Long.MIN_VALUE) {
            return MIN;
        }
        if (value == Long.MAX_VALUE) {
            return MAX;
        }
        return new BLong(value);
    }

    public static BLong make(String value) {
        return BLong.make(BLong.decode(value));
    }

    private BLong(long value) {
        this.value = value;
    }

    @Override
    public long getLong() {
        return this.value;
    }

    @Override
    public int getInt() {
        return (int)this.value;
    }

    @Override
    public float getFloat() {
        return this.value;
    }

    @Override
    public double getDouble() {
        return this.value;
    }

    @Override
    public int hashCode() {
        return (int)(this.value ^ this.value >>> 32);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof BLong) {
            return ((BLong)obj).value == this.value;
        }
        return false;
    }

    @Override
    public int compareTo(Object obj) {
        long a = this.value;
        long b = ((BNumber)obj).getLong();
        if (a == b) {
            return 0;
        }
        if (a < b) {
            return -1;
        }
        return 1;
    }

    @Override
    public String toString(Context context) {
        return BLong.toString(this.value, context);
    }

    @Override
    public void encode(DataOutput out) throws IOException {
        out.writeLong(this.value);
    }

    @Override
    public BObject decode(DataInput in) throws IOException {
        return BLong.make(in.readLong());
    }

    @Override
    public String encodeToString() throws IOException {
        return BLong.encode(this.value);
    }

    @Override
    public BObject decodeFromString(String s) throws IOException {
        try {
            return BLong.make(s);
        }
        catch (RuntimeException e) {
            throw new IOException("Invalid long: " + s);
        }
    }

    public static long decode(String s) {
        if (s.equals("min")) {
            return Long.MIN_VALUE;
        }
        if (s.equals("max")) {
            return Long.MAX_VALUE;
        }
        return Long.parseLong(s);
    }

    public static String encode(long x) {
        if (x == Long.MIN_VALUE) {
            return "min";
        }
        if (x == Long.MAX_VALUE) {
            return "max";
        }
        return String.valueOf(x);
    }

    public static String toString(long value, Context cx) {
        BUnitConversion c;
        BUnit desired;
        int radix = 10;
        BUnit units = null;
        int convert = Nre.unitConversion;
        boolean showUnits = true;
        boolean showSeparators = false;
        boolean forceSign = false;
        if (cx != null) {
            BNumber radixFacet = (BNumber)cx.getFacet("radix");
            if (radixFacet != null) {
                radix = radixFacet.getInt();
            }
            if ((units = (BUnit)cx.getFacet("units")) != null && units.isNull()) {
                units = null;
            }
            convert = cx.getFacets().geti("unitConversion", convert);
            showUnits = cx.getFacets().getb("showUnits", showUnits);
            showSeparators = cx.getFacets().getb("showSeparators", showSeparators);
            forceSign = cx.getFacets().getb("forceSign", forceSign);
        }
        if (convert != 0 && units != null && (desired = (c = BUnitConversion.make(convert)).getDesiredUnit(units)) != units) {
            value = (long)units.convertTo(desired, value);
            units = desired;
        }
        String s = "";
        if (showUnits && units != null && units.getIsPrefix()) {
            s = s + units.getSymbol() + ' ';
        }
        if (value == Long.MIN_VALUE) {
            s = s + "min";
        } else if (value == Long.MAX_VALUE) {
            s = s + "max";
        } else if (radix == 2) {
            s = s + Long.toBinaryString(value);
        } else if (radix == 8) {
            s = s + Long.toOctalString(value);
        } else if (radix == 16) {
            s = s + Long.toHexString(value);
        } else if (radix != 10) {
            s = s + Long.toString(value, radix);
        } else if (showSeparators) {
            s = s + BDouble.addForcedSign(forceSign, value);
            s = s + BDouble.getFormatter(0, true, false, cx).format(value);
        } else {
            s = s + BDouble.addForcedSign(forceSign, value);
            s = s + Long.toString(value);
        }
        if (showUnits && units != null && !units.getIsPrefix()) {
            s = s + ' ' + units.getSymbol();
        }
        return s;
    }

    @Override
    public Type getType() {
        return TYPE;
    }
}

