/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.sys;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import javax.baja.category.BCategoryMask;
import javax.baja.file.BFileSpace;
import javax.baja.file.BIDirectory;
import javax.baja.file.BIFile;
import javax.baja.file.BIFileStore;
import javax.baja.file.FilePath;
import javax.baja.file.zip.BZipSpace;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.UnresolvedException;
import javax.baja.nav.BINavNode;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.FileUtil;
import javax.baja.security.BPermissions;
import javax.baja.space.BSpace;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BIcon;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BModuleDirectory
extends BObject
implements BIFileStore,
BIFile,
BIDirectory {
    @Generated
    public static final Type TYPE = Sys.loadType(BModuleDirectory.class);
    private final BModule module;
    private final FilePath filePath;
    private final BIDirectory parent;
    private final Map<String, BModuleDirectory> childDirByName = new TreeMap<String, BModuleDirectory>();
    private final Map<String, BZipSpace> zipSpaceByChildFileName = new TreeMap<String, BZipSpace>();
    private static final BIcon ICON = BIcon.std("folder.png");

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BModuleDirectory(BModule module, FilePath filePath, BIDirectory parent) {
        this.module = module;
        this.filePath = filePath;
        this.parent = parent;
    }

    public String getModuleName() {
        return this.module.getModuleName();
    }

    public void addFile(FilePath pathToAdd, BZipSpace zipSpace) {
        int depth;
        if (pathToAdd.depth() < this.filePath.depth() + 1) {
            throw new IllegalArgumentException(String.format("Depth of path to is too short %s(%d) < %s(%d)", pathToAdd.toString(), pathToAdd.depth(), this.filePath.toString(), this.filePath.depth() + 1));
        }
        for (depth = 0; depth < this.filePath.depth(); ++depth) {
            if (pathToAdd.nameAt(depth).equals(this.filePath.nameAt(depth))) continue;
            throw new IllegalArgumentException();
        }
        BModuleDirectory addTo = this;
        while (depth < pathToAdd.depth() - 1) {
            addTo = addTo.makeDirectoryChild(pathToAdd.nameAt(depth));
            ++depth;
        }
        if (!addTo.zipSpaceByChildFileName.containsKey(pathToAdd.getName())) {
            addTo.zipSpaceByChildFileName.put(pathToAdd.getName(), zipSpace);
        }
    }

    public BModuleDirectory findDirectory(FilePath path) {
        int depth;
        if (path.depth() < this.filePath.depth()) {
            return null;
        }
        for (depth = 0; depth < this.filePath.depth(); ++depth) {
            if (path.nameAt(depth).equals(this.filePath.nameAt(depth))) continue;
            return null;
        }
        BModuleDirectory dir = this;
        while (depth < path.depth()) {
            dir = dir.childDirByName.get(path.nameAt(depth));
            if (dir == null) {
                return null;
            }
            ++depth;
        }
        return dir;
    }

    public BZipSpace findZipSpace(FilePath path) {
        if (path.depth() < this.filePath.depth() + 1) {
            return null;
        }
        BModuleDirectory parentDir = this.findDirectory(path.getParent());
        if (parentDir == null) {
            return null;
        }
        if (parentDir.zipSpaceByChildFileName.containsKey(path.getName())) {
            return parentDir.zipSpaceByChildFileName.get(path.getName());
        }
        return null;
    }

    public BIFileStore getChildStore(String fileName) {
        if (this.childDirByName.containsKey(fileName)) {
            return this.childDirByName.get(fileName);
        }
        if (this.zipSpaceByChildFileName.containsKey(fileName)) {
            return this.zipSpaceByChildFileName.get(fileName).findStore(this.filePath.merge(fileName));
        }
        return null;
    }

    private BModuleDirectory makeDirectoryChild(String childName) {
        if (this.childDirByName.containsKey(childName)) {
            return this.childDirByName.get(childName);
        }
        BModuleDirectory result = new BModuleDirectory(this.module, this.filePath.merge(childName), this);
        this.childDirByName.put(childName, result);
        return result;
    }

    @Override
    public String toString(Context cx) {
        return String.format("%s %s", super.toString(cx), this.filePath.toString());
    }

    @Override
    public BIFile[] listFiles() {
        ArrayList<BModuleDirectory> results = new ArrayList<BModuleDirectory>();
        results.addAll(this.childDirByName.values());
        this.zipSpaceByChildFileName.entrySet().stream().map(entry -> ((BZipSpace)entry.getValue()).findFile(this.filePath.merge((String)entry.getKey()))).forEach(results::add);
        return results.toArray(new BIFile[0]);
    }

    @Override
    public BPermissions getPermissions(Context cx) {
        return this.module.getPermissions(cx);
    }

    @Override
    public boolean canRead(OrdTarget cx) {
        return this.module.canRead(cx);
    }

    @Override
    public boolean canWrite(OrdTarget cx) {
        return false;
    }

    @Override
    public boolean canInvoke(OrdTarget cx) {
        return false;
    }

    @Override
    public String getNavName() {
        return this.filePath.getName();
    }

    @Override
    public String getNavDisplayName(Context cx) {
        return this.filePath.getName();
    }

    @Override
    public String getNavDescription(Context cx) {
        return this.filePath.getName();
    }

    @Override
    public BINavNode getNavParent() {
        return this.parent;
    }

    @Override
    public boolean hasNavChildren() {
        return true;
    }

    @Override
    public BINavNode getNavChild(String navName) {
        if (this.childDirByName.containsKey(navName)) {
            return this.childDirByName.get(navName);
        }
        if (this.zipSpaceByChildFileName.containsKey(navName)) {
            return this.zipSpaceByChildFileName.get(navName).findFile(this.filePath.merge(navName));
        }
        return null;
    }

    @Override
    public BINavNode resolveNavChild(String navName) {
        BINavNode result = this.getNavChild(navName);
        if (result == null) {
            throw new UnresolvedException();
        }
        return result;
    }

    @Override
    public BINavNode[] getNavChildren() {
        return this.listFiles();
    }

    @Override
    public BOrd getNavOrd() {
        return this.getAbsoluteOrd().normalize();
    }

    @Override
    public BIcon getNavIcon() {
        return ICON;
    }

    @Override
    public BCategoryMask getAppliedCategoryMask() {
        return this.module.getAppliedCategoryMask();
    }

    @Override
    public BCategoryMask getCategoryMask() {
        return this.module.getCategoryMask();
    }

    @Override
    public BSpace getSpace() {
        return this.module;
    }

    @Override
    public boolean isMounted() {
        return true;
    }

    @Override
    public BOrd getOrdInSession() {
        return BOrd.make(this.module.getOrdInSession(), this.getOrdInSpace());
    }

    @Override
    public BOrd getOrdInSpace() {
        return BOrd.make(this.filePath);
    }

    @Override
    public boolean isPendingMove() {
        return false;
    }

    @Override
    public void setPendingMove(boolean pendingMove) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BIFileStore getStore() {
        return this;
    }

    @Override
    public void setStore(BIFileStore store) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getMimeType() {
        return null;
    }

    @Override
    public long getSize() {
        return -1L;
    }

    @Override
    public BFileSpace getFileSpace() {
        return this.module;
    }

    @Override
    public FilePath getFilePath() {
        return this.filePath;
    }

    @Override
    public String getFileName() {
        return this.filePath.getName();
    }

    @Override
    public String getExtension() {
        return FileUtil.getExtension((String)this.getFileName());
    }

    @Override
    public boolean isDirectory() {
        return true;
    }

    @Override
    public BAbsTime getLastModified() {
        return BAbsTime.NULL;
    }

    @Override
    public boolean setLastModified(BAbsTime absTime) throws IOException {
        return false;
    }

    @Override
    public boolean isReadonly() {
        return true;
    }

    @Override
    public BPermissions getPermissions(BIFile file, Context cx) {
        return this.module.getPermissions(cx);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        throw new IOException("Can't get input stream from directory");
    }

    @Override
    public byte[] read() throws IOException {
        throw new IOException("Can't get file contents for directory");
    }

    @Override
    public void delete() throws IOException {
        throw new IOException("Directory not writable");
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        throw new IOException("Directory not writable");
    }

    @Override
    public void write(byte[] content) throws IOException {
        throw new IOException("Directory not writable");
    }

    @Override
    public long getCrc() throws IOException {
        throw new IOException("Directory has no CRC");
    }
}

