/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.sys;

import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.user.BUser;

public class BasicContext
implements Context {
    protected Context base;
    protected BUser user;
    protected BFacets facets;
    protected String lang;

    public BasicContext(BUser user, BFacets facets) {
        this.user = user;
        this.facets = user == null ? (facets == null ? BFacets.NULL : facets) : (facets == null ? user.getFacets() : BFacets.make(user.getFacets(), facets));
        this.invariant();
    }

    public BasicContext(BUser user) {
        this.user = user;
        this.facets = user != null ? user.getFacets() : BFacets.NULL;
        this.invariant();
    }

    public BasicContext(BUser user, String lang) {
        this.user = user;
        this.facets = user != null ? user.getFacets() : BFacets.NULL;
        this.lang = lang;
        this.invariant();
    }

    public BasicContext(Context base) {
        if (base != null) {
            this.base = base;
            this.user = base.getUser();
            this.facets = base.getFacets();
            this.lang = base.getLanguage();
        }
        this.invariant();
    }

    public BasicContext(Context base, BFacets additionalFacets) {
        if (base != null) {
            this.base = base;
            this.user = base.getUser();
            this.facets = base.getFacets();
            this.lang = base.getLanguage();
        }
        this.facets = BFacets.make(this.facets, additionalFacets);
        this.invariant();
    }

    public BasicContext() {
        this.invariant();
    }

    private void invariant() {
        if (this.facets == null) {
            this.facets = BFacets.NULL;
        }
        if (this.lang == null) {
            this.lang = this.user != null && !this.user.getLanguage().equals("") ? this.user.getLanguage() : Sys.getLanguage();
        }
    }

    @Override
    public BUser getUser() {
        return this.user;
    }

    @Override
    public BFacets getFacets() {
        return this.facets;
    }

    @Override
    public BObject getFacet(String name) {
        return this.facets.getFacet(name);
    }

    @Override
    public String getLanguage() {
        return this.lang;
    }

    @Override
    public Context getBase() {
        return this.base;
    }

    public String toString() {
        return "BasicContext[facets=" + this.facets + " lang=" + this.lang + " user=" + this.user + "]";
    }
}

