/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.tag;

import java.util.Objects;
import javax.baja.naming.BOrd;
import javax.baja.tag.Entity;
import javax.baja.tag.Id;
import javax.baja.tag.Relation;
import javax.baja.tag.Taggable;
import javax.baja.tag.Tags;
import javax.baja.tag.util.TagSet;

public final class BasicRelation
implements Relation,
Taggable {
    private final Id id;
    private final Entity endpoint;
    private final BOrd endpointOrd;
    private final Tags tags;
    private final boolean inbound;

    public BasicRelation(Id id, Entity endpoint) {
        this(id, endpoint, (Tags)new TagSet(), true);
    }

    public BasicRelation(Id id, Entity endpoint, boolean isInbound) {
        this(id, endpoint, (Tags)new TagSet(), isInbound);
    }

    public BasicRelation(Id id, Entity endpoint, Tags tags, boolean isInbound) {
        Objects.requireNonNull(id, "id");
        Objects.requireNonNull(tags, "tags");
        this.id = id;
        this.endpoint = endpoint;
        this.endpointOrd = BOrd.NULL;
        this.tags = tags;
        this.inbound = isInbound;
    }

    public BasicRelation(Id id, BOrd endpointOrd) {
        this(id, endpointOrd, new TagSet());
    }

    public BasicRelation(Id id, BOrd endpointOrd, Tags tags) {
        this(id, endpointOrd, tags, true);
    }

    public BasicRelation(Id id, BOrd endpointOrd, Tags tags, boolean isInbound) {
        Objects.requireNonNull(id, "id");
        Objects.requireNonNull(tags, "tags");
        this.id = id;
        this.endpointOrd = endpointOrd;
        this.endpoint = null;
        this.tags = tags;
        this.inbound = isInbound;
    }

    @Override
    public Id getId() {
        return this.id;
    }

    @Override
    public boolean isInbound() {
        return this.inbound;
    }

    @Override
    public boolean isOutbound() {
        return !this.inbound;
    }

    @Override
    public Entity getEndpoint() {
        return this.endpoint;
    }

    @Override
    public BOrd getEndpointOrd() {
        return this.endpointOrd;
    }

    @Override
    public Tags tags() {
        return this.tags;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BasicRelation relation = (BasicRelation)o;
        if (!this.id.equals(relation.id)) {
            return false;
        }
        if (this.endpoint == null) {
            return this.endpointOrd.equals(relation.endpointOrd);
        }
        try {
            return this.endpoint.equals(relation.endpoint);
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public int hashCode() {
        int result = this.id.hashCode();
        if (this.endpoint != null) {
            result = 31 * result + this.endpoint.hashCode();
        } else if (this.endpointOrd != null) {
            result = 31 * result + this.endpointOrd.hashCode();
        }
        return result;
    }

    public String toString() {
        return "BasicRelation; id: " + this.id + "; inbound? " + this.inbound + "; endpoint: " + (this.endpoint != null ? this.endpoint : this.endpointOrd).toString();
    }
}

