/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.tag;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import javax.baja.sys.BComponent;
import javax.baja.tag.BIDataPolicy;
import javax.baja.tag.Entity;
import javax.baja.tag.Id;
import javax.baja.tag.Relation;
import javax.baja.tag.TagDictionaryService;
import javax.baja.tag.TagGroupInfo;

public interface DataPolicy {
    public static Collection<DataPolicy> getDataPolicy(Entity entity) {
        ArrayList<DataPolicy> dataPolicies = new ArrayList<DataPolicy>();
        Collection<Relation> tagGroupRelations = entity.relations().getAll(Id.newId("n:tagGroup"));
        for (Relation relation : tagGroupRelations) {
            Entity endpoint = relation.getEndpoint();
            if (!(endpoint instanceof BIDataPolicy)) continue;
            ((BIDataPolicy)((Object)endpoint)).getDataPolicy().ifPresent(dataPolicies::add);
        }
        return dataPolicies;
    }

    public static Optional<DataPolicy> getDataPolicy(Entity entity, Id tagGroupId) {
        Collection<Relation> collection = entity.relations().getAll(Id.newId("n:tagGroup"));
        for (Relation relation : collection) {
            Entity endpoint = relation.getEndpoint();
            if (!(endpoint instanceof TagGroupInfo) || !((TagGroupInfo)((Object)endpoint)).getGroupId().equals(tagGroupId)) continue;
            return ((BIDataPolicy)((Object)endpoint)).getDataPolicy();
        }
        return Optional.empty();
    }

    public static Optional<DataPolicy> getDataPolicyForTag(Id tagId, BComponent base) {
        TagDictionaryService tagDictionaryService = base.getTagDictionaryService();
        if (tagDictionaryService != null) {
            return tagDictionaryService.getDataPolicyForTag(tagId);
        }
        return Optional.empty();
    }
}

