/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.tag;

import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;
import javax.baja.sys.Type;
import javax.baja.tag.DataPolicy;
import javax.baja.tag.Entity;
import javax.baja.tag.Id;
import javax.baja.tag.Relation;
import javax.baja.tag.Tag;
import javax.baja.tag.TagDictionary;
import javax.baja.tag.TagInfo;

public interface TagGroupInfo {
    public Optional<TagDictionary> getDictionary();

    public String getName();

    default public Id getGroupId() {
        if (this.getName() == null) {
            throw new IllegalStateException("TagGroup is not mounted.");
        }
        Optional<TagDictionary> d = this.getDictionary();
        return Id.newId(d.isPresent() ? d.get().getNamespace() : "", this.getName());
    }

    default public boolean isIdealFor(Type type) {
        return true;
    }

    default public boolean isValidFor(Entity entity) {
        return true;
    }

    public Iterator<TagInfo> getTags();

    public Optional<DataPolicy> getDataPolicy();

    public static Optional<TagGroupInfo> getTagGroup(Entity entity) {
        Entity endpoint;
        Optional<Relation> optRelation = entity.relations().get(Id.newId("n:tagGroup"));
        if (optRelation.isPresent() && (endpoint = optRelation.get().getEndpoint()) instanceof TagGroupInfo) {
            return Optional.of((TagGroupInfo)((Object)endpoint));
        }
        return Optional.empty();
    }

    default public void addAllImpliedTags(Entity entity, Collection<Tag> tags) {
        if (this.getDictionary().isPresent()) {
            this.getNameTagInfo().map(tagInfo -> tagInfo.getTag(entity)).ifPresent(tags::add);
            this.getTags().forEachRemaining(tagInfo -> {
                Tag tag = tagInfo.getTag(entity);
                if (tag != null) {
                    tags.add(tag);
                }
            });
        }
    }

    default public Optional<TagInfo> getNameTagInfo() {
        return Optional.empty();
    }
}

