/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.tag.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import javax.baja.tag.BasicRelation;
import javax.baja.tag.Entity;
import javax.baja.tag.Id;
import javax.baja.tag.Relation;
import javax.baja.tag.Relations;
import javax.baja.tag.util.ImpliedRelations;

public class RelationSet
implements Relations {
    private final Map<Id, Set<Relation>> relations = new HashMap<Id, Set<Relation>>();

    @Override
    public Collection<Relation> set(Id id, Collection<? extends Entity> endpoints) {
        return this.set(id, endpoints, true);
    }

    @Override
    public Collection<Relation> set(Id id, Collection<? extends Entity> endpoints, boolean isInbound) {
        HashSet<Relation> rels = new HashSet<Relation>();
        for (Entity entity : endpoints) {
            rels.add(new BasicRelation(id, entity, isInbound));
        }
        this.relations.put(id, rels);
        return rels;
    }

    @Override
    public Relation add(Relation relation) {
        Objects.requireNonNull(relation);
        Id id = relation.getId();
        if (!this.relations.containsKey(id)) {
            this.relations.put(id, new HashSet<Relation>(Collections.singletonList(relation)));
            return relation;
        }
        Set<Relation> current = this.relations.get(id);
        Optional<Relation> maybeRelation = current.stream().filter(relation::equals).findFirst();
        return maybeRelation.map(r -> {
            r.tags().merge(relation.tags().getAll());
            return r;
        }).orElseGet(() -> {
            current.add(relation);
            return relation;
        });
    }

    @Override
    public boolean remove(Relation r) {
        Id id = r.getId();
        if (this.relations.getOrDefault(id, Collections.emptySet()).remove(r)) {
            this.relations.computeIfPresent(id, (_id, current) -> current.isEmpty() ? null : current);
            return true;
        }
        return false;
    }

    @Override
    public Collection<Relation> filter(Predicate<Relation> condition, int direction) {
        ArrayList<Relation> matches = new ArrayList<Relation>();
        this.relations.forEach((? super K id, ? super V rels) -> rels.forEach(r -> {
            if (condition.test((Relation)r) && ImpliedRelations.isMatchingDirection(r, direction)) {
                matches.add((Relation)r);
            }
        }));
        return matches;
    }
}

