/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.user;

import com.tridium.nre.security.PasswordStrength;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sync.BProxyComponentSpace;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BNumber;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaException;
import javax.baja.sys.Context;
import javax.baja.sys.IPropertyValidator;
import javax.baja.sys.Localizable;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.sys.Validatable;
import javax.baja.util.LexiconText;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="minimumLength", type="int", defaultValue="10", facets={@Facet(name="BFacets.MIN", value="0")}), @NiagaraProperty(name="maximumLength", type="int", defaultValue="64", facets={@Facet(name="BFacets.MIN", value="1")}), @NiagaraProperty(name="minimumLowerCase", type="int", defaultValue="1", facets={@Facet(name="BFacets.MIN", value="0")}), @NiagaraProperty(name="minimumUpperCase", type="int", defaultValue="1", facets={@Facet(name="BFacets.MIN", value="0")}), @NiagaraProperty(name="minimumDigits", type="int", defaultValue="1", facets={@Facet(name="BFacets.MIN", value="0")}), @NiagaraProperty(name="minimumSpecial", type="int", defaultValue="0", facets={@Facet(name="BFacets.MIN", value="0")})})
public class BPasswordStrength
extends BStruct
implements IPropertyValidator {
    @Generated
    public static final Property minimumLength = BPasswordStrength.newProperty(0, 10, BFacets.make("min", 0));
    @Generated
    public static final Property maximumLength = BPasswordStrength.newProperty(0, 64, BFacets.make("min", 1));
    @Generated
    public static final Property minimumLowerCase = BPasswordStrength.newProperty(0, 1, BFacets.make("min", 0));
    @Generated
    public static final Property minimumUpperCase = BPasswordStrength.newProperty(0, 1, BFacets.make("min", 0));
    @Generated
    public static final Property minimumDigits = BPasswordStrength.newProperty(0, 1, BFacets.make("min", 0));
    @Generated
    public static final Property minimumSpecial = BPasswordStrength.newProperty(0, 0, BFacets.make("min", 0));
    @Generated
    public static final Type TYPE = Sys.loadType(BPasswordStrength.class);
    public static final BPasswordStrength DEFAULT = new BPasswordStrength(PasswordStrength.DEFAULT);
    public static final BPasswordStrength FIPS_1 = new BPasswordStrength(PasswordStrength.FIPS_1);
    public static final BPasswordStrength STRONG = DEFAULT;
    public static final BPasswordStrength OFF = new BPasswordStrength(0, 0, 0, 0, 0, Integer.MAX_VALUE);

    @Generated
    public int getMinimumLength() {
        return this.getInt(minimumLength);
    }

    @Generated
    public void setMinimumLength(int v) {
        this.setInt(minimumLength, v, null);
    }

    @Generated
    public int getMaximumLength() {
        return this.getInt(maximumLength);
    }

    @Generated
    public void setMaximumLength(int v) {
        this.setInt(maximumLength, v, null);
    }

    @Generated
    public int getMinimumLowerCase() {
        return this.getInt(minimumLowerCase);
    }

    @Generated
    public void setMinimumLowerCase(int v) {
        this.setInt(minimumLowerCase, v, null);
    }

    @Generated
    public int getMinimumUpperCase() {
        return this.getInt(minimumUpperCase);
    }

    @Generated
    public void setMinimumUpperCase(int v) {
        this.setInt(minimumUpperCase, v, null);
    }

    @Generated
    public int getMinimumDigits() {
        return this.getInt(minimumDigits);
    }

    @Generated
    public void setMinimumDigits(int v) {
        this.setInt(minimumDigits, v, null);
    }

    @Generated
    public int getMinimumSpecial() {
        return this.getInt(minimumSpecial);
    }

    @Generated
    public void setMinimumSpecial(int v) {
        this.setInt(minimumSpecial, v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BPasswordStrength() {
    }

    public BPasswordStrength(int len, int lower, int upper, int digits, int special) {
        this(len, lower, upper, digits, special, ((BNumber)maximumLength.getDefaultValue()).getInt());
    }

    public BPasswordStrength(int minLen, int lower, int upper, int digits, int special, int maxLen) {
        if (minLen < 0) {
            throw new IllegalArgumentException("Minimum password length cannot be less than 0");
        }
        if (lower < 0) {
            throw new IllegalArgumentException("Minimum lowercase password characters cannot be less than 0");
        }
        if (upper < 0) {
            throw new IllegalArgumentException("Minimum uppercase password characters cannot be less than 0");
        }
        if (digits < 0) {
            throw new IllegalArgumentException("Minimum password digits cannot be less than 0");
        }
        if (special < 0) {
            throw new IllegalArgumentException("Minimum special password characters cannot be less than 0");
        }
        if (maxLen < 1) {
            throw new IllegalArgumentException("Maximum password length cannot be less than 1");
        }
        if (minLen > maxLen) {
            throw new IllegalArgumentException("Minimum password length exceeds maximum password length");
        }
        if (BPasswordStrength.passwordRequirementsInvalid(minLen, maxLen, lower, upper, digits, special)) {
            throw new IllegalArgumentException("Maximum password length cannot be less than the combined minimum lowercase, uppercase, digit, and special characters");
        }
        this.setMinimumLength(minLen);
        this.setMinimumLowerCase(lower);
        this.setMinimumUpperCase(upper);
        this.setMinimumDigits(digits);
        this.setMinimumSpecial(special);
        this.setMaximumLength(maxLen);
    }

    public BPasswordStrength(PasswordStrength passwordStrength) {
        this(passwordStrength.getMinimumLength(), passwordStrength.getMinimumLowerCase(), passwordStrength.getMinimumUpperCase(), passwordStrength.getMinimumDigits(), passwordStrength.getMinimumSpecial(), passwordStrength.getMaximumLength());
    }

    public BPasswordStrength(BPasswordStrength passwordStrength, int maxLen) {
        this(passwordStrength.getMinimumLength(), passwordStrength.getMinimumLowerCase(), passwordStrength.getMinimumUpperCase(), passwordStrength.getMinimumDigits(), passwordStrength.getMinimumSpecial(), maxLen);
    }

    public boolean isPasswordValid(char[] password, Consumer<Localizable> messageConsumer) {
        if (messageConsumer == null) {
            messageConsumer = context -> {};
        }
        int lowerCase = 0;
        int upperCase = 0;
        int digits = 0;
        int special = 0;
        int len = password.length;
        for (char character : password) {
            if (Character.isLetter(character)) {
                if (Character.isUpperCase(character)) {
                    ++upperCase;
                    continue;
                }
                ++lowerCase;
                continue;
            }
            if (Character.isDigit(character)) {
                ++digits;
                continue;
            }
            ++special;
        }
        if (len < this.getMinimumLength() || len > this.getMaximumLength() || digits < this.getMinimumDigits() || lowerCase < this.getMinimumLowerCase() || upperCase < this.getMinimumUpperCase() || special < this.getMinimumSpecial()) {
            ArrayList<Localizable> errors = new ArrayList<Localizable>();
            errors.add(LexiconText.toLocalizable("baja", "user.password.notStrong", new Object[0]));
            errors.addAll(this.getLocalizableRequirements());
            messageConsumer.accept(Localizable.concatenate("\n- ", errors));
            return false;
        }
        return true;
    }

    public void isPasswordValid(String password) throws Exception {
        AtomicReference messageRef = new AtomicReference();
        if (!this.isPasswordValid(password.toCharArray(), messageRef::set)) {
            throw new BajaException(((Localizable)messageRef.get()).toString(null));
        }
    }

    @Override
    public void validateSet(Validatable validatable, Context context) {
        int special;
        int digits;
        int upper;
        int existingMaxLen;
        int existingMinLen;
        int proposedMinLen = ((BNumber)validatable.getProposedValue(minimumLength)).getInt();
        BComponent parent = this.getParentComponent();
        if (parent != null && !(parent.getSpace() instanceof BProxyComponentSpace) && proposedMinLen != (existingMinLen = ((BNumber)validatable.getExistingValue(minimumLength)).getInt()) && proposedMinLen < PasswordStrength.MINIMUM_ALLOWED_LENGTH) {
            throw new LocalizableRuntimeException("baja", "passwordStrength.notEnoughCharacters", new Object[]{PasswordStrength.MINIMUM_ALLOWED_LENGTH});
        }
        int proposedMaxLen = ((BNumber)validatable.getProposedValue(maximumLength)).getInt();
        if (proposedMaxLen != (existingMaxLen = ((BNumber)validatable.getExistingValue(maximumLength)).getInt()) && proposedMaxLen < 1) {
            throw new LocalizableRuntimeException("baja", "passwordStrength.invalidCharacterRequirements");
        }
        int lower = ((BNumber)validatable.getProposedValue(minimumLowerCase)).getInt();
        if (BPasswordStrength.passwordRequirementsInvalid(proposedMinLen, proposedMaxLen, lower, upper = ((BNumber)validatable.getProposedValue(minimumUpperCase)).getInt(), digits = ((BNumber)validatable.getProposedValue(minimumDigits)).getInt(), special = ((BNumber)validatable.getProposedValue(minimumSpecial)).getInt())) {
            throw new LocalizableRuntimeException("baja", "passwordStrength.invalidCharacterRequirements");
        }
    }

    @Override
    public void validateSet(BComplex instance, Property property, BValue newValue, Context context) {
        int special;
        int maxLength;
        int minLength;
        boolean isMinimumChange = minimumLength.equals(property);
        if (isMinimumChange) {
            minLength = ((BNumber)newValue).getInt();
            BComponent parent = this.getParentComponent();
            if (parent != null && !(parent.getSpace() instanceof BProxyComponentSpace) && minLength < PasswordStrength.MINIMUM_ALLOWED_LENGTH) {
                throw new LocalizableRuntimeException("baja", "passwordStrength.notEnoughCharacters", new Object[]{PasswordStrength.MINIMUM_ALLOWED_LENGTH});
            }
        } else {
            minLength = this.getMinimumLength();
        }
        boolean isMaximumChange = !isMinimumChange && maximumLength.equals(property);
        int n = maxLength = isMaximumChange ? ((BNumber)newValue).getInt() : this.getMaximumLength();
        if (isMaximumChange && maxLength < 1) {
            throw new LocalizableRuntimeException("baja", "passwordStrength.invalidCharacterRequirements");
        }
        int lower = minimumLowerCase.equals(property) ? ((BNumber)newValue).getInt() : this.getMinimumLowerCase();
        int upper = minimumUpperCase.equals(property) ? ((BNumber)newValue).getInt() : this.getMinimumUpperCase();
        int digits = minimumDigits.equals(property) ? ((BNumber)newValue).getInt() : this.getMinimumDigits();
        int n2 = special = minimumSpecial.equals(property) ? ((BNumber)newValue).getInt() : this.getMinimumSpecial();
        if (BPasswordStrength.passwordRequirementsInvalid(minLength, maxLength, lower, upper, digits, special)) {
            throw new LocalizableRuntimeException("baja", "passwordStrength.invalidCharacterRequirements");
        }
    }

    @Override
    public IPropertyValidator getPropertyValidator(Property[] properties, Context context) {
        return this;
    }

    @Override
    public IPropertyValidator getPropertyValidator(Property property, Context context) {
        return this;
    }

    public List<Localizable> getLocalizableRequirements() {
        ArrayList<Localizable> requirements = new ArrayList<Localizable>();
        if (this.getMinimumLength() > 0) {
            requirements.add(LexiconText.toLocalizable("baja", "user.password.notLongEnough", this.getMinimumLength()));
        }
        if (this.getMinimumDigits() > 0) {
            requirements.add(LexiconText.toLocalizable("baja", "user.password.notEnoughDigits", this.getMinimumDigits()));
        }
        if (this.getMinimumLowerCase() > 0) {
            requirements.add(LexiconText.toLocalizable("baja", "user.password.notEnoughLowerCase", this.getMinimumLowerCase()));
        }
        if (this.getMinimumUpperCase() > 0) {
            requirements.add(LexiconText.toLocalizable("baja", "user.password.notEnoughUpperCase", this.getMinimumUpperCase()));
        }
        if (this.getMinimumSpecial() > 0) {
            requirements.add(LexiconText.toLocalizable("baja", "user.password.notEnoughSpecial", this.getMinimumSpecial()));
        }
        if (this.getMaximumLength() < Integer.MAX_VALUE) {
            requirements.add(LexiconText.toLocalizable("baja", "user.password.notShortEnough", this.getMaximumLength()));
        }
        return requirements;
    }

    private static boolean passwordRequirementsInvalid(int minLen, int maxLen, int lower, int upper, int digits, int special) {
        return minLen < 0 || lower < 0 || upper < 0 || digits < 0 || special < 0 || maxLen < 1 || minLen > maxLen || lower + upper + digits + special > maxLen;
    }
}

