/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.user;

import com.tridium.authn.BAuthenticationService;
import com.tridium.authn.BDigestAuthenticationScheme;
import com.tridium.json.JSONObject;
import com.tridium.nre.security.NiagaraBasicPermission;
import com.tridium.session.SessionManager;
import com.tridium.sys.license.BLicenseExpirationNotificationSettings;
import com.tridium.sys.license.BSMANotificationSettings;
import com.tridium.util.ArrayUtil;
import java.security.AccessController;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.baja.authn.BAuthenticationScheme;
import javax.baja.authn.BPasswordAuthenticationScheme;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.SecurityUtil;
import javax.baja.role.BIRole;
import javax.baja.role.BIRoleListener;
import javax.baja.role.BIRoleService;
import javax.baja.role.BRoleService;
import javax.baja.rpc.NiagaraRpc;
import javax.baja.rpc.Transport;
import javax.baja.rpc.TransportType;
import javax.baja.security.AuditEvent;
import javax.baja.security.Auditor;
import javax.baja.security.BAbstractAuthenticator;
import javax.baja.security.BPassword;
import javax.baja.security.BPasswordAuthenticator;
import javax.baja.security.BPermissionsMap;
import javax.baja.space.BComponentSpace;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIService;
import javax.baja.sys.BIUnlinkableSlotsContainer;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.IPropertyValidator;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.sys.Validatable;
import javax.baja.user.BAutoLogoffSettings;
import javax.baja.user.BUser;
import javax.baja.user.BUserEvent;
import javax.baja.user.BUserPrototypes;
import javax.baja.user.PermissionsManager;
import javax.baja.user.UserMonitor;
import javax.baja.util.BIRestrictedComponent;
import javax.baja.util.BServiceContainer;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="lockOutEnabled", type="boolean", defaultValue="true", facets={@Facet(value="BFacets.make(BFacets.SECURITY, BBoolean.TRUE)")}), @NiagaraProperty(name="lockOutPeriod", type="BRelTime", defaultValue="BRelTime.make(10L*1000L)", facets={@Facet(value="BFacets.make(BFacets.SECURITY, BBoolean.TRUE)")}), @NiagaraProperty(name="maxBadLoginsBeforeLockOut", type="int", defaultValue="5", facets={@Facet(name="BFacets.MIN", value="1"), @Facet(name="BFacets.MAX", value="10"), @Facet(name="BFacets.SECURITY", value="true")}), @NiagaraProperty(name="lockOutWindow", type="BRelTime", defaultValue="BRelTime.makeSeconds(30)", facets={@Facet(name="BFacets.MIN", value="BRelTime.makeSeconds(1)"), @Facet(name="BFacets.MAX", value="BRelTime.makeHours(24)"), @Facet(name="BFacets.SECURITY", value="true")}), @NiagaraProperty(name="defaultAutoLogoffPeriod", type="BRelTime", defaultValue="BRelTime.makeMinutes(15)", facets={@Facet(name="BFacets.SHOW_SECONDS", value="false"), @Facet(name="BFacets.MIN", value="BRelTime.makeMinutes(2)"), @Facet(name="BFacets.MAX", value="BRelTime.makeHours(4)"), @Facet(name="BFacets.SECURITY", value="true")}), @NiagaraProperty(name="secureOnlyPasswordSet", type="boolean", defaultValue="true", flags=7, facets={@Facet(value="BFacets.make(BFacets.SECURITY, BBoolean.TRUE)")}), @NiagaraProperty(name="userPrototypes", type="BUserPrototypes", defaultValue="new BUserPrototypes()"), @NiagaraProperty(name="SMANotificationSettings", type="BSMANotificationSettings", defaultValue="new BSMANotificationSettings()"), @NiagaraProperty(name="licenseExpirationNotificationSettings", type="BLicenseExpirationNotificationSettings", defaultValue="new BLicenseExpirationNotificationSettings()")})
@NiagaraTopic(name="userEvent", eventType="BUserEvent")
public class BUserService
extends BComponent
implements BIService,
BIRoleListener,
BIRestrictedComponent,
IPropertyValidator,
BIUnlinkableSlotsContainer {
    @Generated
    public static final Property lockOutEnabled = BUserService.newProperty(0, true, BFacets.make("security", BBoolean.TRUE));
    @Generated
    public static final Property lockOutPeriod = BUserService.newProperty(0, BRelTime.make(10000L), BFacets.make("security", BBoolean.TRUE));
    @Generated
    public static final Property maxBadLoginsBeforeLockOut = BUserService.newProperty(0, 5, BFacets.make(BFacets.make(BFacets.make("min", 1), BFacets.make("max", 10)), BFacets.make("security", true)));
    @Generated
    public static final Property lockOutWindow = BUserService.newProperty(0, BRelTime.makeSeconds(30), BFacets.make(BFacets.make(BFacets.make("min", BRelTime.makeSeconds(1)), BFacets.make("max", BRelTime.makeHours(24))), BFacets.make("security", true)));
    @Generated
    public static final Property defaultAutoLogoffPeriod = BUserService.newProperty(0, BRelTime.makeMinutes(15), BFacets.make(BFacets.make(BFacets.make(BFacets.make("showSeconds", false), BFacets.make("min", BRelTime.makeMinutes(2))), BFacets.make("max", BRelTime.makeHours(4))), BFacets.make("security", true)));
    @Generated
    public static final Property secureOnlyPasswordSet = BUserService.newProperty(7, true, BFacets.make("security", BBoolean.TRUE));
    @Generated
    public static final Property userPrototypes = BUserService.newProperty(0, new BUserPrototypes(), null);
    @Generated
    public static final Property SMANotificationSettings = BUserService.newProperty(0, new BSMANotificationSettings(), null);
    @Generated
    public static final Property licenseExpirationNotificationSettings = BUserService.newProperty(0, new BLicenseExpirationNotificationSettings(), null);
    @Generated
    public static final Topic userEvent = BUserService.newTopic(0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BUserService.class);
    private static Type[] serviceTypes = new Type[]{TYPE};
    private static final Set<Slot> UNLINKABLE_TARGET_SLOTS = Collections.unmodifiableSet(Stream.of(maxBadLoginsBeforeLockOut, lockOutWindow, defaultAutoLogoffPeriod).collect(Collectors.toSet()));
    private static final BIcon icon = BIcon.std("navOnly/userService.png");
    private final UserMonitor monitor = new UserMonitor(this);
    private PermissionsManager[] permissionsManagers = new PermissionsManager[0];
    static final Logger log = Logger.getLogger("sys.service");

    @Generated
    public boolean getLockOutEnabled() {
        return this.getBoolean(lockOutEnabled);
    }

    @Generated
    public void setLockOutEnabled(boolean v) {
        this.setBoolean(lockOutEnabled, v, null);
    }

    @Generated
    public BRelTime getLockOutPeriod() {
        return (BRelTime)this.get(lockOutPeriod);
    }

    @Generated
    public void setLockOutPeriod(BRelTime v) {
        this.set(lockOutPeriod, (BValue)v, null);
    }

    @Generated
    public int getMaxBadLoginsBeforeLockOut() {
        return this.getInt(maxBadLoginsBeforeLockOut);
    }

    @Generated
    public void setMaxBadLoginsBeforeLockOut(int v) {
        this.setInt(maxBadLoginsBeforeLockOut, v, null);
    }

    @Generated
    public BRelTime getLockOutWindow() {
        return (BRelTime)this.get(lockOutWindow);
    }

    @Generated
    public void setLockOutWindow(BRelTime v) {
        this.set(lockOutWindow, (BValue)v, null);
    }

    @Generated
    public BRelTime getDefaultAutoLogoffPeriod() {
        return (BRelTime)this.get(defaultAutoLogoffPeriod);
    }

    @Generated
    public void setDefaultAutoLogoffPeriod(BRelTime v) {
        this.set(defaultAutoLogoffPeriod, (BValue)v, null);
    }

    @Generated
    public boolean getSecureOnlyPasswordSet() {
        return this.getBoolean(secureOnlyPasswordSet);
    }

    @Generated
    public void setSecureOnlyPasswordSet(boolean v) {
        this.setBoolean(secureOnlyPasswordSet, v, null);
    }

    @Generated
    public BUserPrototypes getUserPrototypes() {
        return (BUserPrototypes)this.get(userPrototypes);
    }

    @Generated
    public void setUserPrototypes(BUserPrototypes v) {
        this.set(userPrototypes, (BValue)v, null);
    }

    @Generated
    public BSMANotificationSettings getSMANotificationSettings() {
        return (BSMANotificationSettings)this.get(SMANotificationSettings);
    }

    @Generated
    public void setSMANotificationSettings(BSMANotificationSettings v) {
        this.set(SMANotificationSettings, (BValue)v, null);
    }

    @Generated
    public BLicenseExpirationNotificationSettings getLicenseExpirationNotificationSettings() {
        return (BLicenseExpirationNotificationSettings)this.get(licenseExpirationNotificationSettings);
    }

    @Generated
    public void setLicenseExpirationNotificationSettings(BLicenseExpirationNotificationSettings v) {
        this.set(licenseExpirationNotificationSettings, (BValue)v, null);
    }

    @Generated
    public void fireUserEvent(BUserEvent event) {
        this.fire(userEvent, event, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public static BUserService getService() {
        return (BUserService)Sys.getService(TYPE);
    }

    @Override
    public Type[] getServiceTypes() {
        return serviceTypes;
    }

    @Override
    public void serviceStarted() throws Exception {
    }

    @Override
    public void serviceStopped() throws Exception {
    }

    @Override
    public final void checkParentForRestrictedComponent(BComponent parent, Context cx) {
        BIRestrictedComponent.checkContextForSuperUser(this, cx);
        BIRestrictedComponent.checkParentForRestrictedComponent(parent, this);
    }

    public boolean isDistributable() {
        return true;
    }

    @Override
    public String getDisplayName(Slot slot, Context cx) {
        return super.getDisplayName(slot, cx);
    }

    public BUser getUser(String name) {
        BUser user = (BUser)this.get(SlotPath.escape(name));
        if (user == null) {
            return null;
        }
        if (!SecurityUtil.equals((String)user.getUsername(), (String)name)) {
            return null;
        }
        return user;
    }

    public BUser[] getUsers() {
        return this.getChildren(BUser.class);
    }

    public BUser getAdmin() {
        BUser admin;
        BValue obj = this.get("admin");
        if (obj instanceof BUser && (admin = (BUser)obj).getEnabled() && admin.getPermissions().isSuperUser()) {
            return admin;
        }
        SlotCursor<Property> c = this.getProperties();
        while (c.next(BUser.class)) {
            BUser user = (BUser)c.get();
            if (user == null || !user.getEnabled() || !user.getPermissions().isSuperUser()) continue;
            return user;
        }
        return null;
    }

    public boolean canLogin(BUser user) {
        if (!user.getEnabled()) {
            return false;
        }
        if (user.getLockOut()) {
            return false;
        }
        if (user.isExpired()) {
            return false;
        }
        if ("BACnet".equals(user.getName())) {
            return false;
        }
        return user.getAuthenticator().canLogin(user);
    }

    public BAuthenticationScheme getAuthenticationSchemeForUser(String username) {
        BUser user = username == null ? null : this.getUser(username);
        return this.getAuthenticationSchemeForUser(user);
    }

    public BAuthenticationScheme getAuthenticationSchemeForUser(BUser user) {
        BUser bUser = user = user == null ? null : this.getUser(user.getUsername());
        if (user == null) {
            BAuthenticationService authnService = (BAuthenticationService)Sys.getService(BAuthenticationService.TYPE);
            List<BAuthenticationScheme> schemes = authnService.getRemoteSchemes();
            if (!schemes.isEmpty()) {
                return schemes.get(0);
            }
            return new BDigestAuthenticationScheme();
        }
        return user.getAuthenticationScheme();
    }

    public final void auditLoginAttempt(boolean loginSuccessful, BUser user, Context auditContext) {
        if (auditContext == null) {
            return;
        }
        try {
            Auditor auditor = Sys.getAuditor();
            if (auditor != null) {
                BFacets facets = auditContext.getFacets();
                auditor.audit(new AuditEvent(loginSuccessful ? "Login" : "Login Failure", facets.gets("target", ""), facets.gets("slotName", ""), facets.gets("oldValue", ""), loginSuccessful ? "" : Integer.toString(user.authFailTimes.size()), user.getUsername()));
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @Override
    public void checkAdd(String name, BValue value, int flags, BFacets facets, Context context) {
        if (context != Context.decoding && value instanceof BUser) {
            BAuthenticationScheme scheme;
            BPassword newPassword;
            BUser newUser;
            BAbstractAuthenticator authenticator;
            if (this.isRunning() && context != null && context.getUser() != null) {
                BUser user = context.getUser();
                String newRoles = ((BUser)value).getRoles();
                BUser.checkRoleChange(user, "", newRoles);
            }
            if ((authenticator = (newUser = (BUser)value).getAuthenticator()) instanceof BPasswordAuthenticator && (newPassword = ((BPasswordAuthenticator)authenticator).getPassword()).getPasswordEncoder().isReversible() && (scheme = this.getAuthenticationScheme(newUser.getAuthenticationSchemeName())) instanceof BPasswordAuthenticationScheme) {
                BPasswordAuthenticator.checkPassword(newUser, (BPasswordAuthenticationScheme)scheme, ((BPasswordAuthenticator)authenticator).getPasswordConfig(), newPassword, context);
            }
        }
        super.checkAdd(name, value, flags, facets, context);
    }

    private BAuthenticationScheme getAuthenticationScheme(String schemeName) {
        BAuthenticationService authnService;
        block4: {
            authnService = null;
            try {
                authnService = (BAuthenticationService)Sys.getService(BAuthenticationService.TYPE);
            }
            catch (ServiceNotFoundException e) {
                BComplex parent;
                for (parent = this.getParent(); parent != null && !(parent instanceof BServiceContainer); parent = parent.getParent()) {
                }
                if (parent == null) break block4;
                BServiceContainer serviceContainer = (BServiceContainer)parent;
                serviceContainer.lease(3);
                BAuthenticationService[] services = serviceContainer.getChildren(BAuthenticationService.class);
                if (services.length <= 0) break block4;
                authnService = services[0];
            }
        }
        if (authnService == null) {
            return null;
        }
        authnService.lease(3);
        return authnService.getAuthenticationScheme(schemeName);
    }

    @Override
    public void checkRename(Property property, String newName, Context context) {
        BValue value = this.get(property);
        if (value instanceof BUser && ((BUser)value).getPermissions().isSuperUser() && context != null && context.getUser() != null && !context.getUser().getPermissions().isSuperUser()) {
            throw new LocalizableRuntimeException("wbutil", "superUser.canNotRenameSuperuser");
        }
        super.checkRename(property, newName, context);
    }

    @Override
    public void checkRemove(Property property, Context context) {
        long superUserCount;
        BValue value;
        BComponentSpace space = this.getComponentSpace();
        if ((space == null || !space.isProxyComponentSpace()) && (value = this.get(property)) instanceof BUser && this.checkSuperuser((BUser)value) && (superUserCount = this.getProperties().stream().filter(Objects::nonNull).filter(prop -> !prop.equals(property)).flatMap(prop -> prop.getType().equals(BUser.TYPE) ? Stream.of((BUser)this.get((Property)prop)) : Stream.empty()).filter(this::checkSuperuser).count()) <= 0L) {
            throw new LocalizableRuntimeException("wbutil", "superUser.canNotDeleteOnlySuperuser");
        }
        super.checkRemove(property, context);
    }

    public boolean checkSuperuser(BUser user) {
        user.lease();
        BPermissionsMap permissions = user.getPermissions();
        if (permissions.isSuperUser()) {
            return true;
        }
        BRoleService roleService = null;
        try {
            roleService = (BRoleService)Sys.getService(BRoleService.TYPE);
        }
        catch (ServiceNotFoundException snfe) {
            for (Object parent = this.getParent(); parent != null; parent = ((BComplex)parent).getParent()) {
                if (!(parent instanceof BServiceContainer)) continue;
                BRoleService[] services = ((BComponent)parent).getChildren(BRoleService.class);
                if (services == null || services.length <= 0) break;
                roleService = services[0];
                break;
            }
        }
        LinkedList<String> superUserRoles = new LinkedList<String>();
        if (roleService != null) {
            for (String roleId : roleService.getEnabledRoleIds()) {
                BIRole role = roleService.getRole(roleId);
                if (role == null || !role.getPermissions().isSuperUser()) continue;
                superUserRoles.add(roleId);
            }
        } else {
            superUserRoles.add("admin");
        }
        Set<String> userRoles = user.getRoleIds();
        for (String roleId : superUserRoles) {
            if (!userRoles.contains(SlotPath.unescape(roleId))) continue;
            return true;
        }
        return false;
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box), @Transport(type=TransportType.web)})
    public static JSONObject getAutoLogoffSettings(String username, Context cx) {
        BUserService userSvc = BUserService.getService();
        BUser user = userSvc.getUser(username);
        JSONObject obj = new JSONObject();
        if (user != null) {
            BAutoLogoffSettings autoLogoffSettings = user.getAutoLogoffSettings();
            obj.put("autoLogoffEnabled", autoLogoffSettings.getAutoLogoffEnabled());
            if (autoLogoffSettings.getUseDefaultAutoLogoffPeriod()) {
                obj.put("autoLogoffPeriod", userSvc.getDefaultAutoLogoffPeriod().getMillis());
            } else {
                obj.put("autoLogoffPeriod", autoLogoffSettings.getAutoLogoffPeriod().getMillis());
            }
        }
        return obj;
    }

    @Override
    public final IPropertyValidator getPropertyValidator(Property property, Context context) {
        if (this.isRunning() && context != null && context.getUser() != null) {
            return this;
        }
        return null;
    }

    @Override
    public final void validateSet(Validatable validatable, Context context) {
        Object[] props;
        if (this.isRunning() && context != null && context.getUser() != null && ArrayUtil.indexOf(props = validatable.getModifiedProperties(), userPrototypes) >= 0) {
            BComponent[] prototypes;
            BUserPrototypes prototypeContainer = (BUserPrototypes)validatable.getProposedValue(userPrototypes);
            for (BComponent prototype : prototypes = prototypeContainer.getPrototypes()) {
                BUserPrototypes.checkRoleChange(prototype, "", context);
            }
        }
    }

    @Deprecated
    public synchronized void addPermissionsManager(PermissionsManager pmgr) {
        this.checkPermissionsManagerAccess();
        if (this.permissionsManagers.length == 0) {
            this.permissionsManagers = new PermissionsManager[]{pmgr};
        } else {
            ArrayList<PermissionsManager> temp = new ArrayList<PermissionsManager>(Arrays.asList(this.permissionsManagers));
            temp.add(pmgr);
            this.permissionsManagers = temp.toArray(new PermissionsManager[0]);
        }
    }

    @Deprecated
    public synchronized void removePermissionsManager(PermissionsManager pmgr) {
        this.checkPermissionsManagerAccess();
        ArrayList<PermissionsManager> temp = new ArrayList<PermissionsManager>(Arrays.asList(this.permissionsManagers));
        temp.remove(pmgr);
        this.permissionsManagers = temp.toArray(new PermissionsManager[0]);
    }

    @Deprecated
    public synchronized PermissionsManager[] getPermissionsManagers() {
        this.checkPermissionsManagerAccess();
        return this.permissionsManagers;
    }

    private void checkPermissionsManagerAccess() {
        NiagaraBasicPermission permission = new NiagaraBasicPermission("NIAGARA_PERMISSIONS_MANAGER");
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)permission);
        }
    }

    public void setModified(BUser user) {
        this.monitor.setModified(user);
    }

    @Override
    public Object fw(int x, Object a, Object b, Object c, Object d) {
        if (this.monitor != null) {
            this.monitor.fw(x, a, b, c, d);
        }
        return super.fw(x, a, b, c, d);
    }

    @Override
    public void removeRole(BIRoleService service, String roleIdentifier) {
        SlotCursor<Property> sc = this.getProperties();
        while (sc.next(BUser.class)) {
            BUser user = (BUser)sc.get();
            user.removeRole(service, SlotPath.unescape(roleIdentifier), Context.skipValidate);
        }
    }

    @Override
    public void renameRole(BIRoleService service, String oldRoleIdentifier, String newRoleIdentifier) {
        String unescapedOldRoleIdentifier = SlotPath.unescape(oldRoleIdentifier);
        String unescapedNewRoleIdentifier = SlotPath.unescape(newRoleIdentifier);
        SlotCursor<Property> sc = this.getProperties();
        while (sc.next(BUser.class)) {
            BUser user = (BUser)sc.get();
            if (!user.getRoleIds().contains(unescapedOldRoleIdentifier)) continue;
            user.renameRole(service, unescapedOldRoleIdentifier, unescapedNewRoleIdentifier, Context.skipValidate);
        }
    }

    @Override
    public void changedRole(BIRoleService service, String roleIdentifier) {
        SlotCursor<Property> sc = this.getProperties();
        while (sc.next(BUser.class)) {
            BUser user = (BUser)sc.get();
            user.changedRole(service, SlotPath.unescape(roleIdentifier), Context.skipValidate);
        }
    }

    @Override
    public void removed(Property property, BValue oldValue, Context context) {
        super.removed(property, oldValue, context);
        if (!(oldValue instanceof BUser)) {
            return;
        }
        AccessController.doPrivileged(() -> {
            SessionManager.invalidateSuperSessions((BUser)oldValue);
            return null;
        });
    }

    @Override
    public void changed(Property property, Context context) {
        if (Sys.isStationStarted() && this.isMounted() && property.equals(defaultAutoLogoffPeriod)) {
            SessionManager.updateSessionTimeout(null);
        }
    }

    @Override
    public final Set<Slot> getUnlinkableTargetSlots(Context context) {
        return UNLINKABLE_TARGET_SLOTS;
    }

    @Override
    public BIcon getIcon() {
        return icon;
    }
}

