/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.util;

import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.space.BComponentSpace;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BLink;
import javax.baja.sys.BTopic;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;

@NiagaraType
public class BCompositeTopic
extends BTopic {
    @Generated
    public static final Type TYPE = Sys.loadType(BCompositeTopic.class);

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public Mirror getMirror() {
        try {
            BComponent parent = this.getParentComponent();
            if (parent == null) {
                return null;
            }
            BComponentSpace space = parent.getComponentSpace();
            if (space == null) {
                return null;
            }
            BLink[] links = parent.getLinks(this.getPropertyInParent());
            if (links.length == 0) {
                return null;
            }
            BLink link = links[0];
            BOrd ord = link.getSourceOrd();
            String slotName = link.getSourceSlotName();
            BComponent c = (BComponent)ord.get(space);
            Slot slot = c.getSlot(slotName);
            if (slot == this.getPropertyInParent()) {
                return null;
            }
            if (slot instanceof Topic || slot instanceof Action) {
                return new Mirror(link, c, slot);
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Type getEventType() {
        Mirror mirror = this.getMirror();
        if (mirror != null) {
            Slot slot = mirror.slot;
            if (slot.isAction()) {
                return slot.asAction().getParameterType();
            }
            return slot.asTopic().getEventType();
        }
        return null;
    }

    @Override
    public BFacets getFacets() {
        Mirror mirror = this.getMirror();
        if (mirror != null) {
            return mirror.component.getSlotFacets(mirror.slot);
        }
        return null;
    }

    public static class Mirror {
        public BLink link;
        public BComponent component;
        public Slot slot;

        public Mirror(BLink link, BComponent component, Slot slot) {
            this.link = link;
            this.component = component;
            this.slot = slot;
        }

        public String toString() {
            return this.component.toPathString() + "." + this.slot.getName();
        }
    }
}

