/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.baja.data.BIDataValue;
import javax.baja.data.DataUtil;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public final class BDataSet
extends BSimple {
    public static final BDataSet DEFAULT = new BDataSet();
    public static final Type TYPE = Sys.loadType(BDataSet.class);
    private final Set<BIDataValue> values;

    @Override
    public Type getType() {
        return TYPE;
    }

    public static BDataSet make(BIDataValue ... values) {
        return BDataSet.make(Arrays.asList(values));
    }

    public static BDataSet make(Collection<? extends BIDataValue> values) {
        return new BDataSet(new HashSet<BIDataValue>(values));
    }

    private BDataSet() {
        this(new HashSet<BIDataValue>());
    }

    private BDataSet(Set<BIDataValue> values) {
        BDataSet.requireHomogenous(values);
        this.values = Collections.unmodifiableSet(values);
    }

    private static void requireHomogenous(Set<BIDataValue> values) {
        Iterator<BIDataValue> iter = values.iterator();
        if (!iter.hasNext()) {
            return;
        }
        Type requiredType = iter.next().getType();
        while (iter.hasNext()) {
            Type check = iter.next().getType();
            if (requiredType.equals(check)) continue;
            throw new IllegalArgumentException("All elements in the data set must be " + requiredType + ", but found element of type " + check);
        }
    }

    public BDataSet add(BDataSet other) {
        HashSet<BIDataValue> dataset = new HashSet<BIDataValue>(this.values);
        dataset.addAll(other.values);
        return new BDataSet(dataset);
    }

    public BDataSet add(BIDataValue ... vals) {
        return this.add(BDataSet.make(vals));
    }

    public BDataSet remove(BIDataValue ... vals) {
        HashSet<BIDataValue> dataset = new HashSet<BIDataValue>(this.values);
        dataset.removeAll(Arrays.asList(vals));
        return new BDataSet(dataset);
    }

    public boolean contains(BIDataValue value) {
        return this.values.contains(value);
    }

    public int size() {
        return this.values.size();
    }

    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    public Set<BIDataValue> asImmutableSet() {
        return this.values;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BDataSet bDataSet = (BDataSet)o;
        return this.values.equals(bDataSet.values);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.values.hashCode();
        return result;
    }

    @Override
    public void encode(DataOutput encoder) throws IOException {
        encoder.writeUTF(this.encodeToString());
    }

    @Override
    public BObject decode(DataInput decoder) throws IOException {
        return this.decodeFromString(decoder.readUTF());
    }

    @Override
    public String encodeToString() throws IOException {
        if (this.values.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (BIDataValue dv : this.values) {
            sb.append(BDataSet.escape(dv)).append(',');
        }
        return sb.deleteCharAt(sb.length() - 1).toString();
    }

    private static String escape(BIDataValue dataValue) throws IOException {
        String s = DataUtil.marshal(dataValue);
        StringBuilder sb = new StringBuilder();
        for (char c : s.toCharArray()) {
            switch (c) {
                case ',': 
                case '\\': {
                    sb.append('\\');
                }
            }
            sb.append(c);
        }
        return sb.toString();
    }

    @Override
    public BObject decodeFromString(String s) throws IOException {
        if (s.isEmpty()) {
            return DEFAULT;
        }
        char[] buf = s.toCharArray();
        HashSet<BIDataValue> dataset = new HashSet<BIDataValue>();
        StringBuilder sb = new StringBuilder();
        for (int pos = 0; pos < buf.length; ++pos) {
            if (buf[pos] == ',') {
                dataset.add(DataUtil.unmarshal(sb.toString()).as(BIDataValue.class));
                sb.setLength(0);
                continue;
            }
            if (buf[pos] == '\\') {
                sb.append(buf[++pos]);
                continue;
            }
            sb.append(buf[pos]);
        }
        dataset.add(DataUtil.unmarshal(sb.toString()).as(BIDataValue.class));
        return new BDataSet(dataset);
    }

    @Override
    public Object fw(int x, Object a, Object b, Object c, Object d) {
        switch (x) {
            case 116: {
                return Boolean.TRUE;
            }
        }
        return super.fw(x, a, b, c, d);
    }
}

