/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBitString;
import javax.baja.sys.BObject;
import javax.baja.sys.BWeekday;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public final class BDaysOfWeekBits
extends BBitString {
    public static final int SUNDAY = 1;
    public static final int MONDAY = 2;
    public static final int TUESDAY = 4;
    public static final int WEDNESDAY = 8;
    public static final int THURSDAY = 16;
    public static final int FRIDAY = 32;
    public static final int SATURDAY = 64;
    public static final BDaysOfWeekBits sunday = (BDaysOfWeekBits)new BDaysOfWeekBits(1).intern();
    public static final BDaysOfWeekBits monday = (BDaysOfWeekBits)new BDaysOfWeekBits(2).intern();
    public static final BDaysOfWeekBits tuesday = (BDaysOfWeekBits)new BDaysOfWeekBits(4).intern();
    public static final BDaysOfWeekBits wednesday = (BDaysOfWeekBits)new BDaysOfWeekBits(8).intern();
    public static final BDaysOfWeekBits thursday = (BDaysOfWeekBits)new BDaysOfWeekBits(16).intern();
    public static final BDaysOfWeekBits friday = (BDaysOfWeekBits)new BDaysOfWeekBits(32).intern();
    public static final BDaysOfWeekBits saturday = (BDaysOfWeekBits)new BDaysOfWeekBits(64).intern();
    public static final BDaysOfWeekBits DEFAULT = new BDaysOfWeekBits(127);
    public static final BDaysOfWeekBits EMPTY = new BDaysOfWeekBits(0);
    public static final BDaysOfWeekBits ALL = DEFAULT;
    private static BBitString.Support support = new BBitString.Support(DEFAULT);
    public static final Type TYPE;
    private int bits;

    public static BDaysOfWeekBits make(boolean v) {
        if (v) {
            return ALL;
        }
        return EMPTY;
    }

    public static BDaysOfWeekBits make(int bits) {
        if (bits == BDaysOfWeekBits.ALL.bits) {
            return ALL;
        }
        if (bits == BDaysOfWeekBits.EMPTY.bits) {
            return EMPTY;
        }
        return (BDaysOfWeekBits)new BDaysOfWeekBits(bits).intern();
    }

    private BDaysOfWeekBits(int bits) {
        this.bits = bits;
    }

    public boolean includes(BAbsTime absTime) {
        return this.includes(absTime.getWeekday());
    }

    public int getBits() {
        return this.bits;
    }

    public boolean includes(BWeekday weekday) {
        return (this.bits & 1 << weekday.getOrdinal()) != 0;
    }

    @Override
    public boolean getBit(int ordinal) {
        return (this.bits & ordinal) != 0;
    }

    @Override
    public boolean getBit(String tag) {
        return this.getBit(this.tagToOrdinal(tag));
    }

    @Override
    public int[] getOrdinals() {
        return support.getOrdinals();
    }

    @Override
    public boolean isOrdinal(int ordinal) {
        return support.isOrdinal(ordinal);
    }

    @Override
    public String getTag(int ordinal) {
        return support.getTag(ordinal);
    }

    @Override
    public String getDisplayTag(int ordinal, Context cx) {
        return support.getDisplayTag(ordinal, cx);
    }

    @Override
    public BBitString getInstance(int[] ordinals) {
        int mask = 0;
        for (int i = 0; i < ordinals.length; ++i) {
            mask |= ordinals[i];
        }
        return BDaysOfWeekBits.make(mask);
    }

    @Override
    public boolean isTag(String tag) {
        return support.isTag(tag);
    }

    @Override
    public int tagToOrdinal(String tag) {
        return support.tagToOrdinal(tag);
    }

    @Override
    public boolean isEmpty() {
        return this.bits == 0;
    }

    public boolean isEveryDay() {
        return this.bits == BDaysOfWeekBits.ALL.bits;
    }

    @Override
    public String getEmptyTag() {
        return "none";
    }

    @Override
    public int hashCode() {
        return this.bits;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof BDaysOfWeekBits) {
            return ((BDaysOfWeekBits)obj).bits == this.bits;
        }
        return false;
    }

    @Override
    public void encode(DataOutput out) throws IOException {
        out.writeInt(this.bits);
    }

    @Override
    public BObject decode(DataInput in) throws IOException {
        return BDaysOfWeekBits.make(in.readInt());
    }

    @Override
    public String encodeToString() {
        return Integer.toHexString(this.bits);
    }

    @Override
    public BObject decodeFromString(String s) throws IOException {
        try {
            return BDaysOfWeekBits.make(Integer.parseInt(s, 16));
        }
        catch (Exception e) {
            throw new IOException("Invalid bits: " + s);
        }
    }

    @Override
    public String toString(Context cx) {
        if (this.bits == 0) {
            return "{}";
        }
        StringBuilder s = new StringBuilder();
        s.append('{');
        s.append(Stream.of(BWeekday.sunday, BWeekday.monday, BWeekday.tuesday, BWeekday.wednesday, BWeekday.thursday, BWeekday.friday, BWeekday.saturday).filter(day -> this.includes((BWeekday)day)).map(day -> day.getShortDisplayTag(cx)).collect(Collectors.joining(" ")));
        s.append('}');
        return s.toString();
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    static {
        support.add(1, "sunday");
        support.add(2, "monday");
        support.add(4, "tuesday");
        support.add(8, "wednesday");
        support.add(16, "thursday");
        support.add(32, "friday");
        support.add(64, "saturday");
        TYPE = Sys.loadType(BDaysOfWeekBits.class);
    }
}

