/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;

@NiagaraType
public final class BNameMap
extends BSimple {
    public static final BNameMap NULL;
    public static final BNameMap DEFAULT;
    public static final Type TYPE;
    private String string;
    private HashMap<String, BFormat> map;
    private int hashCode = -1;

    public static BNameMap make(HashMap<String, BFormat> map) {
        if (map.isEmpty()) {
            return NULL;
        }
        HashMap<String, BFormat> newMap = new HashMap<String, BFormat>(map);
        return (BNameMap)new BNameMap(newMap).intern();
    }

    public static BNameMap make(BNameMap orig, String name, String value) {
        return BNameMap.make(orig, name, BFormat.make(value));
    }

    public static BNameMap make(BNameMap orig, String name, BFormat value) {
        HashMap<String, BFormat> map = new HashMap<String, BFormat>(orig.map);
        map.put(name, value);
        return (BNameMap)new BNameMap(map).intern();
    }

    public static BNameMap make(BNameMap orig, BNameMap other) {
        HashMap<String, BFormat> map = new HashMap<String, BFormat>(orig.map);
        String[] otherKeys = other.list();
        for (int i = 0; i < otherKeys.length; ++i) {
            map.put(otherKeys[i], other.get(otherKeys[i]));
        }
        return (BNameMap)new BNameMap(map).intern();
    }

    public static BNameMap remove(BNameMap orig, String name) {
        HashMap<String, BFormat> map = new HashMap<String, BFormat>(orig.map);
        map.remove(name);
        return (BNameMap)new BNameMap(map).intern();
    }

    private BNameMap(HashMap<String, BFormat> map) {
        this.map = map;
    }

    public String[] list() {
        return this.map.keySet().toArray(new String[0]);
    }

    public BFormat get(String name) {
        return this.map.get(name);
    }

    @Override
    public boolean isNull() {
        return this.map.isEmpty();
    }

    @Override
    public int hashCode() {
        try {
            if (this.hashCode == -1) {
                this.hashCode = this.encodeToString().hashCode();
            }
            return this.hashCode;
        }
        catch (Exception e) {
            return System.identityHashCode(this);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof BNameMap) {
            BNameMap x = (BNameMap)obj;
            if (this.map.size() != x.map.size()) {
                return false;
            }
            for (String key : this.map.keySet()) {
                BFormat val = this.map.get(key);
                if (val.equals(x.map.get(key))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public String toString(Context context) {
        return this.encodeToString();
    }

    @Override
    public void encode(DataOutput out) throws IOException {
        out.writeUTF(this.encodeToString());
    }

    @Override
    public BObject decode(DataInput in) throws IOException {
        return this.decodeFromString(in.readUTF());
    }

    @Override
    public String encodeToString() {
        if (this.string == null) {
            StringBuilder s = new StringBuilder();
            s.append('{');
            for (String key : this.map.keySet()) {
                BFormat val = this.map.get(key);
                this.escape(s, key);
                s.append('=');
                this.escape(s, val.getFormat());
                s.append(';');
            }
            s.append('}');
            this.string = s.toString();
        }
        return this.string;
    }

    @Override
    public BObject decodeFromString(String s) throws IOException {
        try {
            int start = s.indexOf(123);
            int end = s.lastIndexOf(125);
            if (start + 1 == end) {
                return NULL;
            }
            String body = s.substring(start + 1, end);
            Array acc = new Array(String.class);
            int len = body.length();
            StringBuilder buf = new StringBuilder();
            char lastDelim = ';';
            for (int i = 0; i < len; ++i) {
                char c = body.charAt(i);
                if (c == '\\') {
                    buf.append(body.charAt(++i));
                    continue;
                }
                if (c != '=' && c != ';') {
                    buf.append(c);
                    continue;
                }
                if (c == lastDelim) {
                    throw new Exception();
                }
                lastDelim = c;
                acc.add((Object)buf.toString());
                buf.setLength(0);
            }
            HashMap<String, BFormat> map = new HashMap<String, BFormat>();
            for (int i = 0; i < acc.size(); i += 2) {
                String key = (String)acc.get(i);
                BFormat val = BFormat.make((String)acc.get(i + 1));
                map.put(key, val);
            }
            BNameMap x = (BNameMap)new BNameMap(map).intern();
            x.string = s;
            return x;
        }
        catch (Exception e) {
            throw new IOException("Invalid BNameMap: " + s);
        }
    }

    private void escape(StringBuilder buf, String s) {
        int len = s.length();
        block7: for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\\': {
                    buf.append("\\\\");
                    continue block7;
                }
                case '{': {
                    buf.append("\\{");
                    continue block7;
                }
                case '}': {
                    buf.append("\\}");
                    continue block7;
                }
                case '=': {
                    buf.append("\\=");
                    continue block7;
                }
                case ';': {
                    buf.append("\\;");
                    continue block7;
                }
                default: {
                    buf.append(c);
                }
            }
        }
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    static {
        DEFAULT = NULL = new BNameMap(new HashMap<String, BFormat>());
        TYPE = Sys.loadType(BNameMap.class);
    }
}

