/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.util;

import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BWorker;
import javax.baja.util.ThreadPoolWorker;

@NiagaraType
@NiagaraProperty(name="maxThreads", type="int", defaultValue="4", facets={@Facet(value="BFacets.make(BFacets.MIN, BInteger.make(1))")})
public abstract class BThreadPoolWorker
extends BWorker {
    @Generated
    public static final Property maxThreads = BThreadPoolWorker.newProperty(0, 4, BFacets.make("min", BInteger.make(1)));
    @Generated
    public static final Type TYPE = Sys.loadType(BThreadPoolWorker.class);

    @Generated
    public int getMaxThreads() {
        return this.getInt(maxThreads);
    }

    @Generated
    public void setMaxThreads(int v) {
        this.setInt(maxThreads, v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BThreadPoolWorker() {
    }

    public BThreadPoolWorker(int maxThreads) {
        this.setMaxThreads(maxThreads);
    }

    @Override
    public void started() throws Exception {
        super.started();
        this.updateMaxThreads();
    }

    @Override
    public void atSteadyState() throws Exception {
        super.atSteadyState();
        this.updateMaxThreads();
    }

    @Override
    public void changed(Property prop, Context cx) {
        if (this.isRunning() && prop.equals(maxThreads)) {
            this.updateMaxThreads();
            return;
        }
        super.changed(prop, cx);
    }

    void updateMaxThreads() {
        ThreadPoolWorker w = (ThreadPoolWorker)this.getWorker();
        if (w != null) {
            w.setMaxThreads(this.getMaxThreads());
        }
    }
}

