/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.util;

import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BStruct;
import javax.baja.sys.BTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="startTime", type="BTime", defaultValue="BTime.make(0,0,0,0)"), @NiagaraProperty(name="endTime", type="BTime", defaultValue="BTime.make(0,0,0,0)")})
public class BTimeRange
extends BStruct {
    @Generated
    public static final Property startTime = BTimeRange.newProperty(0, BTime.make(0, 0, 0, 0), null);
    @Generated
    public static final Property endTime = BTimeRange.newProperty(0, BTime.make(0, 0, 0, 0), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BTimeRange.class);

    @Generated
    public BTime getStartTime() {
        return (BTime)this.get(startTime);
    }

    @Generated
    public void setStartTime(BTime v) {
        this.set(startTime, (BValue)v, null);
    }

    @Generated
    public BTime getEndTime() {
        return (BTime)this.get(endTime);
    }

    @Generated
    public void setEndTime(BTime v) {
        this.set(endTime, (BValue)v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BTimeRange() {
    }

    public BTimeRange(BTime start, BTime end) {
        this.setStartTime(start);
        this.setEndTime(end);
    }

    public boolean includes(BAbsTime time) {
        return this.test(time.getTimeOfDayMillis());
    }

    public boolean includes(BTime time) {
        return this.test(time.getTimeOfDayMillis());
    }

    public boolean isAllDay() {
        return this.getStartTime().equals(this.getEndTime());
    }

    @Override
    public String toString(Context ctx) {
        return this.getStartTime().toString(ctx) + " - " + this.getEndTime().toString(ctx);
    }

    private boolean test(long time) {
        long start = this.getStartTime().getTimeOfDayMillis();
        long end = this.getEndTime().getTimeOfDayMillis();
        if (end == 0L) {
            end = 86400000L;
        }
        if (start < end) {
            return time >= start && time <= end;
        }
        return time >= start || time <= end;
    }
}

