/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.UUID;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BIComparable;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public final class BUuid
extends BSimple
implements BIComparable {
    static final char[] compactMap = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '$', '*'};
    public static final BUuid NULL = new BUuid(0L, 0L);
    public static final BUuid MIN = new BUuid(Long.MIN_VALUE, Long.MIN_VALUE);
    public static final BUuid MAX = new BUuid(Long.MAX_VALUE, Long.MAX_VALUE);
    public static final BUuid DEFAULT = NULL;
    public static final Type TYPE = Sys.loadType(BUuid.class);
    private UUID juuid;

    public static BUuid make(String s) {
        if (s.length() != 36 || s.charAt(8) != '-' || s.charAt(13) != '-' || s.charAt(18) != '-' || s.charAt(23) != '-') {
            throw new BajaRuntimeException("Invalid format for BUuid: " + s);
        }
        long mostSig = BUuid.parse(s, 0, 8) << 32 | BUuid.parse(s, 9, 4) << 16 | BUuid.parse(s, 14, 4);
        long leastSig = BUuid.parse(s, 19, 4) << 48 | BUuid.parse(s, 24, 12);
        return new BUuid(mostSig, leastSig);
    }

    public static BUuid make(long mostSig, long leastSig) {
        return new BUuid(mostSig, leastSig);
    }

    public static BUuid make(UUID uuid) {
        return new BUuid(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits());
    }

    public static BUuid make(byte[] bytes) {
        if (bytes.length != 16) {
            throw new IllegalArgumentException("Array length mismatch.");
        }
        long most = 0L;
        for (int i = 15; i >= 8; --i) {
            most <<= 8;
            most |= (long)(bytes[i] & 0xFF);
        }
        long least = 0L;
        for (int i = 7; i >= 0; --i) {
            least <<= 8;
            least |= (long)(bytes[i] & 0xFF);
        }
        return new BUuid(most, least);
    }

    public static BUuid make() {
        return new BUuid();
    }

    private BUuid(long mostSig, long leastSig) {
        this.juuid = new UUID(mostSig, leastSig);
    }

    private BUuid() {
        this.juuid = UUID.randomUUID();
    }

    public long getMostSignificant() {
        return this.juuid.getMostSignificantBits();
    }

    public long getLeastSignificant() {
        return this.juuid.getLeastSignificantBits();
    }

    public byte[] getBytes() {
        return BUuid.toBytes(this.juuid);
    }

    public static byte[] toBytes(UUID juuid) {
        byte[] bytes = new byte[16];
        long a = juuid.getMostSignificantBits();
        for (int i = 8; i < 16; ++i) {
            bytes[i] = (byte)(a & 0xFFL);
            a >>>= 8;
        }
        long b = juuid.getLeastSignificantBits();
        for (int i = 0; i < 8; ++i) {
            bytes[i] = (byte)(b & 0xFFL);
            b >>>= 8;
        }
        return bytes;
    }

    @Override
    public boolean isNull() {
        return this.juuid.getMostSignificantBits() == 0L && this.juuid.getLeastSignificantBits() == 0L;
    }

    @Override
    public int hashCode() {
        return this.juuid.hashCode();
    }

    @Override
    public int compareTo(Object o) {
        BUuid u = (BUuid)o;
        return this.juuid.compareTo(u.juuid);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof BUuid) {
            BUuid x = (BUuid)obj;
            return this.juuid.equals(x.juuid);
        }
        return false;
    }

    @Override
    public void encode(DataOutput out) throws IOException {
        out.writeLong(this.juuid.getMostSignificantBits());
        out.writeLong(this.juuid.getLeastSignificantBits());
    }

    @Override
    public BObject decode(DataInput in) throws IOException {
        return new BUuid(in.readLong(), in.readLong());
    }

    @Override
    public String encodeToString() throws IOException {
        return this.juuid.toString();
    }

    public String toCompactString() {
        StringBuilder s = new StringBuilder(28);
        long mostSig = this.juuid.getMostSignificantBits();
        long leastSig = this.juuid.getLeastSignificantBits();
        s.append(compactMap[(int)(mostSig >> 58) & 0x3F]);
        s.append(compactMap[(int)(mostSig >> 52) & 0x3F]);
        s.append(compactMap[(int)(mostSig >> 46) & 0x3F]);
        s.append(compactMap[(int)(mostSig >> 40) & 0x3F]);
        s.append(compactMap[(int)(mostSig >> 34) & 0x3F]);
        s.append(compactMap[(int)(mostSig >> 38) & 0x3F]);
        s.append(compactMap[(int)(mostSig >> 32) & 0x3F]);
        s.append(compactMap[(int)(mostSig >> 36) & 0x3F]);
        s.append(compactMap[(int)(mostSig >> 30) & 0x3F]);
        s.append(compactMap[(int)(mostSig >> 24) & 0x3F]);
        s.append(compactMap[(int)(mostSig >> 18) & 0x3F]);
        s.append(compactMap[(int)(mostSig >> 12) & 0x3F]);
        s.append(compactMap[(int)(mostSig >> 6) & 0x3F]);
        s.append(compactMap[(int)(mostSig >> 0) & 0x3F]);
        s.append(compactMap[(int)(leastSig >> 58) & 0x3F]);
        s.append(compactMap[(int)(leastSig >> 52) & 0x3F]);
        s.append(compactMap[(int)(leastSig >> 46) & 0x3F]);
        s.append(compactMap[(int)(leastSig >> 40) & 0x3F]);
        s.append(compactMap[(int)(leastSig >> 34) & 0x3F]);
        s.append(compactMap[(int)(leastSig >> 38) & 0x3F]);
        s.append(compactMap[(int)(leastSig >> 32) & 0x3F]);
        s.append(compactMap[(int)(leastSig >> 36) & 0x3F]);
        s.append(compactMap[(int)(leastSig >> 30) & 0x3F]);
        s.append(compactMap[(int)(leastSig >> 24) & 0x3F]);
        s.append(compactMap[(int)(leastSig >> 18) & 0x3F]);
        s.append(compactMap[(int)(leastSig >> 12) & 0x3F]);
        s.append(compactMap[(int)(leastSig >> 6) & 0x3F]);
        s.append(compactMap[(int)(leastSig >> 0) & 0x3F]);
        return s.toString();
    }

    @Override
    public BObject decodeFromString(String s) throws IOException {
        return BUuid.make(s);
    }

    private static long parse(String s, int start, int num) {
        long v = 0L;
        for (int i = 0; i < num; ++i) {
            v <<= 4;
            v |= (long)BUuid.hexCharToInt(s, start + i);
        }
        return v;
    }

    private static int hexCharToInt(String s, int index) {
        char c = s.charAt(index);
        int x = c - 48;
        if (x >= 0 && x <= 9) {
            return x;
        }
        x = c - 65 + 10;
        if (x >= 10 && x <= 15) {
            return x;
        }
        x = c - 97 + 10;
        if (x >= 10 && x <= 15) {
            return x;
        }
        throw new BajaRuntimeException("Invalid format for BUuid: " + s);
    }

    @Override
    public Type getType() {
        return TYPE;
    }
}

