/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.util;

import javax.baja.util.QueueFullException;
import javax.baja.util.Worker;

public class Queue
implements Worker.ITodo {
    Entry head;
    Entry tail;
    int size;
    int maxSize;

    public Queue(int maxSize) {
        this.maxSize = maxSize;
    }

    public Queue() {
        this(Integer.MAX_VALUE);
    }

    public int size() {
        return this.size;
    }

    public int maxSize() {
        return this.maxSize;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean isFull() {
        return this.size == this.maxSize;
    }

    public synchronized Object tail() {
        if (this.tail == null) {
            return null;
        }
        return this.tail.value;
    }

    public synchronized Object peek() {
        if (this.head == null) {
            return null;
        }
        return this.head.value;
    }

    public synchronized Object peek(int timeout) throws InterruptedException {
        while (this.size == 0) {
            if (timeout == -1) {
                this.wait();
                continue;
            }
            this.wait(timeout);
            break;
        }
        return this.peek();
    }

    public synchronized Object find(Object value) {
        Entry e = this.head;
        while (e != null) {
            if (e.value.equals(value)) {
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    public synchronized Object dequeue() {
        Entry entry = this.head;
        if (entry == null) {
            return null;
        }
        this.head = entry.next;
        if (this.head == null) {
            this.tail = null;
        }
        entry.next = null;
        --this.size;
        return entry.value;
    }

    public synchronized Object dequeue(int timeout) throws InterruptedException {
        while (this.size == 0) {
            if (timeout == -1) {
                this.wait();
                continue;
            }
            this.wait(timeout);
            break;
        }
        return this.dequeue();
    }

    public synchronized boolean enqueue(Object value) throws QueueFullException {
        if (this.size >= this.maxSize) {
            throw new QueueFullException();
        }
        if (value == null) {
            throw new NullPointerException();
        }
        Entry entry = this.newEntry(value);
        entry.next = null;
        if (this.tail == null) {
            this.head = this.tail = entry;
        } else {
            this.tail.next = entry;
            this.tail = entry;
        }
        ++this.size;
        this.notifyAll();
        return true;
    }

    public synchronized boolean push(Object value) throws QueueFullException {
        if (this.size >= this.maxSize) {
            throw new QueueFullException();
        }
        if (value == null) {
            throw new NullPointerException();
        }
        Entry entry = this.newEntry(value);
        entry.next = null;
        if (this.head == null) {
            this.head = this.tail = entry;
        } else {
            entry.next = this.head;
            this.head = entry;
        }
        ++this.size;
        this.notifyAll();
        return true;
    }

    Entry newEntry(Object v) {
        return new Entry(v);
    }

    public synchronized Object[] toArray() {
        Object[] a = new Object[this.size];
        Entry p = this.head;
        int i = 0;
        while (p != null) {
            a[i] = p.value;
            p = p.next;
            ++i;
        }
        return a;
    }

    public synchronized void clear() {
        this.size = 0;
        this.head = null;
        this.tail = null;
        this.notifyAll();
    }

    @Override
    public Runnable todo(int timeout) throws InterruptedException {
        return (Runnable)this.dequeue(timeout);
    }

    static class Entry {
        Entry next;
        Object value;

        Entry(Object v) {
            this.value = v;
        }
    }
}

