/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.util;

import java.security.AccessController;
import javax.baja.nre.util.Array;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Clock;
import javax.baja.util.Worker;

public class ThreadPoolWorker
extends Worker {
    static final long IDLE_THREAD_EXPIRATION = AccessController.doPrivileged(() -> (long)Long.getLong("niagara.threadPoolWorker.idleExpiration", 10000L));
    private static final long SPY_MAX_THREAD_COUNT = AccessController.doPrivileged(() -> (long)Long.getLong("niagara.threadPoolWorker.spyMaxThreadCount", 1000L));
    int maxThreads = 4;
    final ThreadPool pool = new ThreadPool();
    volatile int expiredWorkers = 0;

    public ThreadPoolWorker(Worker.ITodo todo) {
        super(todo);
    }

    public int getMaxThreads() {
        return this.maxThreads;
    }

    public void setMaxThreads(int maxThreads) {
        if (maxThreads < 1) {
            throw new IllegalArgumentException("" + maxThreads + " < 1");
        }
        this.maxThreads = maxThreads;
    }

    @Override
    public void start(ThreadGroup threadGroup, String threadName) {
        if (this.isAlive) {
            return;
        }
        this.pool.start();
        super.start(threadGroup, threadName);
    }

    @Override
    public void stop() {
        this.isAlive = false;
        this.pool.stop();
        super.stop();
    }

    @Override
    protected void process(Runnable work) throws Exception {
        this.pool.run(work);
    }

    protected void threadStarted() {
    }

    protected void threadStopped() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeThread(WorkerThread t) {
        try {
            Array<WorkerThread> array = this.pool.threads;
            synchronized (array) {
                this.pool.threads.remove((Object)t);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        ++this.expiredWorkers;
    }

    @Override
    void spyImpl(SpyWriter out) {
        super.spyImpl(out);
        out.prop((Object)"maxThreads", "" + this.maxThreads);
        Array<WorkerThread> threads = this.pool.threads;
        out.prop((Object)"currentThreadCount", threads != null ? "" + threads.size() : "null");
        out.prop((Object)"busyThreadCount", "" + this.getBusyThreadCount());
        out.prop((Object)"expiredThreadCount", "" + this.expiredWorkers);
        out.prop((Object)"spyMaxThreadCount", String.valueOf(SPY_MAX_THREAD_COUNT));
        if (threads != null) {
            for (int i = 0; i < threads.size() && (long)i <= SPY_MAX_THREAD_COUNT; ++i) {
                WorkerThread t = (WorkerThread)threads.get(i);
                out.trTitle("Worker[" + i + "] " + t.getName(), 2);
                out.prop((Object)"work", String.valueOf(t.work));
                ThreadPoolWorker.spy(out, t.startTime, t.startTicks, t.processingTicks, t.numProcessed);
            }
        }
    }

    private int getBusyThreadCount() {
        Array<WorkerThread> pThreads = this.pool.threads;
        if (pThreads == null) {
            return 0;
        }
        WorkerThread[] t = (WorkerThread[])pThreads.array();
        int size = t.length;
        int count = 0;
        for (int i = 0; i < size; ++i) {
            try {
                if (t[i].work == null) continue;
                ++count;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return count;
    }

    class WorkerThread
    extends Thread {
        volatile Runnable work;
        volatile boolean reduced;
        long startTime;
        long startTicks;
        int numProcessed;
        long processingTicks;
        long lastJobTicks;
        final Object lock;

        WorkerThread(ThreadGroup group, String name) {
            super(group, name);
            this.lock = new Object();
            this.startTime = Clock.millis();
            this.lastJobTicks = this.startTicks = Clock.ticks();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void run(Runnable work) {
            Object object = this.lock;
            synchronized (object) {
                if (this.work != null) {
                    throw new IllegalStateException();
                }
                this.work = work;
                this.lock.notifyAll();
            }
        }

        boolean isBusy() {
            return this.work != null || this.reduced;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void reduce() {
            Object object = this.lock;
            synchronized (object) {
                System.out.println("ThreadPoolWorker reduce: " + this);
                this.reduced = true;
                this.lock.notifyAll();
            }
        }

        boolean isActive() {
            return ThreadPoolWorker.this.isAlive && !this.reduced;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                ThreadPoolWorker.this.threadStarted();
                while (this.isActive()) {
                    Object object;
                    while (this.isActive() && this.work == null) {
                        object = this.lock;
                        synchronized (object) {
                            try {
                                this.lock.wait(IDLE_THREAD_EXPIRATION);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            if (IDLE_THREAD_EXPIRATION > 0L && Clock.ticks() - this.lastJobTicks > IDLE_THREAD_EXPIRATION && this.work == null) {
                                this.reduced = true;
                            }
                        }
                    }
                    if (!this.isActive()) {
                        return;
                    }
                    try {
                        long t2;
                        long t1 = Clock.ticks();
                        this.work.run();
                        this.lastJobTicks = t2 = Clock.ticks();
                        ++this.numProcessed;
                        this.processingTicks += t2 - t1;
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                    object = this.lock;
                    synchronized (object) {
                        this.work = null;
                    }
                }
                return;
            }
            finally {
                ThreadPoolWorker.this.removeThread(this);
                ThreadPoolWorker.this.threadStopped();
            }
        }
    }

    class ThreadPool {
        Array<WorkerThread> threads;

        ThreadPool() {
        }

        void start() {
            if (this.threads != null) {
                throw new IllegalStateException();
            }
            this.threads = new Array(WorkerThread.class);
        }

        void stop() {
            if (this.threads == null) {
                return;
            }
            WorkerThread[] myThreads = (WorkerThread[])this.threads.trim();
            if (myThreads != null) {
                for (int i = 0; i < myThreads.length; ++i) {
                    try {
                        myThreads[i].interrupt();
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            this.threads = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void run(Runnable work) throws InterruptedException {
            while (ThreadPoolWorker.this.isAlive) {
                Array<WorkerThread> array = this.threads;
                synchronized (array) {
                    while (this.threads.size() > ThreadPoolWorker.this.maxThreads) {
                        WorkerThread t = (WorkerThread)this.threads.remove(this.threads.size() - 1);
                        t.reduce();
                    }
                    for (int i = 0; i < this.threads.size(); ++i) {
                        WorkerThread t = (WorkerThread)this.threads.get(i);
                        if (t.isBusy()) continue;
                        t.run(work);
                        return;
                    }
                    if (this.threads.size() < ThreadPoolWorker.this.maxThreads) {
                        ThreadGroup group = ThreadPoolWorker.this.thread.getThreadGroup();
                        String name = ThreadPoolWorker.this.thread.getName() + "-" + this.threads.size();
                        WorkerThread t = new WorkerThread(group, name);
                        this.threads.add((Object)t);
                        t.start();
                        t.run(work);
                        return;
                    }
                }
                Thread.sleep(250L);
            }
        }
    }
}

