/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.virtual;

import javax.baja.category.BCategoryMask;
import javax.baja.naming.BHost;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nav.BINavNode;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.space.AuditableSpace;
import javax.baja.space.BComponentSpace;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.LexiconText;
import javax.baja.virtual.BVirtualComponent;
import javax.baja.virtual.BVirtualGateway;
import javax.baja.virtual.VirtualCacheCallbacks;

@NiagaraType
@AuditableSpace
public class BVirtualComponentSpace
extends BComponentSpace {
    @Generated
    public static final Type TYPE = Sys.loadType(BVirtualComponentSpace.class);
    VirtualCacheCallbacks virtualCacheCallbacks = null;
    final BVirtualGateway gateway;
    boolean isRunning = false;
    final Object lock = new Object();

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BVirtualComponentSpace(String name, LexiconText lexText, BOrd ordInSession, BVirtualGateway gateway) {
        super(name, lexText, BOrd.make(gateway.getOrdInSession(), "virtual:"));
        this.gateway = gateway;
        this.setVirtualCacheCallbacks(new VirtualCacheCallbacks(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start() {
        Object object = this.lock;
        synchronized (object) {
            if (this.isRunning) {
                return;
            }
            BComponent currentRoot = this.getRootComponent();
            if (currentRoot == null) {
                throw new IllegalStateException("Cannot start virtual space due to null root component.");
            }
            if (this.virtualCacheCallbacks == null) {
                throw new IllegalStateException("Cannot start virtual space due to null virtual cache callbacks.");
            }
            currentRoot.start();
            this.virtualCacheCallbacks.start();
            this.isRunning = true;
            this.started();
        }
    }

    public void started() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isRunning) {
                return;
            }
            this.virtualCacheCallbacks.stop();
            this.getRootComponent().stop();
            this.isRunning = false;
            this.stopped();
        }
    }

    public void stopped() {
    }

    public final boolean isRunning() {
        return this.isRunning;
    }

    public final BVirtualGateway getVirtualGateway() {
        return this.gateway;
    }

    public final VirtualCacheCallbacks getVirtualCacheCallbacks() {
        return this.virtualCacheCallbacks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setVirtualCacheCallbacks(VirtualCacheCallbacks virtualCacheCallbacks) {
        Object object = this.lock;
        synchronized (object) {
            if (this.isRunning) {
                throw new IllegalStateException("Cannot set virtual cache callbacks because the virtual space is already running.");
            }
            this.virtualCacheCallbacks = virtualCacheCallbacks;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setRootComponent(BComponent root) {
        Object object = this.lock;
        synchronized (object) {
            if (this.isRunning) {
                throw new IllegalStateException("Cannot set root component because the virtual space is already running.");
            }
            super.setRootComponent(root);
        }
    }

    @Override
    public boolean isSpaceReadonly() {
        return true;
    }

    @Override
    public BHost getHost() {
        return this.gateway.getSpace().getHost();
    }

    @Override
    public BISession getSession() {
        return this.gateway.getSpace().getSession();
    }

    @Override
    public BOrd getAbsoluteOrd() {
        return BOrd.make(this.gateway.getAbsoluteOrd(), "virtual:");
    }

    @Override
    public BOrd getOrdInHost() {
        return BOrd.make(this.gateway.getOrdInHost(), "virtual:");
    }

    @Override
    public final BOrd getNavOrd() {
        return this.gateway.getNavOrd();
    }

    @Override
    public final BINavNode getNavParent() {
        return this.gateway;
    }

    @Override
    public void spy(SpyWriter out) throws Exception {
        out.startProps();
        out.trTitle("VirtualComponentSpace", 2);
        out.prop((Object)"isRunning", this.isRunning);
        out.endProps();
        if (this.virtualCacheCallbacks != null) {
            this.virtualCacheCallbacks.spy(out);
        }
        super.spy(out);
        BComponent root = this.getRootComponent();
        if (root != null) {
            out.startProps();
            out.trTitle("VirtualComponentSpace Root Component", 2);
            out.endProps();
            root.spy(out);
        }
    }

    @Override
    public Object fw(int x, Object a, Object b, Object c, Object d) {
        if (x == 104 && this.gateway != null) {
            if (a instanceof SlotPath[]) {
                SlotPath[] paths = (SlotPath[])a;
                int len = paths.length;
                BOrd[] ords = new BOrd[len];
                BOrd rootNavOrd = this.getNavOrd();
                for (int i = 0; i < len; ++i) {
                    ords[i] = BOrd.make(rootNavOrd, paths[i]).normalize();
                }
                this.gateway.ensureVirtualsLoaded(ords);
            } else {
                this.gateway.ensureVirtualsLoaded((BOrd[])a);
            }
        }
        if (x == 110) {
            this.touch((BOrd[])a);
        }
        return super.fw(x, a, b, c, d);
    }

    void touch(BOrd[] ordsInSpace) {
        if (ordsInSpace == null) {
            return;
        }
        for (int i = 0; i < ordsInSpace.length; ++i) {
            try {
                BObject obj = ordsInSpace[i].get(this);
                if (!(obj instanceof BVirtualComponent)) continue;
                ((BVirtualComponent)obj).updateTicks();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public BCategoryMask getCategoryMask() {
        BVirtualGateway vg = this.getVirtualGateway();
        if (vg == null) {
            return super.getCategoryMask();
        }
        return vg.getCategoryMask();
    }

    @Override
    public BCategoryMask getAppliedCategoryMask() {
        BVirtualGateway vg = this.getVirtualGateway();
        if (vg == null) {
            return super.getAppliedCategoryMask();
        }
        return vg.getAppliedCategoryMask();
    }
}

