/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.history;

import com.tridium.bacnet.datatypes.BTrendEvent;
import com.tridium.bacnet.history.BBacnetActivePeriod;
import com.tridium.bacnet.history.BBacnetEnumTrendRecord;
import com.tridium.bacnet.history.BBacnetTrendRecord;
import com.tridium.bacnet.history.BIBacnetTrendLogExt;
import com.tridium.bacnet.history.BacnetTrendLogUtil;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.bacnet.export.BOutOfServiceExt;
import javax.baja.bacnet.io.ErrorType;
import javax.baja.history.ext.BEnumCovHistoryExt;
import javax.baja.history.ext.BHistoryExt;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BLong;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperty(name="totalRecordCount", type="long", defaultValue="BLong.make(0)", flags=1)
@NiagaraActions(value={@NiagaraAction(name="startLogging"), @NiagaraAction(name="stopLogging")})
public class BBacnetEnumCovTrendLogExt
extends BEnumCovHistoryExt
implements BIBacnetTrendLogExt {
    @Generated
    public static final Property totalRecordCount = BBacnetEnumCovTrendLogExt.newProperty((int)1, (BValue)BLong.make((long)0L), null);
    @Generated
    public static final Action startLogging = BBacnetEnumCovTrendLogExt.newAction((int)0, null);
    @Generated
    public static final Action stopLogging = BBacnetEnumCovTrendLogExt.newAction((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetEnumCovTrendLogExt.class);
    private BBacnetEnumTrendRecord rec;
    private boolean trigger = false;
    private static final Logger logger = Logger.getLogger("bacnet.server");
    private Object SEQUENCE_LOCK = new Object();

    @Override
    @Generated
    public long getTotalRecordCount() {
        return this.getLong(totalRecordCount);
    }

    @Override
    @Generated
    public void setTotalRecordCount(long v) {
        this.setLong(totalRecordCount, v, null);
    }

    @Generated
    public void startLogging() {
        this.invoke(startLogging, null, null);
    }

    @Generated
    public void stopLogging() {
        this.invoke(stopLogging, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.rec = new BBacnetEnumTrendRecord();
        if (!(this.getActivePeriod() instanceof BBacnetActivePeriod)) {
            this.setActivePeriod(new BBacnetActivePeriod());
        }
        if (Sys.atSteadyState()) {
            BacnetTrendLogUtil.initHistoryExt((BHistoryExt)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void atSteadyState() {
        block9: {
            if (this.isRunning()) {
                try {
                    BAbsTime timestamp = BAbsTime.make();
                    if (!this.getActivePeriod().isActive(timestamp) || !this.getEnabled()) break block9;
                    Object object = this.SEQUENCE_LOCK;
                    synchronized (object) {
                        this.trigger = true;
                        long sequenceNumber = BacnetTrendLogUtil.incrementSequenceNumber(this.getTotalRecordCount());
                        BTrendEvent event = BTrendEvent.LOG_STATUS_ENABLED;
                        BStatus status = BStatus.DEFAULT;
                        BacnetTrendLogUtil.writeEvent(this, timestamp, status, sequenceNumber, event);
                    }
                    BacnetTrendLogUtil.initHistoryExt((BHistoryExt)this);
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "Error storing log status enabled event", e);
                }
                finally {
                    this.trigger = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changed(Property p, Context cx) {
        super.changed(p, cx);
        if (!this.isRunning()) {
            return;
        }
        if (p.equals(enabled)) {
            if (!this.isParentLegal(this.getParent().asComponent())) {
                log.severe("Tried to enable BacnetTrendLogExt inside an illegal parent!?");
                this.setEnabled(false);
            } else {
                try {
                    Object object = this.SEQUENCE_LOCK;
                    synchronized (object) {
                        this.trigger = true;
                        BAbsTime timestamp = BAbsTime.make();
                        if (this.getEnabled()) {
                            BacnetTrendLogUtil.writeEvent(this, timestamp, this.getStatus(), BacnetTrendLogUtil.incrementSequenceNumber(this.getTotalRecordCount()), BTrendEvent.LOG_STATUS_ENABLED);
                        } else {
                            BacnetTrendLogUtil.writeEvent(this, timestamp, this.getStatus(), BacnetTrendLogUtil.incrementSequenceNumber(this.getTotalRecordCount()), BTrendEvent.LOG_STATUS_DISABLED);
                        }
                    }
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "Error storing event", e);
                }
                finally {
                    this.trigger = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clockChanged(BRelTime shift) throws Exception {
        if (this.getEnabled()) {
            try {
                Object object = this.SEQUENCE_LOCK;
                synchronized (object) {
                    BAbsTime timestamp = BAbsTime.now();
                    if (shift.getMillis() < 0L) {
                        BacnetTrendLogUtil.checkBackwardsShift(this, timestamp);
                    }
                    this.trigger = true;
                    long sequenceNumber = BacnetTrendLogUtil.incrementSequenceNumber(this.getTotalRecordCount());
                    BTrendEvent event = BTrendEvent.makeTimeChange(shift.getSeconds());
                    BStatus status = this.getStatus();
                    BacnetTrendLogUtil.writeEvent(this, timestamp, status, sequenceNumber, event);
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error storing event", logger.isLoggable(Level.FINE) ? e : null);
            }
            finally {
                this.trigger = false;
            }
        }
        super.clockChanged(shift);
    }

    public void doStartLogging() {
        this.setEnabled(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doStopLogging() {
        try {
            Object object = this.SEQUENCE_LOCK;
            synchronized (object) {
                this.trigger = true;
                BAbsTime timestamp = BAbsTime.make();
                BacnetTrendLogUtil.writeEvent(this, timestamp, BStatus.DEFAULT, BacnetTrendLogUtil.incrementSequenceNumber(this.getTotalRecordCount()), BTrendEvent.LOG_STATUS_DISABLED);
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Error storing event", e);
        }
        finally {
            this.trigger = false;
            this.setEnabled(false);
        }
    }

    public Type getRecordType() {
        return BBacnetEnumTrendRecord.TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeRecord(BAbsTime timestamp, BStatusValue out) throws IOException {
        Object object = this.SEQUENCE_LOCK;
        synchronized (object) {
            BacnetTrendLogUtil.writeRecord(this, timestamp, out);
        }
    }

    @Override
    public boolean getTrigger() {
        return this.trigger;
    }

    protected boolean isChange(BStatusValue oldValue, BStatusValue newValue) {
        BOutOfServiceExt oosext = BacnetTrendLogUtil.getOosExt((BHistoryExt)this);
        if (oosext != null && oosext.getOutOfService()) {
            newValue.setValueValue(oosext.getPresentValue());
        }
        return super.isChange(oldValue, newValue);
    }

    @Override
    public BBacnetTrendRecord getRecord() {
        return this.rec;
    }

    @Override
    public ErrorType setLogInterval(long logInterval, Context cx) {
        return null;
    }
}

