/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.history;

import com.tridium.bacnet.history.BAbstractBacnetHistory;
import com.tridium.bacnet.history.BacnetTrendLogUtil;
import com.tridium.bacnet.services.confirmed.ReadRangeAck;
import java.util.logging.Level;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.datatypes.BBacnetDateTime;
import javax.baja.bacnet.datatypes.BBacnetLogRecord;
import javax.baja.bacnet.io.RejectException;
import javax.baja.driver.history.ArchiveException;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.BIHistory;
import javax.baja.history.BIHistoryRecordSet;
import javax.baja.history.HistorySpaceConnection;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.sys.BComplex;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BBacnetHistoryImport
extends BAbstractBacnetHistory
implements BacnetConst {
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetHistoryImport.class);

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public void doExecute() throws ArchiveException {
        if (!this.isRunning()) {
            return;
        }
        BBacnetDevice device = this.device();
        if (device.isOperational()) {
            if (!this.device().isServiceSupported("readRange")) {
                throw new ArchiveException(lex.getText("serviceNotSupported.readRange"));
            }
            this.importHistoryData();
        }
    }

    private void importHistoryData() throws ArchiveException {
        BBacnetDevice device = this.device();
        if (!this.overridesConfigured) {
            this.configureOverrides();
        }
        BHistoryDatabase db = this.getHistoryDb();
        this.verifyLocalNameFormat();
        BIHistory history = null;
        try (HistorySpaceConnection conn = db.getConnection(null);){
            int count;
            BBacnetDateTime referenceTime;
            int rangeType;
            long referenceIndex;
            block34: {
                history = this.getOrCreateHistory(conn);
                if (history == null) {
                    throw new ArchiveException("Cannot create history for " + this);
                }
                referenceIndex = -1L;
                rangeType = 6;
                referenceTime = this.getReferenceTime();
                count = this.getMaxRecordsPerRequest();
                if (count == 0) {
                    count = 10;
                }
                if (this.getAlwaysRequestByReferenceTime()) {
                    rangeType = 7;
                    break block34;
                }
                if (device.getProtocolRevision() < 3) {
                    rangeType = 4;
                    break block34;
                }
                referenceIndex = this.determineNextIndex();
                if (referenceIndex >= 0L) break block34;
                this.executeOk();
                return;
            }
            try {
                ReadRangeAck prevResponse = null;
                boolean moreItems = true;
                while (moreItems) {
                    ReadRangeAck response = null;
                    try {
                        response = this.client().readRange(device.getAddress(), this.getObjectId(), 131, -1, rangeType, referenceIndex, referenceTime, count);
                    }
                    catch (RejectException e) {
                        if (e.getRejectReason() != 6) continue;
                        this.setAlwaysRequestByReferenceTime(true);
                        rangeType = 7;
                        continue;
                    }
                    if (response == null) {
                        logger.info("Error importing history data for " + this + ": null response from device!");
                        break;
                    }
                    if (((Object)response).equals(prevResponse)) {
                        logger.info("Error importing history data for " + this + ": duplicate response (loop?):\nResponse:" + response);
                        break;
                    }
                    prevResponse = response;
                    byte[] encodedValue = response.getItemData();
                    if (encodedValue == null || encodedValue.length == 0) break;
                    moreItems = response.isMoreItems() || !response.includesLastItem();
                    this.asnIn.setBuffer(encodedValue);
                    long currentSeqNum = response.getFirstSequenceNumber();
                    if (currentSeqNum == -1L) {
                        currentSeqNum = BacnetTrendLogUtil.incrementSequenceNumber(this.getLastSequenceNumberProcessed());
                    }
                    Array a = new Array(BBacnetLogRecord.class);
                    while (this.asnIn.peekTag() != -1) {
                        BBacnetLogRecord entry = new BBacnetLogRecord();
                        entry.readAsn(this.asnIn);
                        a.add((Object)entry);
                    }
                    BBacnetLogRecord[] recs = (BBacnetLogRecord[])a.trim();
                    BBacnetLogRecord lstRec = recs[recs.length - 1];
                    this.getReferenceTime().copyFrom((BComplex)lstRec.getTimestamp());
                    this.setLastSequenceNumberProcessed(response.getFirstSequenceNumber() + (long)recs.length - 1L);
                    for (int i = 0; i < recs.length; ++i) {
                        BBacnetLogRecord entry = recs[i];
                        if (recordLogger.isLoggable(Level.FINEST)) {
                            recordLogger.finest(this.getSlotPath() + ": Trend Log import; for the BACnet log record " + entry + "; log type: " + entry.getLogDatum().getType());
                        }
                        try {
                            BHistoryRecord rec = entry.initializeNiagaraRecord(history.getConfig().makeRecord(), currentSeqNum);
                            conn.append(history, (BIHistoryRecordSet)this.correctTimestamp(rec));
                        }
                        catch (Exception e) {
                            logger.severe("Ignore trend record " + currentSeqNum + ":" + e.toString());
                            if (!logger.isLoggable(Level.FINE)) break;
                            logger.log(Level.FINE, "Stack Trace:", e);
                            break;
                        }
                        currentSeqNum = BacnetTrendLogUtil.incrementSequenceNumber(currentSeqNum);
                    }
                    if (!moreItems) continue;
                    referenceIndex = BacnetTrendLogUtil.incrementSequenceNumber(this.getLastSequenceNumberProcessed());
                    referenceTime = this.getReferenceTime();
                }
                this.executeOk();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Exception reading range (device " + device.getAddress() + ", id " + (Object)((Object)this.getObjectId()) + ", rangeType " + rangeType + ", referenceIndex " + referenceIndex + ", referenceTime " + referenceTime + ", count " + count + ")", e);
                throw new ArchiveException((Throwable)e);
            }
        }
    }
}

