/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.history;

import com.tridium.bacnet.history.BBacnetActivePeriod;
import com.tridium.bacnet.history.BBacnetStringIntervalTrendLogExt;
import com.tridium.bacnet.history.BacnetTrendLogUtil;
import java.io.IOException;
import java.util.logging.Level;
import javax.baja.bacnet.export.BOutOfServiceExt;
import javax.baja.control.BControlPoint;
import javax.baja.data.BIDataValue;
import javax.baja.history.BCollectionInterval;
import javax.baja.history.ext.BHistoryExt;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="activePeriod", type="BActivePeriod", defaultValue="new BBacnetActivePeriod()", facets={@Facet(value="BFacets.make(\"alwaysExpand\", true)")}, override=true), @NiagaraProperty(name="interval", type="BRelTime", defaultValue="BRelTime.makeMinutes(15)", facets={@Facet(name="BFacets.MIN", value="BRelTime.make(0L)")}, override=true)})
public class BBacnetStringTrendLogExt
extends BBacnetStringIntervalTrendLogExt {
    @Generated
    public static final Property activePeriod = BBacnetStringTrendLogExt.newProperty((int)0, (BValue)new BBacnetActivePeriod(), (BFacets)BFacets.make((String)"alwaysExpand", (boolean)true));
    @Generated
    public static final Property interval = BBacnetStringTrendLogExt.newProperty((int)0, (BValue)BRelTime.makeMinutes((int)15), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.make((long)0L)));
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetStringTrendLogExt.class);
    private BStatusValue lastValue;

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public void changed(Property p, Context cx) {
        if (p.equals(interval)) {
            if (this.isCovMode()) {
                BControlPoint point;
                super.deactivated(null, null);
                if (this.getActive() && (point = this.getParentPoint()) != null) {
                    BStatusValue value = point.getStatusValue();
                    this.updateLastValue(value);
                    try {
                        this.writeRecord(BAbsTime.make(), value);
                    }
                    catch (IOException e) {
                        log.log(Level.SEVERE, "Could not write record for trend log extension " + this, log.isLoggable(Level.FINE) ? e : null);
                    }
                }
            } else {
                if (this.lastValue != null) {
                    BControlPoint point;
                    if (this.getActive() && (point = this.getParentPoint()) != null) {
                        BStatusValue value = point.getStatusValue();
                        try {
                            this.writeRecord(BAbsTime.make(), value);
                        }
                        catch (IOException e) {
                            log.log(Level.SEVERE, "Could not write record for trend log extension " + this, log.isLoggable(Level.FINE) ? e : null);
                        }
                    }
                    this.lastValue = null;
                }
                if (this.isValidInterval(this.getInterval()) && this.getActive()) {
                    this.scheduleCollection(BAbsTime.make());
                }
            }
            return;
        }
        super.changed(p, cx);
    }

    @Override
    protected boolean initHistoryExt() {
        return false;
    }

    @Override
    public void started() throws Exception {
        super.started();
        this.getHistoryConfig().setInterval(BCollectionInterval.IRREGULAR);
    }

    public void activated(BAbsTime startTime, BAbsTime currentTime, BStatusValue value) throws IOException {
        if (this.isCovMode()) {
            this.updateLastValue(value);
            this.writeRecord(currentTime, value);
        } else {
            super.activated(startTime, currentTime, value);
        }
    }

    public void deactivated(BAbsTime currentTime, BStatusValue value) {
        if (this.isCovMode()) {
            this.updateLastValue(value);
            try {
                this.writeRecord(currentTime, value);
            }
            catch (IOException e) {
                log.log(Level.SEVERE, "Could not write record for trend log extension " + this, log.isLoggable(Level.FINE) ? e : null);
            }
        } else {
            super.deactivated(currentTime, value);
        }
    }

    private void updateLastValue(BStatusValue value) {
        if (this.lastValue == null) {
            this.lastValue = (BStatusValue)value.newCopy(true);
        } else {
            this.lastValue.copyFrom((BComplex)value);
        }
    }

    public void pointChanged(BAbsTime timestamp, BStatusValue out) throws IOException {
        if (this.isCovMode()) {
            if (this.lastValue == null) {
                this.lastValue = (BStatusValue)out.newCopy(true);
                this.writeRecord(timestamp, out);
            } else if (this.isChange(this.lastValue, out)) {
                this.lastValue.copyFrom((BComplex)out);
                this.writeRecord(timestamp, out);
            }
        }
    }

    public boolean isCovMode() {
        return this.getInterval().getMillis() == 0L;
    }

    protected boolean isChange(BStatusValue oldValue, BStatusValue newValue) {
        String oldString;
        BOutOfServiceExt oosext = BacnetTrendLogUtil.getOosExt((BHistoryExt)this);
        if (oosext != null && oosext.getOutOfService()) {
            newValue.setValueValue(oosext.getPresentValue());
        }
        if (!oldValue.getStatus().equals((Object)newValue.getStatus())) {
            return true;
        }
        String newString = ((BStatusString)newValue).getValue();
        return !newString.equals(oldString = ((BStatusString)oldValue).getValue());
    }

    public void updateStatus() {
        BStatus prevStatus = this.getStatus();
        String prevFaultCause = this.getFaultCause();
        super.updateStatus();
        BStatus statusAfterUpdate = this.getStatus();
        String faultCauseAfterUpdate = this.getFaultCause();
        if (this.getInterval().getMillis() == 0L && this.getFaultCause().startsWith("Invalid interval")) {
            if (prevStatus.isFault() && !prevFaultCause.equals(faultCauseAfterUpdate)) {
                this.setStatus(prevStatus);
                this.setFaultCause(prevFaultCause);
            } else if (!prevStatus.isFault() && !prevFaultCause.equals(faultCauseAfterUpdate)) {
                this.setStatus(BStatus.makeFault((BStatus)statusAfterUpdate, (boolean)false));
                this.setFaultCause(prevFaultCause);
            } else {
                this.setStatus(BStatus.makeFault((BStatus)statusAfterUpdate, (boolean)false));
                this.setFaultCause("");
            }
        }
    }

    protected boolean isValidInterval(BRelTime time) {
        return time.getMillis() >= 0L;
    }

    public BStatusValue getLastValue() {
        return this.lastValue;
    }
}

