/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.history;

import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.history.BAbstractBacnetHistory;
import com.tridium.bacnet.history.BacnetTrendLogUtil;
import com.tridium.bacnet.services.confirmed.ReadRangeAck;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.datatypes.BBacnetDateTime;
import javax.baja.bacnet.datatypes.BBacnetDeviceObjectPropertyReference;
import javax.baja.bacnet.datatypes.BBacnetLogMultipleRecord;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.util.PropertyInfo;
import javax.baja.driver.history.ArchiveException;
import javax.baja.driver.util.BDescriptorState;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.BHistorySpace;
import javax.baja.history.BIHistory;
import javax.baja.history.BIHistoryRecordSet;
import javax.baja.history.HistorySpaceConnection;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.sys.BComplex;
import javax.baja.sys.BObject;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperty(name="localHistoryNames", type="String", defaultValue="", flags=1)
public class BBacnetTrendLogMultipleImport
extends BAbstractBacnetHistory
implements BacnetConst {
    @Generated
    public static final Property localHistoryNames = BBacnetTrendLogMultipleImport.newProperty((int)1, (String)"", null);
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetTrendLogMultipleImport.class);
    public static final Logger logger = Logger.getLogger("bacnet.history");
    public static final Lexicon lex = Lexicon.make((String)"bacnet");
    String[] prevNams = null;

    @Generated
    public String getLocalHistoryNames() {
        return this.getString(localHistoryNames);
    }

    @Generated
    public void setLocalHistoryNames(String v) {
        this.setString(localHistoryNames, v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public void doExecute() throws ArchiveException {
        if (!this.isRunning()) {
            return;
        }
        BBacnetDevice device = this.device();
        if (!device.isServiceSupported("readRange")) {
            this.executeFail(lex.getText("serviceNotSupported.readRange"));
            return;
        }
        BHistoryDatabase db = this.getHistoryDb();
        this.verifyLocalNameFormat();
        try (HistorySpaceConnection conn = db.getConnection(null);){
            BIHistory[] hist = this.getOrCreateHistories(conn);
            long referenceIndex = -1L;
            int rangeType = 6;
            BBacnetDateTime referenceTime = this.getReferenceTime();
            int count = this.getMaxRecordsPerRequest();
            if (count == 0) {
                count = 10;
            }
            try {
                if (this.getAlwaysRequestByReferenceTime()) {
                    rangeType = 7;
                } else {
                    referenceIndex = this.determineNextIndex();
                    if (referenceIndex < 0L) {
                        this.executeOk();
                        return;
                    }
                }
                ReadRangeAck prevResponse = null;
                boolean moreItems = true;
                while (moreItems) {
                    ReadRangeAck response = this.client().readRange(device.getAddress(), this.getObjectId(), 131, -1, rangeType, referenceIndex, referenceTime, count);
                    if (response == null) {
                        logger.info("Error importing history data for " + this + ": null response from device!");
                        break;
                    }
                    if (((Object)response).equals(prevResponse)) {
                        logger.info("Error importing history data for " + this + ": duplicate response (loop?):\nResponse:" + response);
                        break;
                    }
                    prevResponse = response;
                    byte[] encodedValue = response.getItemData();
                    if (encodedValue == null || encodedValue.length == 0) break;
                    moreItems = response.isMoreItems() || !response.includesLastItem();
                    this.asnIn.setBuffer(encodedValue);
                    long currentSeqNum = response.getFirstSequenceNumber();
                    if (currentSeqNum == -1L) {
                        currentSeqNum = BacnetTrendLogUtil.incrementSequenceNumber(this.getLastSequenceNumberProcessed());
                    }
                    Array a = new Array(BBacnetLogMultipleRecord.class);
                    while (this.asnIn.peekTag() != -1) {
                        BBacnetLogMultipleRecord entry = new BBacnetLogMultipleRecord(this.asnIn);
                        entry.setHistoryImport(this);
                        a.add((Object)entry);
                    }
                    BBacnetLogMultipleRecord[] recs = (BBacnetLogMultipleRecord[])a.trim();
                    BBacnetLogMultipleRecord lstRec = recs[recs.length - 1];
                    this.getReferenceTime().copyFrom((BComplex)lstRec.getTimestamp());
                    this.setLastSequenceNumberProcessed(response.getFirstSequenceNumber() + (long)recs.length - 1L);
                    for (int i = 0; i < recs.length; ++i) {
                        BBacnetLogMultipleRecord entry = recs[i];
                        for (int n = 0; n < hist.length; ++n) {
                            if (hist[n] == null) continue;
                            try {
                                BHistoryRecord rec = entry.initializeNiagaraRecord(hist[n].getConfig().makeRecord(), currentSeqNum, n);
                                conn.append(hist[n], (BIHistoryRecordSet)this.correctTimestamp(rec));
                                continue;
                            }
                            catch (Exception e) {
                                logger.log(Level.SEVERE, this.getSlotPath() + ": Trend Log Multiple import; for the BACnet log multiple record " + entry + " for multiple logged records index " + n + "; current sequence number: " + currentSeqNum + ", error: " + e, logger.isLoggable(Level.FINE) ? e : null);
                            }
                        }
                        currentSeqNum = BacnetTrendLogUtil.incrementSequenceNumber(currentSeqNum);
                    }
                    if (!moreItems) continue;
                    referenceIndex = BacnetTrendLogUtil.incrementSequenceNumber(this.getLastSequenceNumberProcessed());
                    referenceTime = this.getReferenceTime();
                }
                this.executeOk();
            }
            catch (Exception e) {
                this.executeFail(e);
                logger.log(Level.SEVERE, "Asn Exception reading range (device " + device.getAddress() + ", id " + (Object)((Object)this.getObjectId()) + ", rangeType " + rangeType + ", referenceIndex " + referenceIndex + ", referenceTime " + referenceTime + ", count " + count + ")", e);
                throw new ArchiveException((Throwable)e);
            }
            finally {
                this.setState(BDescriptorState.idle);
            }
        }
    }

    private BBacnetDeviceObjectPropertyReference[] getDeviceObjectProps() throws ArchiveException {
        try {
            byte[] ba = this.client().readProperty(this.device().getAddress(), this.getObjectId(), 132);
            this.oprChange = this.prev == null || !ByteArrayUtil.equals((byte[])ba, (byte[])this.prev);
            this.prev = ba;
            this.asnIn.setBuffer(ba);
            Array opra = new Array(BBacnetDeviceObjectPropertyReference.class);
            while (this.asnIn.available() > 0) {
                BBacnetDeviceObjectPropertyReference opr = new BBacnetDeviceObjectPropertyReference();
                opr.readAsn(this.asnIn);
                opra.add((Object)opr);
            }
            return (BBacnetDeviceObjectPropertyReference[])opra.trim();
        }
        catch (Throwable e) {
            throw new ArchiveException(e);
        }
    }

    private String[] getHistoryNames(BBacnetDeviceObjectPropertyReference[] opra) throws ArchiveException {
        if (!this.oprChange && this.prevNams != null) {
            return this.prevNams;
        }
        try {
            BBacnetDevice dev = this.device();
            Hashtable<BBacnetObjectIdentifier, String> hash = new Hashtable<BBacnetObjectIdentifier, String>();
            Array namAl = new Array(String.class);
            for (int i = 0; i < opra.length; ++i) {
                BBacnetObjectIdentifier objId = opra[i].getObjectId();
                String nam = (String)hash.get((Object)objId);
                if (nam == null) {
                    try {
                        byte[] ba = this.client().readProperty(dev.getAddress(), objId, 77);
                        nam = AsnUtil.fromAsnCharacterString(ba);
                    }
                    catch (Throwable e) {
                        nam = objId.toShortString();
                    }
                    hash.put(objId, nam);
                }
                if (nam.length() > 0) {
                    int propId = opra[i].getPropertyId();
                    PropertyInfo pi = dev.getPropertyInfo(objId.getId(), propId);
                    nam = pi != null ? this.getLocalHistoryName() + "_" + nam + "_" + pi.getName() : this.getLocalHistoryName() + "_" + nam + "_p" + propId;
                }
                namAl.add((Object)nam);
            }
            this.prevNams = (String[])namAl.trim();
            this.setLocalHistoryNames(this.toDelimitedString(this.prevNams));
            return this.prevNams;
        }
        catch (Throwable e) {
            throw new ArchiveException(e);
        }
    }

    private String toDelimitedString(String[] a) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < a.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(a[i]);
        }
        return sb.toString();
    }

    private static String[] getStringArray(String s) {
        StringTokenizer st = new StringTokenizer(s, ",");
        int tokCnt = st.countTokens();
        String[] b = new String[tokCnt];
        for (int i = 0; i < tokCnt; ++i) {
            b[i] = st.nextToken();
        }
        return b;
    }

    public String[] getLocalHistoryNamesArray() {
        return BBacnetTrendLogMultipleImport.getStringArray(this.getLocalHistoryNames());
    }

    private BIHistory[] getOrCreateHistories(HistorySpaceConnection conn) {
        BBacnetDeviceObjectPropertyReference[] opra = this.getDeviceObjectProps();
        String[] histNames = this.getHistoryNames(opra);
        BIHistory[] hista = new BIHistory[opra.length];
        for (int i = 0; i < opra.length; ++i) {
            BTypeSpec ts;
            hista[i] = null;
            BHistoryId id = BHistoryId.make((String)this.device().getName(), (String)histNames[i]);
            if (id == null) continue;
            hista[i] = conn.getHistory(id);
            if (hista[i] != null || (ts = this.getTypeSpec(opra[i])) == null) continue;
            hista[i] = this.createHistory(conn, ts, id);
        }
        return hista;
    }

    public BIHistory[] getHistories() {
        BHistorySpace space = (BHistorySpace)BOrd.make((String)"history:").get((BObject)this);
        String[] histNams = BBacnetTrendLogMultipleImport.getStringArray(this.getLocalHistoryNames());
        if (space == null || histNams.length == 0) {
            return new BIHistory[0];
        }
        BIHistory[] hists = new BIHistory[histNams.length];
        for (int i = 0; i < hists.length; ++i) {
            BHistoryId id = BHistoryId.make((String)this.getParent().getParent().getName(), (String)histNams[i]);
            try (HistorySpaceConnection conn = space.getConnection(null);){
                hists[i] = conn.getHistory(id);
                continue;
            }
        }
        return hists;
    }
}

